/*
 * Decompiled with CFR 0.152.
 */
package fmpp.models;

import fmpp.models.JSONNode;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateSequenceModel;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class JSONObjectNode
extends JSONNode
implements TemplateHashModelEx {
    private static final long serialVersionUID = 1L;
    public static final String NODE_TYPE = "object";
    public static final String DEFAULT_NODE_NAME = JSONObjectNode.nodeTypeToDefaultNodeName("object");
    private final Map map;

    public JSONObjectNode(JSONNode parentNode, String nodeName, Map map) {
        super(parentNode, nodeName);
        this.map = map;
    }

    public String getNodeType() throws TemplateModelException {
        return NODE_TYPE;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        return JSONObjectNode.wrap(this.map.get(key), this, key, false);
    }

    public boolean isEmpty() throws TemplateModelException {
        return this.map.isEmpty();
    }

    public int size() throws TemplateModelException {
        return this.map.size();
    }

    public TemplateSequenceModel getChildNodes() throws TemplateModelException {
        return new JSONChildNodeSequence(this.map.entrySet());
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        return new JSONKeyCollection(this.map.keySet());
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        return new JSONValueCollection(this.map.entrySet());
    }

    protected String getDefaultNodeName() {
        return DEFAULT_NODE_NAME;
    }

    private class JSONValueCollection
    implements TemplateCollectionModel {
        private final Collection values;

        private JSONValueCollection(Collection values) {
            this.values = values;
        }

        public TemplateModelIterator iterator() throws TemplateModelException {
            return new TemplateModelIterator(){
                Iterator it;
                {
                    this.it = JSONValueCollection.this.values.iterator();
                }

                public boolean hasNext() throws TemplateModelException {
                    return this.it.hasNext();
                }

                public TemplateModel next() throws TemplateModelException {
                    Map.Entry entry = (Map.Entry)this.it.next();
                    return JSONNode.wrap(entry.getValue(), JSONObjectNode.this, (String)entry.getKey(), false);
                }
            };
        }
    }

    private class JSONKeyCollection
    implements TemplateCollectionModel {
        private final Collection values;

        private JSONKeyCollection(Collection values) {
            this.values = values;
        }

        public TemplateModelIterator iterator() throws TemplateModelException {
            return new TemplateModelIterator(){
                Iterator it;
                {
                    this.it = JSONKeyCollection.this.values.iterator();
                }

                public boolean hasNext() throws TemplateModelException {
                    return this.it.hasNext();
                }

                public TemplateModel next() throws TemplateModelException {
                    return JSONNode.wrap(this.it.next(), JSONObjectNode.this, null, false);
                }
            };
        }
    }

    private class JSONChildNodeSequence
    implements TemplateSequenceModel,
    TemplateCollectionModel {
        private final Collection entries;
        private TemplateNodeModel[] wrappedValues;

        private JSONChildNodeSequence(Collection entries) {
            this.entries = entries;
        }

        public TemplateModelIterator iterator() throws TemplateModelException {
            if (this.wrappedValues == null) {
                this.initializeWrappedValues();
            }
            return new TemplateModelIterator(){
                private int nextIdx;

                public boolean hasNext() throws TemplateModelException {
                    return this.nextIdx < JSONChildNodeSequence.this.wrappedValues.length;
                }

                public TemplateModel next() throws TemplateModelException {
                    return JSONChildNodeSequence.this.wrappedValues[this.nextIdx++];
                }
            };
        }

        public TemplateModel get(int idx) throws TemplateModelException {
            TemplateNodeModel[] wrappedValues = this.wrappedValues;
            if (wrappedValues == null) {
                wrappedValues = this.initializeWrappedValues();
            }
            if (idx < 0 || idx >= wrappedValues.length) {
                throw new TemplateModelException("JSON object child node index out of bounds: " + idx + " is outside 0.." + (wrappedValues.length - 1));
            }
            return wrappedValues[idx];
        }

        protected TemplateNodeModel[] initializeWrappedValues() throws TemplateModelException {
            TemplateNodeModel[] wrappedValues = new TemplateNodeModel[this.size()];
            int dstIdx = 0;
            Iterator it = this.entries.iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                wrappedValues[dstIdx++] = JSONNode.wrap(entry.getValue(), JSONObjectNode.this, (String)entry.getKey(), true);
            }
            this.wrappedValues = wrappedValues;
            return wrappedValues;
        }

        public int size() throws TemplateModelException {
            return this.entries.size();
        }
    }
}

