/*
 * Decompiled with CFR 0.152.
 */
package fmpp.tdd;

import fmpp.DataModelBuildingException;
import fmpp.Engine;
import fmpp.tdd.EvaluationEnvironment;
import fmpp.tdd.FunctionCall;
import fmpp.tdd.Interpreter;
import fmpp.tdd.TddUtil;
import fmpp.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataLoaderEvaluationEnvironment
implements EvaluationEnvironment {
    private final Engine eng;
    private final List mapStack = new ArrayList();
    private int disableMapStacking;

    public DataLoaderEvaluationEnvironment(Engine eng) {
        this.eng = eng;
    }

    public Object evalFunctionCall(FunctionCall fc, Interpreter ip) throws Exception {
        if (fc.getName().equals("get")) {
            Map m = null;
            List args = fc.getParams();
            int ln = args.size();
            for (int i = 0; i < ln; ++i) {
                Object o = args.get(i);
                if (!(o instanceof String)) {
                    throw new DataModelBuildingException("Parameters to function \"get\" must be strings, but parameter at position " + (i + 1) + " is a " + Interpreter.getTypeName(o) + ".");
                }
                String name = (String)o;
                o = m == null ? this.findTopLevelVariable(name) : m.get(name);
                if (o == null) {
                    if (i == 0) {
                        throw new DataModelBuildingException("No variable with name " + StringUtil.jQuote(name) + " exists.");
                    }
                    throw new DataModelBuildingException("No sub-variable with name " + StringUtil.jQuote(name) + " exists " + "(referred by parameter at position " + (i + 1) + ").");
                }
                if (i == ln - 1) {
                    return o;
                }
                if (!(o instanceof Map)) {
                    throw new DataModelBuildingException("Parameter at position " + (i + 1) + " must be the name of a hash variable, but " + "it is the name of a " + Interpreter.getTypeName(o) + " variable.");
                }
                m = (Map)o;
            }
            throw new DataModelBuildingException("Function \"get\" needs at least 1 arguments. get(name, subName, subSubName, ...)");
        }
        return TddUtil.getDataLoaderInstance(this.eng, fc.getName()).load(this.eng, fc.getParams());
    }

    protected Object findTopLevelVariable(String name) {
        for (int x = this.mapStack.size() - 1; x >= 0; --x) {
            Object o = ((Map)this.mapStack.get(x)).get(name);
            if (o == null) continue;
            return o;
        }
        return this.eng.getData(name);
    }

    public Object notify(int event, Interpreter ip, String name, Object extra) {
        if (event == 4 || event == 3) {
            ++this.disableMapStacking;
        } else if (event == -4 || event == -3) {
            --this.disableMapStacking;
        } else if (this.disableMapStacking == 0) {
            if (event == 5) {
                this.mapStack.add(extra);
            } else if (event == -5) {
                this.mapStack.remove(this.mapStack.size() - 1);
            }
        }
        return null;
    }
}

