/*
 * Decompiled with CFR 0.152.
 */
package fmpp.tdd;

import fmpp.Engine;
import fmpp.dataloaders.CsvDataLoader;
import fmpp.dataloaders.EvalDataLoader;
import fmpp.dataloaders.HtmlUtilsDataLoader;
import fmpp.dataloaders.JSONDataLoader;
import fmpp.dataloaders.NowDataLoader;
import fmpp.dataloaders.PropertiesDataLoader;
import fmpp.dataloaders.SlicedTextDataLoader;
import fmpp.dataloaders.TddDataLoader;
import fmpp.dataloaders.TddSequenceDataLoader;
import fmpp.dataloaders.TextDataLoader;
import fmpp.tdd.DataLoader;
import fmpp.tdd.EvalException;
import fmpp.util.InstallationException;
import fmpp.util.MiscUtil;

public class TddUtil {
    public static DataLoader getDataLoaderInstance(Engine eng, String dlName) throws EvalException {
        DataLoader dl;
        Class clazz;
        if (eng == null) {
            throw new IllegalArgumentException("Parameter eng can't be null.");
        }
        if (dlName.equals("properties")) {
            return new PropertiesDataLoader();
        }
        if (dlName.equals("json")) {
            return new JSONDataLoader();
        }
        if (dlName.equals("tdd")) {
            return new TddDataLoader();
        }
        if (dlName.equals("tddSequence")) {
            return new TddSequenceDataLoader();
        }
        if (dlName.equals("text")) {
            return new TextDataLoader();
        }
        if (dlName.equals("slicedText")) {
            return new SlicedTextDataLoader();
        }
        if (dlName.equals("csv")) {
            return new CsvDataLoader();
        }
        if (dlName.equals("eval")) {
            return new EvalDataLoader();
        }
        if (dlName.equals("htmlUtils")) {
            return new HtmlUtilsDataLoader();
        }
        if (dlName.equals("xhtmlUtils")) {
            HtmlUtilsDataLoader f = new HtmlUtilsDataLoader();
            f.setXHtml(true);
            return f;
        }
        if (dlName.equals("now")) {
            return new NowDataLoader();
        }
        if (dlName.equals("antProperty")) {
            dlName = "fmpp.dataloaders.AntPropertyDataLoader";
        } else if (dlName.equals("antProperties")) {
            dlName = "fmpp.dataloaders.AntPropertiesDataLoader";
        } else if (dlName.equals("antTask")) {
            dlName = "fmpp.dataloaders.AntTaskDataLoader";
        } else if (dlName.equals("antProject")) {
            dlName = "fmpp.dataloaders.AntProjectDataLoader";
        } else if (dlName.equals("xmlInfoset")) {
            try {
                eng.checkXmlSupportAvailability("Usage of xmlInfoset data loader.");
            }
            catch (InstallationException e) {
                throw new EvalException("Can't get xmlInfoset data loader", e);
            }
            dlName = "fmpp.dataloaders.XmlInfosetDataLoader";
        } else if (dlName.equals("xml")) {
            try {
                eng.checkXmlSupportAvailability("Usage of xml data loader.");
            }
            catch (InstallationException e) {
                throw new EvalException("Can't get xml data loader", e);
            }
            dlName = "fmpp.dataloaders.XmlDataLoader";
        }
        if (Character.isLowerCase(dlName.charAt(0)) && dlName.indexOf(46) == -1) {
            throw new EvalException("Unknown data loader: " + dlName);
        }
        try {
            clazz = MiscUtil.classForName(dlName);
        }
        catch (ClassNotFoundException exc) {
            throw new EvalException("Data loader class not found: " + dlName);
        }
        if (clazz.isInterface()) {
            throw new EvalException("Data loader class must be a class, but this is an interface: " + clazz.getName());
        }
        if (!DataLoader.class.isAssignableFrom(clazz)) {
            throw new EvalException("Data loader class must implement fmpp.tdd.DataLoader interface, but this class doesn't implement that: " + clazz.getName());
        }
        try {
            dl = (DataLoader)clazz.newInstance();
        }
        catch (InstantiationException exc) {
            throw new EvalException("Failed to create an instance of " + clazz.getName() + ": " + exc);
        }
        catch (IllegalAccessException exc) {
            throw new EvalException("Failed to create an instance of " + clazz.getName() + ": " + exc);
        }
        return dl;
    }
}

