/*
 * Decompiled with CFR 0.152.
 */
package fmpp.tools;

import fmpp.ProcessingException;
import fmpp.progresslisteners.AntProgressListener;
import fmpp.progresslisteners.LoggerProgressListener;
import fmpp.setting.FileWithSettingValue;
import fmpp.setting.SettingException;
import fmpp.setting.Settings;
import fmpp.util.MiscUtil;
import fmpp.util.RuntimeExceptionCC;
import fmpp.util.StringUtil;
import freemarker.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class AntTask
extends MatchingTask {
    private Properties initialOps = new Properties();
    private File dir;
    private String configuration;
    private boolean hasSourceFileAttr;
    private boolean antTaskFailOnError = true;
    private Boolean alwaysCreateDirsAltName;
    private Boolean sourceRootAltName;
    private Boolean outputRootAltName;

    public void setConfiguration(File outputFile) {
        this.configuration = outputFile.getAbsolutePath();
    }

    public void setAntTaskFailOnError(boolean antTaskFailOnError) {
        this.antTaskFailOnError = antTaskFailOnError;
    }

    public void setConfigurationBase(File f) {
        this.initialOps.setProperty("configurationBase", f.getAbsolutePath());
    }

    public void setInheritConfiguration(File f) {
        this.initialOps.setProperty("inheritConfiguration", f.getAbsolutePath());
    }

    public void setOutputFile(File outputFile) {
        this.initialOps.setProperty("outputFile", outputFile.getAbsolutePath());
    }

    public void setOutputRoot(File outputRoot) {
        this.setOutputRoot_common(outputRoot, false);
    }

    public void setDestDir(File outputRoot) {
        this.setOutputRoot_common(outputRoot, true);
    }

    public void setOutputRoot_common(File outputRoot, boolean alt) {
        Boolean oAlt;
        Boolean bl = oAlt = alt ? Boolean.TRUE : Boolean.FALSE;
        if (this.outputRootAltName != null && this.outputRootAltName != oAlt) {
            throw new IllegalArgumentException("Can't use synonymous attributes together: outputroot and destdir");
        }
        this.outputRootAltName = oAlt;
        this.initialOps.setProperty("outputRoot", outputRoot.getAbsolutePath());
    }

    public void setSourceFile(File sourceFile) {
        this.hasSourceFileAttr = true;
        this.initialOps.setProperty("sources", StringUtil.jQuote(sourceFile.getAbsolutePath()));
    }

    public void setSourceRoot(File sourceRoot) {
        this.setSourceRoot_common(sourceRoot, false);
    }

    public void setSrcDir(File sourceRoot) {
        this.setSourceRoot_common(sourceRoot, true);
    }

    public void setSourceRoot_common(File sourceRoot, boolean alt) {
        Boolean oAlt;
        Boolean bl = oAlt = alt ? Boolean.TRUE : Boolean.FALSE;
        if (this.sourceRootAltName != null && this.sourceRootAltName != oAlt) {
            throw new IllegalArgumentException("Can't use synonymous attributes together: sourceroot and srcdir");
        }
        this.sourceRootAltName = oAlt;
        this.initialOps.setProperty("sourceRoot", sourceRoot.getAbsolutePath());
    }

    public void setFreemarkerIncompatibleImprovements(String fmIcI) {
        this.initialOps.setProperty("freemarkerIncompatibleImprovements", fmIcI);
    }

    public void setObjectWrapper(String objectWrapper) {
        this.initialOps.setProperty("objectWrapper", objectWrapper);
    }

    public void setFreemarkerLinks(String freemarkerLinks) {
        this.initialOps.setProperty("freemarkerLinks", freemarkerLinks);
    }

    public void setBorders(String border) {
        if (this.initialOps.getProperty("borders") != null) {
            throw this.newMultipleDefinitionsException("borders");
        }
        this.initialOps.setProperty("borders", border);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.initialOps.setProperty("caseSensitive", String.valueOf(caseSensitive));
    }

    public void setDataRoot(File dataRoot) {
        this.initialOps.setProperty("dataRoot", dataRoot.getAbsolutePath());
    }

    public void setData(String data) {
        if (this.initialOps.getProperty("data") != null) {
            throw this.newMultipleDefinitionsException("data");
        }
        this.initialOps.setProperty("data", data);
    }

    public void setLocalData(String localData) {
        if (this.initialOps.getProperty("localData") != null) {
            throw this.newMultipleDefinitionsException("localData");
        }
        this.initialOps.setProperty("localData", localData);
    }

    public void setTurns(String turn) {
        if (this.initialOps.getProperty("turns") != null) {
            throw this.newMultipleDefinitionsException("turns");
        }
        this.initialOps.setProperty("turns", turn);
    }

    public void setExpert(boolean expert) {
        this.initialOps.setProperty("expert", String.valueOf(expert));
    }

    public void setAlwaysCreateDirs(boolean copy) {
        this.setAlwaysCreateDirs_common(copy, true);
    }

    public void setAlwaysCreateDirectories(boolean copy) {
        this.setAlwaysCreateDirs_common(copy, false);
    }

    private void setAlwaysCreateDirs_common(boolean copy, boolean alt) {
        Boolean oAlt;
        Boolean bl = oAlt = alt ? Boolean.TRUE : Boolean.FALSE;
        if (this.alwaysCreateDirsAltName != null && this.alwaysCreateDirsAltName != oAlt) {
            throw new IllegalArgumentException("Can't use synonymous attributes together: alwaysCreateDirs and alwaysCreateDirectories");
        }
        this.alwaysCreateDirsAltName = oAlt;
        this.initialOps.setProperty("alwaysCreateDirectories", String.valueOf(copy));
    }

    public void setLocale(String locale) {
        this.initialOps.setProperty("locale", locale);
    }

    public void setLogFile(File logFile) {
        if (!logFile.equals(this.getProject().getBaseDir())) {
            this.initialOps.setProperty("logFile", logFile.getAbsolutePath());
        }
    }

    public void setAppendLogFile(boolean append) {
        this.initialOps.setProperty("appendLogFile", String.valueOf(append));
    }

    public void setModes(String mode) {
        if (this.initialOps.getProperty("modes") != null) {
            throw this.newMultipleDefinitionsException("modes");
        }
        this.initialOps.setProperty("modes", mode);
    }

    public void setNumberFormat(String numberFormat) {
        this.initialOps.setProperty("numberFormat", numberFormat);
    }

    public void setBooleanFormat(String booleanFormat) {
        this.initialOps.setProperty("booleanFormat", booleanFormat);
    }

    public void setDateFormat(String dateFormat) {
        this.initialOps.setProperty("dateFormat", dateFormat);
    }

    public void setTimeFormat(String timeFormat) {
        this.initialOps.setProperty("timeFormat", timeFormat);
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.initialOps.setProperty("datetimeFormat", dateTimeFormat);
    }

    public void setTimeZone(String timeZone) {
        this.initialOps.setProperty("timeZone", timeZone);
    }

    public void setSQLDateAndTimeTimeZone(String timeZone) {
        this.initialOps.setProperty("sqlDateAndTimeTimeZone", timeZone);
    }

    public void setTagSyntax(String tagSyntax) {
        this.initialOps.setProperty("tagSyntax", tagSyntax);
    }

    public void setOutputEncoding(String outputEncoding) {
        this.initialOps.setProperty("outputEncoding", outputEncoding);
    }

    public void setUrlEscapingCharset(String urlEscapingCharset) {
        this.initialOps.setProperty("urlEscapingCharset", urlEscapingCharset);
    }

    public void setXpathEngine(String engine) {
        this.initialOps.setProperty("xpathEngine", engine);
    }

    public void setXmlCatalogFiles(String files) {
        this.initialOps.setProperty("xmlCatalogFiles", files);
    }

    public void setXmlCatalogPrefer(String prefer) {
        this.initialOps.setProperty("xmlCatalogPrefer", prefer);
    }

    public void setValidateXml(String validate) {
        this.initialOps.setProperty("validateXml", this.antBooleanToTdd(validate));
    }

    public void setXmlRenderings(String prefer) {
        if (this.initialOps.getProperty("xmlRenderings") != null) {
            throw this.newMultipleDefinitionsException("xmlRenderings");
        }
        this.initialOps.setProperty("xmlRenderings", prefer);
    }

    public void setQuiet(String quiet) {
        this.initialOps.setProperty("quiet", this.antBooleanToTdd(quiet));
    }

    public void setReplaceExtensions(String replaceExtension) {
        this.initialOps.setProperty("replaceExtensions", replaceExtension);
    }

    public void setRemoveExtensions(String removeExtension) {
        this.initialOps.setProperty("removeExtensions", removeExtension);
    }

    public void setRemovePostfixes(String removePostfix) {
        this.initialOps.setProperty("removePostfixes", removePostfix);
    }

    public void setReplaceExtension(String replaceExtension) {
        this.initialOps.setProperty("replaceExtension", replaceExtension);
    }

    public void setRemoveExtension(String removeExtension) {
        this.initialOps.setProperty("removeExtension", removeExtension);
    }

    public void setRemovePostfix(String removePostfix) {
        this.initialOps.setProperty("removePostfix", removePostfix);
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.initialOps.setProperty("sourceEncoding", sourceEncoding);
    }

    public void setStopOnError(boolean stopOnError) {
        this.initialOps.setProperty("stopOnError", String.valueOf(stopOnError));
    }

    public void setSkipUnchanged(String skipUnchanged) {
        this.initialOps.setProperty("skipUnchanged", skipUnchanged);
    }

    public void setTemplateData(String templateData) {
        this.initialOps.setProperty("templateData", templateData);
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void addConfiguredModes(AntAttributeSubstitution ats) {
        this.doAttributeSubstitution("modes", ats);
    }

    public void addConfiguredData(AntAttributeSubstitution ats) {
        this.doAttributeSubstitution("data", ats);
    }

    public void addConfiguredLocalData(AntAttributeSubstitution ats) {
        this.doAttributeSubstitution("localData", ats);
    }

    public void addConfiguredBorders(AntAttributeSubstitution ats) {
        this.doAttributeSubstitution("borders", ats);
    }

    public void addConfiguredTurns(AntAttributeSubstitution ats) {
        this.doAttributeSubstitution("turns", ats);
    }

    public void addConfiguredXmlRenderings(AntAttributeSubstitution ats) {
        this.doAttributeSubstitution("xmlRenderings", ats);
    }

    public void addConfiguredFreemarkerLinks(AntAttributeSubstitution ats) {
        this.doAttributeSubstitution("freemarkerLinks", ats);
    }

    public Target getTarget() {
        return this.getOwningTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws CausePrinterBuildException {
        LoggerProgressListener fileLogger = null;
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeExceptionCC("Failed to disable FreeMarker logging", e);
        }
        try {
            AntProgressListener antProgressListener;
            boolean quiet;
            boolean singleFileMode;
            Settings ss;
            try {
                FileWithSettingValue fws;
                ss = new Settings(this.getProject().getBaseDir());
                ss.setEngineAttribute("fmpp.ant.task", (Object)this);
                Settings.fixVersion08SettingNames(this.initialOps);
                ss.addWithStrings(this.initialOps);
                if (this.configuration != null) {
                    ss.loadDefaults(new File(this.configuration));
                }
                if ((fws = (FileWithSettingValue)ss.get("logFile")) != null && !fws.getSettingValue().equals("none")) {
                    try {
                        Boolean append = (Boolean)ss.get("appendLogFile");
                        fileLogger = new LoggerProgressListener(fws, append != null && append != false);
                        ss.addProgressListener(fileLogger);
                    }
                    catch (IOException e) {
                        throw new SettingException("Failed to create log file.", e);
                    }
                }
                if (ss.get("outputFile") != null) {
                    singleFileMode = true;
                } else {
                    if (this.hasSourceFileAttr) {
                        throw new SettingException("Attribute \"sourceFile\" can be used in single file mode only.");
                    }
                    singleFileMode = false;
                }
                ss.add("ignoreCvsFiles", Boolean.FALSE);
                ss.add("ignoreSvnFiles", Boolean.FALSE);
                ss.add("ignoreTemporaryFiles", Boolean.FALSE);
                try {
                    Object o = ss.get("expert");
                    boolean expert = o == null ? false : (Boolean)o;
                    o = ss.get("outputRoot");
                    if (o != null && ((File)o).getCanonicalFile().equals(this.getProject().getBaseDir().getCanonicalFile()) && !expert) {
                        throw new SettingException("The output root directory is the same as the project base directory. Maybe something was misconfigured here? Use expert=\"yes\" to allow this.");
                    }
                }
                catch (IOException e) {
                    throw new SettingException("Output root directory or project base directory caninalization failed.", e);
                }
                try {
                    int q = Settings.quietSettingValueToInt((String)ss.get("quiet"), "quiet");
                    quiet = q > 0;
                }
                catch (SettingException e) {
                    throw new CausePrinterBuildException("Failed to interpret the value of setting \"quiet\".", e);
                }
                antProgressListener = new AntProgressListener((Task)this, quiet || singleFileMode);
                ss.addProgressListener(antProgressListener);
                if (!singleFileMode) {
                    File sourceRoot = (File)ss.get("sourceRoot");
                    if (sourceRoot == null) {
                        throw new CausePrinterBuildException("Setting \"sourceRoot\" is not set.");
                    }
                    File scannerBase = this.dir != null ? this.dir : sourceRoot;
                    String[] scanResults = MiscUtil.add(this.getDirectoryScanner(scannerBase).getIncludedFiles(), this.getDirectoryScanner(scannerBase).getIncludedDirectories());
                    String[] sourceFiles = new String[scanResults.length];
                    for (int i = 0; i < scanResults.length; ++i) {
                        File f = new File(scannerBase, scanResults[i]);
                        sourceFiles[i] = f.getAbsolutePath();
                    }
                    ss.add("sources", sourceFiles);
                    scanResults = this.getDirectoryScanner(scannerBase).getIncludedDirectories();
                    String[] sourceDirectories = new String[scanResults.length];
                    for (int i = 0; i < scanResults.length; ++i) {
                        File f = new File(scannerBase, scanResults[i]);
                        sourceDirectories[i] = f.getAbsolutePath();
                    }
                }
            }
            catch (SettingException e) {
                if (fileLogger != null) {
                    fileLogger.println("Failed to initialize FMPP engine:" + StringUtil.LINE_BREAK + MiscUtil.causeMessages(e));
                    fileLogger.printStackTrace(e);
                }
                throw new CausePrinterBuildException("Failed to initialize FMPP engine.", e);
            }
            ss.setDontTraverseDirectories(true);
            try {
                ss.execute();
                if (antProgressListener.getErrorCount() != 0) {
                    if (this.antTaskFailOnError) {
                        throw new CausePrinterBuildException("FMPP Ant task failed: There were errors during the processing session.");
                    }
                } else if (singleFileMode && !quiet) {
                    this.log("File processed.");
                }
            }
            catch (ProcessingException e) {
                if (this.antTaskFailOnError) {
                    throw new CausePrinterBuildException("FMPP processing session failed.", e.getCause());
                }
            }
            catch (SettingException e) {
                if (fileLogger != null) {
                    fileLogger.println(">>> TERMINATED WITH SETTING ERROR <<<");
                    fileLogger.println(MiscUtil.causeMessages(e));
                    fileLogger.printStackTrace(e);
                }
                throw new CausePrinterBuildException("Failed to initialize FMPP engine.", e);
            }
        }
        finally {
            if (fileLogger != null) {
                fileLogger.close();
            }
        }
    }

    private String antBooleanToTdd(String s) {
        if (s != null) {
            if (s.equals("no")) {
                return "false";
            }
            if (s.equals("yes")) {
                return "true";
            }
        }
        return s;
    }

    private void doAttributeSubstitution(String settingName, AntAttributeSubstitution ats) {
        if (this.initialOps.getProperty(settingName) != null) {
            throw this.newMultipleDefinitionsException(settingName);
        }
        this.initialOps.setProperty(settingName, ats.getText());
    }

    private CausePrinterBuildException newMultipleDefinitionsException(String setting) {
        return new CausePrinterBuildException("You can't use both attribute \"" + setting + "\" and element \"" + setting + "\", nor use the element " + "for multiple times.");
    }

    class CausePrinterBuildException
    extends BuildException {
        private static final long serialVersionUID = 1L;

        public CausePrinterBuildException(String message) {
            super(message);
        }

        public CausePrinterBuildException(String message, Throwable exc) {
            super(message + StringUtil.LINE_BREAK + "Caused by: " + MiscUtil.causeMessages(exc), exc);
        }
    }

    public static class AntAttributeSubstitution
    extends ProjectComponent {
        private String text;
        private boolean expandProperties = false;

        public void setExpandProperties(boolean expandProperties) {
            this.expandProperties = expandProperties;
        }

        public void addText(String text) {
            this.text = text;
        }

        public String getText() {
            if (this.text == null) {
                this.text = "";
            }
            if (this.expandProperties) {
                return this.getProject().replaceProperties(this.text);
            }
            return this.text;
        }
    }
}

