/*
 * Decompiled with CFR 0.152.
 */
package fmpp.util;

import fmpp.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class ArgsParser
implements Serializable {
    private static final int WRAP_INDENT = 2;
    private static final int COL_DISTANCE = 3;
    private static final int MAX_LEFT_COL_WIDTH = 30;
    private static final long serialVersionUID = 1L;
    private static final Comparator CMPRTR_OP_KEY = new OptionDefinitionKeyComparator();
    private static final Comparator CMPRTR_OP_SNAME = new OptionDefinitionShortNameComparator();
    private static final Comparator CMPRTR_OP_LNAME = new OptionDefinitionLongNameComparator();
    private Properties defaultProperties;
    private Properties messages;
    private ArrayList odsByKey = new ArrayList();
    private ArrayList odsBySName = new ArrayList();
    private ArrayList odsByLName = new ArrayList();
    private Properties prsdOps = new Properties();
    private ArrayList prsdNonOps = new ArrayList();
    private String[] prsdNonOpsArray;
    public static final String MSG_OPTION_CONFLICT = "OPTION_CONFLICT";
    public static final String MSG_ARG_MISSING = "ARG_MISSING";
    public static final String MSG_OPTION_UNKNOWN = "OPTION_UNKNOWN";
    public static final String MSG_ARG_NOT_ALLOWED = "NOT_ALLOWED";
    private Properties defaultMessages = new Properties();

    public ArgsParser() {
        this.defaultMessages.put(MSG_OPTION_CONFLICT, "This option conflicts with a preceding option: ");
        this.defaultMessages.put(MSG_ARG_MISSING, "The argument is missing for this option: ");
        this.defaultMessages.put(MSG_OPTION_UNKNOWN, "Unknown option: ");
        this.defaultMessages.put(MSG_ARG_NOT_ALLOWED, "This option does not allow argument: ");
    }

    public Properties parse(String[] args) throws BadArgsException {
        OptionDefinition op;
        this.prsdOps = this.defaultProperties == null ? new Properties() : new Properties(this.defaultProperties);
        this.prsdNonOps.clear();
        this.prsdNonOpsArray = null;
        OptionDefinition dummy = new OptionDefinition();
        block0: for (int i = 0; i < args.length; ++i) {
            int opi;
            int x;
            String arg = args[i];
            if (arg.startsWith("--")) {
                if (arg.equals("--")) {
                    ++i;
                    while (i < args.length) {
                        this.prsdNonOps.add(args[i]);
                        ++i;
                    }
                    break;
                }
                x = (arg = arg.substring(2)).indexOf(61);
                if (x != -1) {
                    dummy.lName = arg.substring(0, x);
                } else {
                    dummy.lName = arg;
                }
                opi = Collections.binarySearch(this.odsByLName, dummy, CMPRTR_OP_LNAME);
                if (opi < 0) {
                    throw new BadArgsException(this.getMessage(MSG_OPTION_UNKNOWN) + dummy.lName);
                }
                op = (OptionDefinition)this.odsByLName.get(opi);
                if (this.prsdOps.get(op.pName) != null) {
                    throw new BadArgsException(this.getMessage(MSG_OPTION_CONFLICT) + dummy.lName);
                }
                if (op.argType != 0) {
                    if (x == -1) {
                        if (op.argType == 1) {
                            this.prsdOps.put(op.pName, op.defaultArg);
                            continue;
                        }
                        if (i == args.length - 1) {
                            throw new BadArgsException(this.getMessage(MSG_ARG_MISSING) + dummy.lName);
                        }
                        this.prsdOps.put(op.pName, args[++i]);
                        continue;
                    }
                    this.prsdOps.put(op.pName, arg.substring(x + 1));
                    continue;
                }
                if (x != -1) {
                    throw new BadArgsException(this.getMessage(MSG_ARG_NOT_ALLOWED) + dummy.lName);
                }
                this.prsdOps.put(op.pName, op.pValue);
                continue;
            }
            if (arg.startsWith("-")) {
                if (arg.equals("-")) {
                    this.prsdNonOps.add(arg);
                    continue;
                }
                arg = arg.substring(1);
                for (x = 0; x < arg.length(); ++x) {
                    dummy.sName = arg.substring(x, x + 1);
                    opi = Collections.binarySearch(this.odsBySName, dummy, CMPRTR_OP_SNAME);
                    if (opi < 0) {
                        throw new BadArgsException(this.getMessage(MSG_OPTION_UNKNOWN) + dummy.sName);
                    }
                    op = (OptionDefinition)this.odsBySName.get(opi);
                    if (this.prsdOps.get(op.pName) != null) {
                        throw new BadArgsException(this.getMessage(MSG_OPTION_CONFLICT) + dummy.sName);
                    }
                    if (op.argType != 0) {
                        if (arg.length() - 1 > x) {
                            this.prsdOps.put(op.pName, arg.substring(x + 1));
                            continue block0;
                        }
                        if (op.argType == 1) {
                            this.prsdOps.put(op.pName, op.defaultArg);
                            continue block0;
                        }
                        if (i == args.length - 1) {
                            throw new BadArgsException(this.getMessage(MSG_ARG_MISSING) + dummy.sName);
                        }
                        this.prsdOps.put(op.pName, args[++i]);
                        continue block0;
                    }
                    this.prsdOps.put(op.pName, op.pValue);
                }
                continue;
            }
            this.prsdNonOps.add(arg);
        }
        Properties eps = this.defaultProperties != null ? this.defaultProperties : this.prsdOps;
        Iterator it = this.odsByKey.iterator();
        while (it.hasNext()) {
            op = (OptionDefinition)it.next();
            if (!op.isImplied || this.prsdOps.get(op.pName) != null) continue;
            if (op.impliedArg != null) {
                eps.put(op.pName, op.impliedArg);
                continue;
            }
            eps.put(op.pName, op.pValue);
        }
        return this.prsdOps;
    }

    public Properties getOptions() {
        return this.prsdOps;
    }

    public String getOption(String name) {
        return (String)this.prsdOps.get(name);
    }

    public String[] getNonOptions() {
        if (this.prsdNonOpsArray == null) {
            int ln = this.prsdNonOps.size();
            this.prsdNonOpsArray = new String[ln];
            for (int i = 0; i < ln; ++i) {
                this.prsdNonOpsArray[i] = (String)this.prsdNonOps.get(i);
            }
        }
        return this.prsdNonOpsArray;
    }

    public Set getPropertyNames() {
        HashSet<String> res = new HashSet<String>();
        Iterator it = this.odsByKey.iterator();
        while (it.hasNext()) {
            OptionDefinition op = (OptionDefinition)it.next();
            res.add(op.pName);
        }
        return res;
    }

    public OptionDefinition addOption(String shortName, String longName) {
        int i;
        OptionDefinition op = new OptionDefinition();
        op.argType = 0;
        if (longName != null && ((i = longName.indexOf("=")) != -1 || (i = longName.indexOf(" ")) != -1)) {
            op.argType = 2;
            op.argName = longName.substring(i + 1);
            longName = longName.substring(0, i);
        }
        if (shortName != null && ((i = shortName.indexOf("=")) != -1 || (i = shortName.indexOf(" ")) != -1)) {
            op.argType = 2;
            op.argName = shortName.substring(i + 1);
            shortName = shortName.substring(0, i);
        }
        this.checkOptionNames(shortName, longName);
        op.lName = longName;
        op.sName = shortName;
        op.key = shortName != null ? shortName : longName;
        op.pName = longName != null ? longName : shortName;
        if (op.argType == 0) {
            op.pValue = "";
        }
        this.insertOp(op);
        return op;
    }

    public void setDefaultProperties(Properties defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void setMessages(Properties messages) {
        this.messages = messages;
    }

    public Iterator getOptionDefintions() {
        ArrayList odsByHelp = (ArrayList)this.odsByKey.clone();
        Collections.sort(odsByHelp, new OptionDefinitionHelpComparator());
        return odsByHelp.iterator();
    }

    public OptionDefinition getOptionDefinition(String name) {
        int i = Collections.binarySearch(this.odsByKey, name, CMPRTR_OP_KEY);
        return i < 0 ? null : (OptionDefinition)this.odsByKey.get(i);
    }

    public String getOptionsHelp(int screenWidth) {
        OptionDefinition od;
        int lColW = 0;
        ArrayList<String> lCols = new ArrayList<String>();
        StringBuffer res = new StringBuffer();
        Iterator it = this.getOptionDefintions();
        while (it.hasNext()) {
            od = (OptionDefinition)it.next();
            if (od.hidden) continue;
            String s = ArgsParser.createOptionLeftColumn(od);
            lCols.add(s);
            int width = s.length();
            if (width <= lColW) continue;
            lColW = width <= 30 ? width : 30;
        }
        if (screenWidth - 1 - (lColW + 3 + 2) < 16) {
            if (screenWidth - 1 < lColW) {
                return StringUtil.wrap("Unable to display option help: Screen is too narrow.", screenWidth);
            }
            res.append(StringUtil.wrap("Warning: Unable to display option descriptions: Screen is too narrow.", screenWidth)).append(StringUtil.LINE_BREAK);
            int ln = lCols.size();
            for (int i = 0; i < ln; ++i) {
                res.append((String)lCols.get(i));
                if (i == ln - 1) continue;
                res.append(StringUtil.LINE_BREAK);
            }
            return res.toString();
        }
        int i = 0;
        it = this.getOptionDefintions();
        while (it.hasNext()) {
            od = (OptionDefinition)it.next();
            if (od.hidden) continue;
            String lCol = (String)lCols.get(i);
            ++i;
            if (od.getDescription() != null) {
                int lColWithPaddingW = lColW + 3;
                if (lCol.length() <= lColW) {
                    StringBuffer desc = StringUtil.wrap(new StringBuffer(od.getDescription()), screenWidth, lColWithPaddingW, lColWithPaddingW + 2);
                    desc.replace(0, lCol.length(), lCol);
                    res.append(desc);
                } else {
                    String lColAndSep = lCol.length() >= lColWithPaddingW ? lCol + " " : freemarker.template.utility.StringUtil.rightPad((String)lCol, (int)lColWithPaddingW);
                    res.append(StringUtil.wrap(new StringBuffer(lColAndSep + od.getDescription()), screenWidth, 0, lColWithPaddingW + 2));
                }
            } else {
                res.append(lCol);
            }
            if (!it.hasNext()) continue;
            res.append(StringUtil.LINE_BREAK);
        }
        return res.toString();
    }

    private static String createOptionLeftColumn(OptionDefinition od) {
        StringBuffer b = new StringBuffer(30);
        b.append("  ");
        String sn = od.getShortName();
        String ln = od.getLongName();
        String an = od.getArgName();
        if (sn != null) {
            b.append("-");
            b.append(sn);
            if (an != null && ln == null) {
                b.append("<");
                b.append(an);
                b.append(">");
            }
        }
        if (ln != null) {
            if (sn == null) {
                b.append("    --");
            } else {
                b.append(", --");
            }
            b.append(ln);
            if (an != null) {
                b.append("=<");
                b.append(an);
                b.append(">");
            }
        }
        return b.toString();
    }

    private String getMessage(String key) {
        String r = null;
        if (this.messages != null) {
            r = this.messages.getProperty(key);
        }
        if (r == null && (r = this.defaultMessages.getProperty(key)) == null) {
            r = "??? (message not found): ";
        }
        return r;
    }

    private void insertOp(OptionDefinition op) {
        int li = 0;
        int ni = 0;
        if (op.sName != null && (li = Collections.binarySearch(this.odsBySName, op, CMPRTR_OP_SNAME)) >= 0) {
            throw new IllegalArgumentException("An option with this short-name is already defined: " + op.sName);
        }
        if (op.lName != null && (ni = Collections.binarySearch(this.odsByLName, op, CMPRTR_OP_LNAME)) >= 0) {
            throw new IllegalArgumentException("An option with this long-name is already defined: " + op.lName);
        }
        int ki = Collections.binarySearch(this.odsByKey, op, CMPRTR_OP_KEY);
        if (ki >= 0) {
            throw new IllegalArgumentException("An option with this short- or long-name is already defined: " + op.key);
        }
        this.odsByKey.add(-ki - 1, op);
        if (op.sName != null) {
            this.odsBySName.add(-li - 1, op);
        }
        if (op.lName != null) {
            this.odsByLName.add(-ni - 1, op);
        }
    }

    private void checkOptionNames(String shortName, String longName) {
        ArgsParser.checkOptionName(longName);
        ArgsParser.checkOptionName(shortName);
        if (shortName != null && shortName.length() != 1) {
            throw new IllegalArgumentException("Short-name must be 1 character long.");
        }
        if (shortName == null && longName == null) {
            throw new IllegalArgumentException("At least one of the option short- and the long-names must be non-null.");
        }
    }

    private static void checkOptionName(String name) throws IllegalArgumentException {
        if (name == null) {
            return;
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Option name can't be 0 character long.");
        }
        int ln = name.length();
        if (name.charAt(0) == '-') {
            throw new IllegalArgumentException("Option name can't start with -.");
        }
        for (int i = 0; i < ln; ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '_' || c == '@' || c == '#') continue;
            throw new IllegalArgumentException("Option name can contain only: 0-9, a-z, A-Z, -, _, @, #");
        }
    }

    public static class BadArgsException
    extends Exception {
        private BadArgsException(String message) {
            super(message);
        }
    }

    private static class OptionDefinitionHelpComparator
    implements Comparator {
        private OptionDefinitionHelpComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((OptionDefinition)o1).key;
            String s2 = ((OptionDefinition)o2).key;
            int x = s1.toLowerCase().compareTo(s2.toLowerCase());
            if (x != 0) {
                return x;
            }
            return -s1.compareTo(s2);
        }
    }

    private static class OptionDefinitionKeyComparator
    implements Comparator {
        private OptionDefinitionKeyComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((OptionDefinition)o1).key.compareTo(((OptionDefinition)o2).key);
        }
    }

    private static class OptionDefinitionLongNameComparator
    implements Comparator {
        private OptionDefinitionLongNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((OptionDefinition)o1).lName.compareTo(((OptionDefinition)o2).lName);
        }
    }

    private static class OptionDefinitionShortNameComparator
    implements Comparator {
        private OptionDefinitionShortNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((OptionDefinition)o1).sName.compareTo(((OptionDefinition)o2).sName);
        }
    }

    public class OptionDefinition
    implements Cloneable {
        private static final int ARGT_NONE = 0;
        private static final int ARGT_OPTIONAL = 1;
        private static final int ARGT_REQUIRED = 2;
        private String key;
        private String pName;
        private String lName;
        private String sName;
        private String pValue;
        private boolean isImplied;
        private int argType;
        private String impliedArg;
        private String defaultArg;
        private String desc;
        private String argName;
        private boolean hidden;

        public OptionDefinition property(String pName) {
            this.pName = pName;
            return this;
        }

        public OptionDefinition propertyValue(String value) {
            if (this.argType != 0) {
                throw new IllegalArgumentException("This option supports argument.");
            }
            this.pValue = value;
            return this;
        }

        public OptionDefinition property(String propertyName, String propertyValue) {
            if (this.argType != 0) {
                throw new IllegalArgumentException("This option supports argument.");
            }
            this.property(propertyName);
            this.propertyValue(propertyValue);
            return this;
        }

        public OptionDefinition group(String propertyName) {
            this.property(propertyName, this.lName != null ? this.lName : this.sName);
            return this;
        }

        public OptionDefinition implied() {
            if (this.argType != 0) {
                throw new IllegalArgumentException("This overload is for options that don't support argument.");
            }
            this.isImplied = true;
            return this;
        }

        public OptionDefinition implied(String impliedArg) {
            if (this.argType == 0) {
                throw new IllegalArgumentException("This overload is for options that support argument.");
            }
            this.isImplied = true;
            this.impliedArg = impliedArg;
            return this;
        }

        public OptionDefinition defaultArg(String defaultValue) {
            if (this.argType == 0) {
                throw new IllegalArgumentException("This option has no argument.");
            }
            this.defaultArg = defaultValue;
            this.argType = 1;
            return this;
        }

        public OptionDefinition desc(String desc) {
            if (desc != null && desc.length() == 0) {
                desc = null;
            }
            this.desc = desc;
            return this;
        }

        public void hide() {
            this.hidden = true;
        }

        public OptionDefinition copy(String shortName, String longName) {
            OptionDefinition op;
            ArgsParser.this.checkOptionNames(shortName, longName);
            try {
                op = (OptionDefinition)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Bug: " + e);
            }
            op.lName = longName;
            op.sName = shortName;
            op.key = shortName != null ? shortName : longName;
            ArgsParser.this.insertOp(op);
            return op;
        }

        public String getArgName() {
            return this.argName;
        }

        public String getDefaultArg() {
            return this.defaultArg;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getLongName() {
            return this.lName;
        }

        public String getShortName() {
            return this.sName;
        }
    }
}

