/*
 * Decompiled with CFR 0.152.
 */
package fmpp.util;

import fmpp.util.JSONParseException;
import fmpp.util.StringUtil;
import freemarker.template.utility.NumberUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSONParser {
    private static final String UNCLOSED_OBJECT_MESSAGE = "This {...} was still unclosed when the end of the file was reached. (Look for a missing \"}\")";
    private static final String UNCLOSED_ARRAY_MESSAGE = "This [...] was still unclosed when the end of the file was reached. (Look for a missing \"]\")";
    private static final Object JSON_NULL = new Object();
    private static final BigDecimal MIN_INT_AS_BIGDECIMAL = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal MAX_INT_AS_BIGDECIMAL = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal MIN_LONG_AS_BIGDECIMAL = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal MAX_LONG_AS_BIGDECIMAL = BigDecimal.valueOf(Long.MAX_VALUE);
    private final String src;
    private final String sourceLocation;
    private final int ln;
    private int p;

    public static Object parse(String src, String sourceLocation) throws JSONParseException {
        return new JSONParser(src, sourceLocation).parse();
    }

    private JSONParser(String src, String sourceLocation) {
        this.src = src;
        this.sourceLocation = sourceLocation;
        this.ln = src.length();
    }

    private Object parse() throws JSONParseException {
        if (this.ln > 0 && this.src.charAt(0) == '\ufeff') {
            ++this.p;
        }
        this.skipWS();
        Object result = this.consumeValue("Empty JSON (contains no value)", this.p);
        this.skipWS();
        if (this.p != this.ln) {
            throw this.newParseException("End-of-file was expected but found further non-whitespace characters.");
        }
        return result;
    }

    private Object consumeValue(String eofErrorMessage, int eofBlamePosition) throws JSONParseException {
        if (this.p == this.ln) {
            throw this.newParseException(eofErrorMessage == null ? "A value was expected here, but end-of-file was reached." : eofErrorMessage, eofBlamePosition == -1 ? this.p : eofBlamePosition);
        }
        Object result = this.tryConsumeString();
        if (result != null) {
            return result;
        }
        result = this.tryConsumeNumber();
        if (result != null) {
            return result;
        }
        result = this.tryConsumeObject();
        if (result != null) {
            return result;
        }
        result = this.tryConsumeArray();
        if (result != null) {
            return result;
        }
        result = this.tryConsumeTrueFalseNull();
        if (result != null) {
            return result != JSON_NULL ? result : null;
        }
        if (this.p < this.ln && this.src.charAt(this.p) == '\'') {
            throw this.newParseException("Unexpected apostrophe-quote character. JSON strings must be quoted with quotation mark.");
        }
        throw this.newParseException("Expected either the beginning of a (negative) number or the beginning of one of these: {...}, [...], \"...\", true, false, null. Found character " + StringUtil.jQuote(this.src.charAt(this.p)) + " instead.");
    }

    private Object tryConsumeTrueFalseNull() throws JSONParseException {
        int startP = this.p;
        if (this.p < this.ln && this.isIdentifierStart(this.src.charAt(this.p))) {
            ++this.p;
            while (this.p < this.ln && this.isIdentifierPart(this.src.charAt(this.p))) {
                ++this.p;
            }
        }
        if (startP == this.p) {
            return null;
        }
        String keyword = this.src.substring(startP, this.p);
        if (keyword.equals("true")) {
            return Boolean.TRUE;
        }
        if (keyword.equals("false")) {
            return Boolean.FALSE;
        }
        if (keyword.equals("null")) {
            return JSON_NULL;
        }
        throw this.newParseException("Invalid JSON keyword: " + keyword + ". Should be one of: true, false, null. " + "If it meant to be a string then it must be quoted.", startP);
    }

    private Number tryConsumeNumber() throws JSONParseException {
        boolean negative;
        char c = this.src.charAt(this.p);
        boolean bl = negative = c == '-';
        if (!negative && !this.isDigit(c) && c != '.') {
            return null;
        }
        int startP = this.p;
        if (negative) {
            if (this.p + 1 >= this.ln) {
                throw this.newParseException("Expected a digit after \"-\", but reached end-of-file.");
            }
            char lookAheadC = this.src.charAt(this.p + 1);
            if (!this.isDigit(lookAheadC) && lookAheadC != '.') {
                return null;
            }
            ++this.p;
        }
        long longSum = 0L;
        boolean firstDigit = true;
        do {
            if (!this.isDigit(c = this.src.charAt(this.p))) {
                if (c != '.' || !firstDigit) break;
                throw this.newParseException("JSON doesn't allow numbers starting with \".\".");
            }
            int digit = c - 48;
            if (longSum == 0L) {
                if (!firstDigit) {
                    throw this.newParseException("JSON doesn't allow superfluous leading 0-s.", this.p - 1);
                }
                longSum = !negative ? (long)digit : (long)(-digit);
                ++this.p;
            } else {
                long prevLongSum = longSum;
                longSum = longSum * 10L + (long)(!negative ? digit : -digit);
                if (!negative && prevLongSum > longSum || negative && prevLongSum < longSum) break;
                ++this.p;
            }
            firstDigit = false;
        } while (this.p < this.ln);
        if (this.p < this.ln && this.isBigDecimalFittingTailCharacter(c)) {
            BigDecimal bd;
            char lastC = c;
            ++this.p;
            while (this.p < this.ln) {
                c = this.src.charAt(this.p);
                if (this.isBigDecimalFittingTailCharacter(c)) {
                    ++this.p;
                } else {
                    if (c != '+' && c != '-' || !this.isE(lastC)) break;
                    ++this.p;
                }
                lastC = c;
            }
            String numStr = this.src.substring(startP, this.p);
            try {
                bd = new BigDecimal(numStr);
            }
            catch (NumberFormatException e) {
                throw new JSONParseException("Malformed number: " + numStr, this.src, startP, this.sourceLocation, e);
            }
            if (bd.compareTo(MIN_INT_AS_BIGDECIMAL) >= 0 && bd.compareTo(MAX_INT_AS_BIGDECIMAL) <= 0) {
                if (NumberUtil.isIntegerBigDecimal((BigDecimal)bd)) {
                    return new Integer(bd.intValue());
                }
            } else if (bd.compareTo(MIN_LONG_AS_BIGDECIMAL) >= 0 && bd.compareTo(MAX_LONG_AS_BIGDECIMAL) <= 0 && NumberUtil.isIntegerBigDecimal((BigDecimal)bd)) {
                return new Long(bd.longValue());
            }
            return bd;
        }
        return longSum <= Integer.MAX_VALUE && longSum >= Integer.MIN_VALUE ? (Number)new Integer((int)longSum) : (Number)new Long(longSum);
    }

    private String tryConsumeString() throws JSONParseException {
        int startP = this.p;
        if (!this.tryConsumeChar('\"')) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        char c = '\u0000';
        while (this.p < this.ln) {
            c = this.src.charAt(this.p);
            if (c == '\"') {
                ++this.p;
                return sb.toString();
            }
            if (c == '\\') {
                ++this.p;
                sb.append(this.consumeAfterBackslash());
                continue;
            }
            if (c <= '\u001f') {
                if (c == '\t') {
                    throw this.newParseException("JSON doesn't allow unescaped tab character in string literals; use \\t instead.");
                }
                if (c == '\r') {
                    throw this.newParseException("JSON doesn't allow unescaped CR character in string literals; use \\r instead.");
                }
                if (c == '\n') {
                    throw this.newParseException("JSON doesn't allow unescaped LF character in string literals; use \\n instead.");
                }
                throw this.newParseException("JSON doesn't allow unescaped control characters in string literals, but found character with code (decimal): " + c);
            }
            ++this.p;
            sb.append(c);
        }
        throw this.newParseException("String literal was still unclosed when the end of the file was reached. (Look for missing or accidentally escaped closing quotation mark.)", startP);
    }

    private List tryConsumeArray() throws JSONParseException {
        int startP = this.p;
        if (!this.tryConsumeChar('[')) {
            return null;
        }
        this.skipWS();
        if (this.tryConsumeChar(']')) {
            return Collections.EMPTY_LIST;
        }
        boolean afterComma = false;
        ArrayList<Object> elements = new ArrayList<Object>();
        do {
            this.skipWS();
            elements.add(this.consumeValue(afterComma ? null : UNCLOSED_ARRAY_MESSAGE, afterComma ? -1 : startP));
            this.skipWS();
            afterComma = true;
        } while (this.consumeChar(',', ']', UNCLOSED_ARRAY_MESSAGE, startP) == ',');
        return elements;
    }

    private Map tryConsumeObject() throws JSONParseException {
        int startP = this.p;
        if (!this.tryConsumeChar('{')) {
            return null;
        }
        this.skipWS();
        if (this.tryConsumeChar('}')) {
            return Collections.EMPTY_MAP;
        }
        boolean afterComma = false;
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        do {
            this.skipWS();
            int keyStartP = this.p;
            Object key = this.consumeValue(afterComma ? null : UNCLOSED_OBJECT_MESSAGE, afterComma ? -1 : startP);
            if (!(key instanceof String)) {
                throw this.newParseException("Wrong key type. JSON only allows string keys inside {...}.", keyStartP);
            }
            this.skipWS();
            this.consumeChar(':');
            this.skipWS();
            map.put(key, this.consumeValue(null, -1));
            this.skipWS();
            afterComma = true;
        } while (this.consumeChar(',', '}', UNCLOSED_OBJECT_MESSAGE, startP) == ',');
        return map;
    }

    private boolean isE(char c) {
        return c == 'e' || c == 'E';
    }

    private boolean isBigDecimalFittingTailCharacter(char c) {
        return c == '.' || this.isE(c) || this.isDigit(c);
    }

    private char consumeAfterBackslash() throws JSONParseException {
        if (this.p == this.ln) {
            throw this.newParseException("Reached the end of the file, but the escape is unclosed.");
        }
        char c = this.src.charAt(this.p);
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': {
                ++this.p;
                return c;
            }
            case 'b': {
                ++this.p;
                return '\b';
            }
            case 'f': {
                ++this.p;
                return '\f';
            }
            case 'n': {
                ++this.p;
                return '\n';
            }
            case 'r': {
                ++this.p;
                return '\r';
            }
            case 't': {
                ++this.p;
                return '\t';
            }
            case 'u': {
                ++this.p;
                return this.consumeAfterBackslashU();
            }
        }
        throw this.newParseException("Unsupported escape: \\" + c);
    }

    private char consumeAfterBackslashU() throws JSONParseException {
        if (this.p + 3 >= this.ln) {
            throw this.newParseException("\\u must be followed by exactly 4 hexadecimal digits");
        }
        String hex = this.src.substring(this.p, this.p + 4);
        try {
            char r = (char)Integer.parseInt(hex, 16);
            this.p += 4;
            return r;
        }
        catch (NumberFormatException e) {
            throw this.newParseException("\\u must be followed by exactly 4 hexadecimal digits, but was followed by " + StringUtil.jQuote(hex) + ".");
        }
    }

    private boolean tryConsumeChar(char c) {
        if (this.p < this.ln && this.src.charAt(this.p) == c) {
            ++this.p;
            return true;
        }
        return false;
    }

    private void consumeChar(char expected) throws JSONParseException {
        this.consumeChar(expected, '\u0000', null, -1);
    }

    private char consumeChar(char expected1, char expected2, String eofErrorHint, int eofErrorP) throws JSONParseException {
        if (this.p >= this.ln) {
            throw this.newParseException(eofErrorHint == null ? "Expected " + StringUtil.jQuote(expected1) + (expected2 != '\u0000' ? " or " + StringUtil.jQuote(expected2) : "") + " character, but reached end-of-file. " : eofErrorHint, eofErrorP == -1 ? this.p : eofErrorP);
        }
        char c = this.src.charAt(this.p);
        if (c == expected1 || expected2 != '\u0000' && c == expected2) {
            ++this.p;
            return c;
        }
        throw this.newParseException("Expected " + StringUtil.jQuote(expected1) + (expected2 != '\u0000' ? " or " + StringUtil.jQuote(expected2) : "") + " character, but found " + StringUtil.jQuote(c) + " instead.");
    }

    private void skipWS() {
        while (this.p < this.ln && this.isWS(this.src.charAt(this.p))) {
            ++this.p;
        }
    }

    private boolean isWS(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private boolean isIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_' || c == '$';
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isIdentifierPart(char c) {
        return this.isIdentifierStart(c) || this.isDigit(c);
    }

    private JSONParseException newParseException(String message) {
        return this.newParseException(message, this.p);
    }

    private JSONParseException newParseException(String message, int p) {
        return new JSONParseException(message, this.src, p, this.sourceLocation);
    }
}

