/*
 * Decompiled with CFR 0.152.
 */
package fmpp.util;

import fmpp.util.BugException;
import fmpp.util.ExceptionCC;
import freemarker.template.SimpleDate;
import freemarker.template.TemplateDateModel;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class StringUtil {
    private static final DateFormat DTF4 = new SimpleDateFormat("yyyy-MM-dd H:mm:ss'|'", Locale.US);
    private static final DateFormat DTF3 = new SimpleDateFormat("yyyy-MM-dd h:mm:ss a'|'", Locale.US);
    private static final DateFormat DTF2 = new SimpleDateFormat("yyyy-MM-dd H:mm:ss z'|'", Locale.US);
    private static final DateFormat DTF1 = new SimpleDateFormat("yyyy-MM-dd h:mm:ss a z'|'", Locale.US);
    private static final DateFormat DF1 = new SimpleDateFormat("yyyy-MM-dd'|'", Locale.US);
    private static final DateFormat DF2 = new SimpleDateFormat("yyyy-MM-dd z'|'", Locale.US);
    private static final DateFormat TF1 = new SimpleDateFormat("H:mm:ss'|'", Locale.US);
    private static final DateFormat TF2 = new SimpleDateFormat("h:mm:ss a'|'", Locale.US);
    private static final DateFormat TF3 = new SimpleDateFormat("H:mm:ss z'|'", Locale.US);
    private static final DateFormat TF4 = new SimpleDateFormat("h:mm:ss a z'|'", Locale.US);
    public static final String LINE_BREAK;

    public static String htmlEnc(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '<' && c != '>' && c != '&' && c != '\"') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '>': {
                    b.append("&gt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                case '\"': {
                    b.append("&quot;");
                    break;
                }
                default: {
                    throw new BugException("Illegal char");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '<' || c == '>' || c == '&' || c == '\"') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '<': {
                            b.append("&lt;");
                            break;
                        }
                        case '>': {
                            b.append("&gt;");
                            break;
                        }
                        case '&': {
                            b.append("&amp;");
                            break;
                        }
                        case '\"': {
                            b.append("&quot;");
                            break;
                        }
                        default: {
                            throw new BugException("Illegal char");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String xmlEnc(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '<' && c != '>' && c != '&' && c != '\"' && c != '\'') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '>': {
                    b.append("&gt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                case '\"': {
                    b.append("&quot;");
                    break;
                }
                case '\'': {
                    b.append("&apos;");
                    break;
                }
                default: {
                    throw new BugException("Illegal char");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '<': {
                            b.append("&lt;");
                            break;
                        }
                        case '>': {
                            b.append("&gt;");
                            break;
                        }
                        case '&': {
                            b.append("&amp;");
                            break;
                        }
                        case '\"': {
                            b.append("&quot;");
                            break;
                        }
                        case '\'': {
                            b.append("&apos;");
                            break;
                        }
                        default: {
                            throw new BugException("Illegal char");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String xmlEncNQ(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '<' && c != '>' && c != '&') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '>': {
                    b.append("&gt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                default: {
                    throw new BugException("Illegal char");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '<' || c == '>' || c == '&') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '<': {
                            b.append("&lt;");
                            break;
                        }
                        case '>': {
                            b.append("&gt;");
                            break;
                        }
                        case '&': {
                            b.append("&amp;");
                            break;
                        }
                        default: {
                            throw new BugException("Illegal char");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String rtfEnc(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '{' && c != '}') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '{': {
                    b.append("\\{");
                    break;
                }
                case '}': {
                    b.append("\\}");
                    break;
                }
                default: {
                    throw new BugException("Illegal char");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '\\' || c == '{' || c == '}') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '\\': {
                            b.append("\\\\");
                            break;
                        }
                        case '{': {
                            b.append("\\{");
                            break;
                        }
                        case '}': {
                            b.append("\\}");
                            break;
                        }
                        default: {
                            throw new BugException("Illegal char");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String jQuoteOrName(char c) {
        if (c == '\\' || c == '\'' || c == '\"' || c < ' ') {
            switch (c) {
                case '\\': {
                    return "'\\\\'";
                }
                case '\'': {
                    return "apostrophe-quote";
                }
                case '\"': {
                    return "quotation mark";
                }
                case '\n': {
                    return "'\\n'";
                }
                case '\r': {
                    return "'\\r'";
                }
                case '\t': {
                    return "'\\t'";
                }
                case '\b': {
                    return "'\\b'";
                }
                case '\f': {
                    return "'\\f'";
                }
            }
            String s = Integer.toHexString(c);
            int ln = s.length();
            if (ln == 1) {
                return "'\\u000" + s + "'";
            }
            if (ln == 2) {
                return "'\\u00" + s + "'";
            }
            if (ln == 3) {
                return "'\\u0" + s + "'";
            }
            return "'\\u" + s + "'";
        }
        return "'" + c + "'";
    }

    public static String jQuote(char c) {
        if (c == '\\' || c == '\'' || c < ' ') {
            switch (c) {
                case '\\': {
                    return "'\\\\'";
                }
                case '\'': {
                    return "'\\''";
                }
                case '\n': {
                    return "'\\n'";
                }
                case '\r': {
                    return "'\\r'";
                }
                case '\t': {
                    return "'\\t'";
                }
                case '\b': {
                    return "'\\b'";
                }
                case '\f': {
                    return "'\\f'";
                }
            }
            String s = Integer.toHexString(c);
            int ln = s.length();
            if (ln == 1) {
                return "'\\u000" + s + "'";
            }
            if (ln == 2) {
                return "'\\u00" + s + "'";
            }
            if (ln == 3) {
                return "'\\u0" + s + "'";
            }
            return "'\\u" + s + "'";
        }
        return "'" + c + "'";
    }

    public static String jQuote(String s) {
        if (s == null) {
            return "null";
        }
        int ln = s.length();
        int next = 0;
        StringBuffer b = new StringBuffer(ln + 3);
        b.append("\"");
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '\"' && c >= ' ') continue;
            b.append(s.substring(next, i));
            switch (c) {
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '\"': {
                    b.append("\\\"");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                default: {
                    b.append("\\u0000");
                    int x = b.length();
                    String s2 = Integer.toHexString(c);
                    b.replace(x - s2.length(), x, s2);
                }
            }
            next = i + 1;
        }
        if (next < ln) {
            b.append(s.substring(next));
        }
        b.append("\"");
        return b.toString();
    }

    public static String ftlStringLiteralDec(String s) throws ParseException {
        int idx = s.indexOf(92);
        if (idx == -1) {
            return s;
        }
        int lidx = s.length() - 1;
        int bidx = 0;
        StringBuffer buf = new StringBuffer(lidx);
        do {
            buf.append(s.substring(bidx, idx));
            if (idx >= lidx) {
                throw new ParseException("The last character of string literal is backslash");
            }
            char c = s.charAt(idx + 1);
            switch (c) {
                case '\"': {
                    buf.append('\"');
                    bidx = idx + 2;
                    break;
                }
                case '\'': {
                    buf.append('\'');
                    bidx = idx + 2;
                    break;
                }
                case '\\': {
                    buf.append('\\');
                    bidx = idx + 2;
                    break;
                }
                case 'n': {
                    buf.append('\n');
                    bidx = idx + 2;
                    break;
                }
                case 'r': {
                    buf.append('\r');
                    bidx = idx + 2;
                    break;
                }
                case 't': {
                    buf.append('\t');
                    bidx = idx + 2;
                    break;
                }
                case 'f': {
                    buf.append('\f');
                    bidx = idx + 2;
                    break;
                }
                case 'b': {
                    buf.append('\b');
                    bidx = idx + 2;
                    break;
                }
                case 'g': {
                    buf.append('>');
                    bidx = idx + 2;
                    break;
                }
                case 'l': {
                    buf.append('<');
                    bidx = idx + 2;
                    break;
                }
                case 'a': {
                    buf.append('&');
                    bidx = idx + 2;
                    break;
                }
                case '{': {
                    buf.append('{');
                    bidx = idx + 2;
                    break;
                }
                case 'x': {
                    int z;
                    int x = idx += 2;
                    int y = 0;
                    int n = z = lidx > idx + 3 ? idx + 3 : lidx;
                    while (idx <= z) {
                        char b = s.charAt(idx);
                        if (b >= '0' && b <= '9') {
                            y <<= 4;
                            y += b - 48;
                        } else if (b >= 'a' && b <= 'f') {
                            y <<= 4;
                            y += b - 97 + 10;
                        } else {
                            if (b < 'A' || b > 'F') break;
                            y <<= 4;
                            y += b - 65 + 10;
                        }
                        ++idx;
                    }
                    if (x >= idx) {
                        throw new ParseException("Invalid \\x escape in a string literal");
                    }
                    buf.append((char)y);
                    bidx = idx;
                    break;
                }
                default: {
                    throw new ParseException("Invalid escape sequence (\\" + c + ") in " + "a string literal");
                }
            }
        } while ((idx = s.indexOf(92, bidx)) != -1);
        buf.append(s.substring(bidx));
        return buf.toString();
    }

    public static String stringToPerl5Regex(String text) {
        StringBuffer sb = new StringBuffer();
        char[] chars = text.toCharArray();
        int ln = chars.length;
        for (int i = 0; i < ln; ++i) {
            char c = chars[i];
            if (c == '\\' || c == '^' || c == '.' || c == '$' || c == '|' || c == '(' || c == ')' || c == '[' || c == ']' || c == '*' || c == '+' || c == '?' || c == '{' || c == '}' || c == '@') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] split(String s, char c) {
        return StringUtil.split(s, c, false);
    }

    public static String[] split(String s, char c, boolean trim) {
        int ln = s.length();
        int i = 0;
        int cnt = 1;
        while ((i = s.indexOf(c, i)) != -1) {
            ++cnt;
            ++i;
        }
        String[] res = new String[cnt];
        i = 0;
        int b = 0;
        while (b <= ln) {
            int e = s.indexOf(c, b);
            if (e == -1) {
                e = ln;
            }
            if (!trim) {
                res[i++] = s.substring(b, e);
            } else {
                int e2;
                for (e2 = e - 1; e2 >= 0 && Character.isWhitespace(s.charAt(e2)); --e2) {
                }
                ++e2;
                while (b < ln && Character.isWhitespace(s.charAt(b))) {
                    ++b;
                }
                res[i++] = b < e ? s.substring(b, e2) : "";
            }
            b = e + 1;
        }
        return res;
    }

    public static String[] split(String s, String sep) {
        int ln = s.length();
        int sln = sep.length();
        if (sln == 0) {
            throw new IllegalArgumentException("The separator string has 0 length");
        }
        int i = 0;
        int cnt = 1;
        while ((i = s.indexOf(sep, i)) != -1) {
            ++cnt;
            i += sln;
        }
        String[] res = new String[cnt];
        i = 0;
        int b = 0;
        while (b <= ln) {
            int e = s.indexOf(sep, b);
            if (e == -1) {
                e = ln;
            }
            res[i++] = s.substring(b, e);
            b = e + sln;
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public static String[] splitAtWS(String text) {
        i = 0;
        ln = text.length();
        cnt = 0;
        block0: while (true) {
            if (i < ln && Character.isWhitespace(text.charAt(i))) {
                ++i;
                continue;
            }
            if (i >= ln) break;
            ++cnt;
            while (true) {
                if (i < ln && !Character.isWhitespace(text.charAt(i))) ** break;
                continue block0;
                ++i;
            }
            break;
        }
        res = new String[cnt];
        x = 0;
        i = 0;
        while (true) {
            if (i < ln && Character.isWhitespace(text.charAt(i))) {
                ++i;
                continue;
            }
            b = i;
            if (i >= ln) break;
            ++cnt;
            while (i < ln && !Character.isWhitespace(text.charAt(i))) {
                ++i;
            }
            res[x++] = text.substring(b, i);
        }
        return res;
    }

    public static String replace(String text, String oldsub, String newsub) {
        int e = text.indexOf(oldsub);
        if (e == -1) {
            return text;
        }
        int b = 0;
        int tln = text.length();
        int oln = oldsub.length();
        StringBuffer buf = new StringBuffer(tln + 16);
        do {
            buf.append(text.substring(b, e));
            buf.append(newsub);
        } while ((e = text.indexOf(oldsub, b = e + oln)) != -1);
        buf.append(text.substring(b));
        return buf.toString();
    }

    public static String expandTabs(String text, int tabWidth) {
        return StringUtil.expandTabs(text, tabWidth, 0);
    }

    public static String expandTabs(String text, int tabWidth, int startCol) {
        int e = text.indexOf(9);
        if (e == -1) {
            return text;
        }
        int b = 0;
        int tln = text.length();
        StringBuffer buf = new StringBuffer(tln + 16);
        do {
            buf.append(text.substring(b, e));
            int col = buf.length() + startCol;
            for (int i = tabWidth * (1 + col / tabWidth) - col; i > 0; --i) {
                buf.append(' ');
            }
        } while ((e = text.indexOf(9, b = e + 1)) != -1);
        buf.append(text.substring(b));
        return buf.toString();
    }

    public static String chomp(String s) {
        if (s.endsWith("\r\n")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.endsWith("\r") || s.endsWith("\n")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static void chomp(StringBuffer sb) {
        char c;
        int ln = sb.length();
        if (ln >= 2 && sb.charAt(ln - 2) == '\r' && sb.charAt(ln - 1) == '\n') {
            sb.setLength(ln - 2);
        } else if (ln >= 1 && ((c = sb.charAt(ln - 1)) == '\n' || c == '\r')) {
            sb.setLength(ln - 1);
        }
    }

    public static String urlEnc(String s, String enc) throws UnsupportedEncodingException {
        char c;
        int i;
        int ln = s.length();
        for (i = 0; i < ln && ((c = s.charAt(i)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '.' || c == '!' || c == '~' || c >= '\'' && c <= '*'); ++i) {
        }
        if (i == ln) {
            return s;
        }
        StringBuffer b = new StringBuffer((int)((double)ln * 1.333) + 2);
        b.append(s.substring(0, i));
        int encstart = i++;
        while (i < ln) {
            char c2 = s.charAt(i);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '-' || c2 == '.' || c2 == '!' || c2 == '~' || c2 >= '\'' && c2 <= '*') {
                if (encstart != -1) {
                    byte[] o = s.substring(encstart, i).getBytes(enc);
                    for (int j = 0; j < o.length; ++j) {
                        b.append('%');
                        byte bc = o[j];
                        int c1 = bc & 0xF;
                        int c22 = bc >> 4 & 0xF;
                        b.append((char)(c22 < 10 ? c22 + 48 : c22 - 10 + 65));
                        b.append((char)(c1 < 10 ? c1 + 48 : c1 - 10 + 65));
                    }
                    encstart = -1;
                }
                b.append(c2);
            } else if (encstart == -1) {
                encstart = i;
            }
            ++i;
        }
        if (encstart != -1) {
            byte[] o = s.substring(encstart, i).getBytes(enc);
            for (int j = 0; j < o.length; ++j) {
                b.append('%');
                byte bc = o[j];
                int c1 = bc & 0xF;
                int c2 = bc >> 4 & 0xF;
                b.append((char)(c2 < 10 ? c2 + 48 : c2 - 10 + 65));
                b.append((char)(c1 < 10 ? c1 + 48 : c1 - 10 + 65));
            }
        }
        return b.toString();
    }

    public static String urlPathEnc(String s, String enc) throws UnsupportedEncodingException {
        char c;
        int i;
        int ln = s.length();
        for (i = 0; i < ln && ((c = s.charAt(i)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '/' || c == '_' || c == '-' || c == '.' || c == '!' || c == '~' || c >= '\'' && c <= '*'); ++i) {
        }
        if (i == ln) {
            return s;
        }
        StringBuffer b = new StringBuffer((int)((double)ln * 1.333) + 2);
        b.append(s.substring(0, i));
        int encstart = i++;
        while (i < ln) {
            char c2 = s.charAt(i);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '/' || c2 == '_' || c2 == '-' || c2 == '.' || c2 == '!' || c2 == '~' || c2 >= '\'' && c2 <= '*') {
                if (encstart != -1) {
                    byte[] o = s.substring(encstart, i).getBytes(enc);
                    for (int j = 0; j < o.length; ++j) {
                        b.append('%');
                        byte bc = o[j];
                        int c1 = bc & 0xF;
                        int c22 = bc >> 4 & 0xF;
                        b.append((char)(c22 < 10 ? c22 + 48 : c22 - 10 + 65));
                        b.append((char)(c1 < 10 ? c1 + 48 : c1 - 10 + 65));
                    }
                    encstart = -1;
                }
                b.append(c2);
            } else if (encstart == -1) {
                encstart = i;
            }
            ++i;
        }
        if (encstart != -1) {
            byte[] o = s.substring(encstart, i).getBytes(enc);
            for (int j = 0; j < o.length; ++j) {
                b.append('%');
                byte bc = o[j];
                int c1 = bc & 0xF;
                int c2 = bc >> 4 & 0xF;
                b.append((char)(c2 < 10 ? c2 + 48 : c2 - 10 + 65));
                b.append((char)(c1 < 10 ? c1 + 48 : c1 - 10 + 65));
            }
        }
        return b.toString();
    }

    public static String wrap(String text, int screenWidth) {
        return StringUtil.wrap(text, screenWidth, 0, 0, LINE_BREAK, false);
    }

    public static String wrapTrace(String text, int screenWidth) {
        return StringUtil.wrap(text, screenWidth, 0, 0, LINE_BREAK, true);
    }

    public static String wrap(String text, int screenWidth, String lineBreak) {
        return StringUtil.wrap(text, screenWidth, 0, 0, lineBreak, false);
    }

    public static String wrap(String text, int screenWidth, int indent) {
        return StringUtil.wrap(text, screenWidth, indent, indent, LINE_BREAK, false);
    }

    public static String wrap(String text, int screenWidth, int firstIndent, int indent) {
        return StringUtil.wrap(text, screenWidth, firstIndent, indent, LINE_BREAK, false);
    }

    public static String wrap(String text, int screenWidth, int indent, String lineBreak) {
        return StringUtil.wrap(text, screenWidth, indent, indent, lineBreak, false);
    }

    public static String wrap(String text, int screenWidth, int firstIndent, int indent, String lineBreak) {
        return StringUtil.wrap(text, screenWidth, firstIndent, indent, lineBreak, false);
    }

    public static StringBuffer wrap(StringBuffer text, int screenWidth, int firstIndent, int indent) {
        return StringUtil.wrap(text, screenWidth, firstIndent, indent, LINE_BREAK, false);
    }

    public static String wrap(String text, int screenWidth, int firstIndent, int indent, String lineBreak, boolean traceMode) {
        return StringUtil.wrap(new StringBuffer(text), screenWidth, firstIndent, indent, lineBreak, traceMode).toString();
    }

    public static StringBuffer wrap(StringBuffer text, int screenWidth, int firstIndent, int indent, String lineBreak, boolean traceMode) {
        if (firstIndent < 0 || indent < 0 || screenWidth < 0) {
            throw new IllegalArgumentException("Negative dimension");
        }
        int allowedCols = screenWidth - 1;
        if (allowedCols - indent < 2 || allowedCols - firstIndent < 2) {
            throw new IllegalArgumentException("Usable columns < 2");
        }
        int ln = text.length();
        int defaultNextLeft = allowedCols - indent;
        int b = 0;
        int e = 0;
        StringBuffer res = new StringBuffer((int)((double)ln * 1.2));
        int left = allowedCols - firstIndent;
        for (int i = 0; i < firstIndent; ++i) {
            res.append(' ');
        }
        StringBuffer tempb = new StringBuffer(indent + 2);
        tempb.append(lineBreak);
        for (int i = 0; i < indent; ++i) {
            tempb.append(' ');
        }
        String defaultBreakAndIndent = tempb.toString();
        boolean firstSectOfSrcLine = true;
        boolean firstWordOfSrcLine = true;
        int traceLineState = 0;
        int nextLeft = defaultNextLeft;
        String breakAndIndent = defaultBreakAndIndent;
        int wln = 0;
        while (true) {
            char c2;
            char c;
            if (e <= ln) {
                c = e != ln ? (char)text.charAt(e) : (char)' ';
                if (traceLineState > 0 && e > b) {
                    if (c == '.' && traceLineState == 1) {
                        c = ' ';
                    } else {
                        c2 = text.charAt(e - 1);
                        if (c2 == ':') {
                            c = ' ';
                        } else if (c2 == '(') {
                            traceLineState = 2;
                            c = ' ';
                        }
                    }
                }
                if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                    ++e;
                    continue;
                }
                wln = e - b;
                if (left >= wln) {
                    res.append(text.substring(b, e));
                    left -= wln;
                    b = e;
                } else {
                    int x;
                    wln = e - b;
                    if (wln > nextLeft || firstWordOfSrcLine) {
                        int ob = b;
                        while (wln > left) {
                            if (left > 2 || left == 2 && (firstWordOfSrcLine || b != ob || nextLeft <= 2)) {
                                res.append(text.substring(b, b + left - 1));
                                res.append("-");
                                res.append(breakAndIndent);
                                wln -= left - 1;
                                b += left - 1;
                                left = nextLeft;
                                continue;
                            }
                            x = res.length() - 1;
                            if (x >= 0 && res.charAt(x) == ' ') {
                                res.delete(x, x + 1);
                            }
                            res.append(breakAndIndent);
                            left = nextLeft;
                        }
                        res.append(text.substring(b, b + wln));
                        b += wln;
                        left -= wln;
                    } else {
                        x = res.length() - 1;
                        if (x >= 0 && res.charAt(x) == ' ') {
                            res.delete(x, x + 1);
                        }
                        res.append(breakAndIndent);
                        res.append(text.substring(b, e));
                        left = nextLeft - wln;
                        b = e;
                    }
                }
                firstSectOfSrcLine = false;
                firstWordOfSrcLine = false;
            }
            int extra = 0;
            while (e < ln) {
                c = text.charAt(e);
                if (c == ' ') {
                    ++e;
                    continue;
                }
                if (c == '\t') {
                    ++e;
                    extra += 7;
                    continue;
                }
                if (c == '\n' || c == '\r') {
                    nextLeft = defaultNextLeft;
                    breakAndIndent = defaultBreakAndIndent;
                    res.append(breakAndIndent);
                    if (++e >= ln || (c2 = text.charAt(e)) != '\n' && c2 != '\r' || c != c2) {
                        // empty if block
                    }
                    left = nextLeft;
                    b = ++e;
                    firstSectOfSrcLine = true;
                    firstWordOfSrcLine = true;
                    traceLineState = 0;
                    continue;
                }
                wln = e - b + extra;
                if (firstSectOfSrcLine) {
                    int y = allowedCols - indent - wln;
                    if (traceMode && ln > e + 2 && text.charAt(e) == 'a' && text.charAt(e + 1) == 't' && text.charAt(e + 2) == ' ') {
                        if (y > 8) {
                            y -= 3;
                        }
                        traceLineState = 1;
                    }
                    if (y > 5) {
                        y = allowedCols - y;
                        nextLeft = allowedCols - y;
                        tempb = new StringBuffer(indent + 2);
                        tempb.append(lineBreak);
                        for (int i = 0; i < y; ++i) {
                            tempb.append(' ');
                        }
                        breakAndIndent = tempb.toString();
                    }
                }
                if (wln <= left) {
                    res.append(text.substring(b, e));
                    left -= wln;
                    b = e;
                } else {
                    res.append(breakAndIndent);
                    left = nextLeft;
                    b = e;
                }
                firstSectOfSrcLine = false;
                break;
            }
            if (e >= ln) break;
        }
        return res;
    }

    public static String createSourceCodeErrorMessage(String message, String srcCode, int position, String fileName, int maxQuotLength) {
        int ln2;
        int rowEnd;
        char c;
        int i;
        int ln = srcCode.length();
        if (position < 0) {
            position = 0;
        }
        if (position >= ln) {
            if (position == ln) {
                return message + LINE_BREAK + "Error location: The very end of " + (fileName == null ? "the text" : fileName) + ".";
            }
            return message + LINE_BREAK + "Error location: ??? (after the end of " + (fileName == null ? "the text" : fileName) + ")";
        }
        int rowBegin = 0;
        int row = 1;
        int lastChar = 0;
        for (i = 0; i <= position; ++i) {
            c = srcCode.charAt(i);
            if (lastChar == 10) {
                rowBegin = i;
                ++row;
            } else if (lastChar == 13 && c != '\n') {
                rowBegin = i;
                ++row;
            }
            lastChar = c;
        }
        for (i = position; i < ln; ++i) {
            c = srcCode.charAt(i);
            if (c != '\n' && c != '\r') continue;
            if (c != '\n' || i <= 0 || srcCode.charAt(i - 1) != '\r') break;
            --i;
            break;
        }
        if (position > (rowEnd = i - 1) + 1) {
            position = rowEnd + 1;
        }
        int col = position - rowBegin + 1;
        if (rowBegin > rowEnd) {
            return message + LINE_BREAK + "Error location: line " + row + ", column " + col + (fileName == null ? ":" : " in " + fileName + ":") + LINE_BREAK + "(Can't show the line because it is empty.)";
        }
        String s1 = srcCode.substring(rowBegin, position);
        String s2 = srcCode.substring(position, rowEnd + 1);
        int ln1 = (s1 = StringUtil.expandTabs(s1, 8)).length();
        if (ln1 + (ln2 = (s2 = StringUtil.expandTabs(s2, 8, ln1)).length()) > maxQuotLength) {
            int newLn2 = ln2 - (ln1 + ln2 - maxQuotLength);
            if (newLn2 < 6) {
                newLn2 = 6;
            }
            if (newLn2 < ln2) {
                s2 = s2.substring(0, newLn2 - 3) + "...";
                ln2 = newLn2;
            }
            if (ln1 + ln2 > maxQuotLength) {
                s1 = "..." + s1.substring(ln1 + ln2 - maxQuotLength + 3);
            }
        }
        StringBuffer res = new StringBuffer(message.length() + 80);
        res.append(message);
        res.append(LINE_BREAK);
        res.append("Error location: line ");
        res.append(row);
        res.append(", column ");
        res.append(col);
        if (fileName != null) {
            res.append(" in ");
            res.append(fileName);
        }
        res.append(":");
        res.append(LINE_BREAK);
        res.append(s1);
        res.append(s2);
        res.append(LINE_BREAK);
        for (int x = s1.length(); x != 0; --x) {
            res.append(' ');
        }
        res.append('^');
        return res.toString();
    }

    public static BigDecimal stringToBigDecimal(String s) throws ParseException {
        s = s.trim();
        try {
            return new BigDecimal(s);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Value " + StringUtil.jQuote(s) + " is not a valid number.");
        }
    }

    public static boolean stringToBoolean(String s) throws ParseException {
        if ((s = s.trim().toLowerCase()).equals("yes") || s.equals("true") || s.equals("y") || s.equals("1")) {
            return true;
        }
        if (s.equals("no") || s.equals("false") || s.equals("n") || s.equals("0")) {
            return false;
        }
        throw new ParseException("Value " + StringUtil.jQuote(s) + " is " + "not a valid boolean.");
    }

    public static TemplateDateModel stringToDate(String s, TimeZone tz) throws ParseException {
        String orig = s;
        s = s.trim() + "|";
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        DateFormat dateFormat = DF1;
        synchronized (dateFormat) {
            DF1.setTimeZone(tz);
            try {
                return new SimpleDate(DF1.parse(s), 2);
            }
            catch (java.text.ParseException e) {
                DF2.setTimeZone(tz);
                try {
                    return new SimpleDate(DF2.parse(s), 2);
                }
                catch (java.text.ParseException e2) {
                    throw new ParseException("Failed to parse " + StringUtil.jQuote(orig) + " as date. Use format " + "\"yyyy-MM-dd\" or \"yyyy-MM-dd z\".");
                }
            }
        }
    }

    public static TemplateDateModel stringToTime(String s, TimeZone tz) throws ParseException {
        String orig = s;
        s = s.trim() + "|";
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        DateFormat dateFormat = TF1;
        synchronized (dateFormat) {
            TF1.setTimeZone(tz);
            try {
                return new SimpleDate(TF1.parse(s), 1);
            }
            catch (java.text.ParseException e) {
                TF2.setTimeZone(tz);
                try {
                    return new SimpleDate(TF2.parse(s), 1);
                }
                catch (java.text.ParseException e2) {
                    TF3.setTimeZone(tz);
                    try {
                        return new SimpleDate(TF3.parse(s), 1);
                    }
                    catch (java.text.ParseException e3) {
                        TF4.setTimeZone(tz);
                        try {
                            return new SimpleDate(TF4.parse(s), 1);
                        }
                        catch (java.text.ParseException e4) {
                            throw new ParseException("Failed to parse " + StringUtil.jQuote(orig) + " as time. Use format " + "\"H:mm:ss\" or \"h:mm:ss a\" " + "or \"H:mm:ss z\" or \"h:mm:ss a z\".");
                        }
                    }
                }
            }
        }
    }

    public static TemplateDateModel stringToDateTime(String s, TimeZone tz) throws ParseException {
        String orig = s;
        s = s.trim() + "|";
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        DateFormat dateFormat = DTF1;
        synchronized (dateFormat) {
            DTF1.setTimeZone(tz);
            try {
                return new SimpleDate(DTF1.parse(s), 3);
            }
            catch (java.text.ParseException e) {
                DTF2.setTimeZone(tz);
                try {
                    return new SimpleDate(DTF2.parse(s), 3);
                }
                catch (java.text.ParseException e2) {
                    DTF3.setTimeZone(tz);
                    try {
                        return new SimpleDate(DTF3.parse(s), 3);
                    }
                    catch (java.text.ParseException e3) {
                        DTF4.setTimeZone(tz);
                        try {
                            return new SimpleDate(DTF4.parse(s), 3);
                        }
                        catch (java.text.ParseException e4) {
                            throw new ParseException("Failed to parse " + StringUtil.jQuote(orig) + " as date-time. Use format " + "\"yyyy-MM-dd H:mm:ss\" " + "or \"yyyy-MM-dd h:mm:ss a\" " + "or \"yyyy-MM-dd H:mm:ss z\" " + "or \"yyyy-MM-dd h:mm:ss a z\".");
                        }
                    }
                }
            }
        }
    }

    public static String normalizeLinebreaks(String s) {
        char c;
        int i;
        int ln = s.length();
        for (i = 0; i < ln && (c = s.charAt(i)) != '\r'; ++i) {
        }
        if (i == ln) {
            return s;
        }
        StringBuffer res = new StringBuffer(ln);
        for (int x = 0; x < i; ++x) {
            res.append(s.charAt(x));
        }
        block2: while (true) {
            if (i + 1 < ln && s.charAt(i + 1) == '\n') {
                ++i;
            }
            res.append('\n');
            while (++i != ln) {
                c = s.charAt(i);
                if (c == '\r') continue block2;
                res.append(c);
            }
            break;
        }
        return res.toString();
    }

    public static String repeat(String s, int n) {
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return s;
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative repeat count: " + n);
        }
        StringBuffer sb = new StringBuffer(s.length() * n);
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String capitalizeFirst(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        char c = s.charAt(0);
        return Character.isLowerCase(c) ? Character.toUpperCase(c) + s.substring(1) : s;
    }

    static {
        DF1.setLenient(false);
        DF2.setLenient(false);
        DTF1.setLenient(false);
        DTF2.setLenient(false);
        DTF3.setLenient(false);
        DTF4.setLenient(false);
        TF1.setLenient(false);
        TF2.setLenient(false);
        TF3.setLenient(false);
        TF4.setLenient(false);
        LINE_BREAK = System.getProperty("line.separator");
    }

    public static class ParseException
    extends ExceptionCC {
        public ParseException(String message) {
            super(message);
        }

        public ParseException(String message, int position) {
            super(message + LINE_BREAK + "Error location: character " + (position + 1));
        }

        public ParseException(String message, String text, int position, String fileName) {
            super(StringUtil.createSourceCodeErrorMessage(message, text, position, fileName, 56));
        }

        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public ParseException(String message, int position, Throwable cause) {
            super(message + LINE_BREAK + "Error location: character " + (position + 1), cause);
        }

        public ParseException(String message, String text, int position, String fileName, Throwable cause) {
            super(StringUtil.createSourceCodeErrorMessage(message, text, position, fileName, 56), cause);
        }
    }
}

