/*
 * Decompiled with CFR 0.152.
 */
package fmpp;

import fmpp.Engine;
import fmpp.FmppOutputWriter;
import fmpp.util.FileUtil;
import fmpp.util.NullWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;

class FmppFileOutputWriter
extends FmppOutputWriter {
    private static final int BUFFER_SIZE = 160;
    private Engine engine;
    private ArrayList stateStack = new ArrayList();
    private boolean closed = false;
    private boolean ignoreFlush = false;
    private File dst;
    private String enc;
    private int freeBuf = 160;
    private StringBuffer buf = new StringBuffer(160);
    private Writer fileWriter;
    private boolean append;
    private SavedState sharedSavedState;

    FmppFileOutputWriter(Engine engine, File dst, String enc) {
        this.engine = engine;
        this.engine = engine;
        this.dst = dst;
        this.enc = enc;
    }

    @Override
    public void write(String data) throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.write(data);
        } else {
            int ln = data.length();
            if (ln <= this.freeBuf) {
                this.buf.append(data);
                this.freeBuf -= ln;
            } else {
                this.createFileWriter();
                this.fileWriter.write(this.buf.toString());
                this.buf = null;
                this.fileWriter.write(data);
            }
        }
    }

    @Override
    public void write(char[] data, int off, int len) throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.write(data, off, len);
        } else {
            int ln = data.length;
            if (ln <= this.freeBuf) {
                this.buf.append(data, off, len);
                this.freeBuf -= ln;
            } else {
                this.createFileWriter();
                this.fileWriter.write(this.buf.toString());
                this.buf = null;
                this.fileWriter.write(data, off, len);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.ignoreFlush) {
            if (this.fileWriter == null) {
                this.createFileWriter();
                this.fileWriter.write(this.buf.toString());
                this.buf = null;
            }
            this.fileWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean error) throws IOException {
        if (this.closed) {
            return;
        }
        try {
            while (true) {
                try {
                    if (!error || this.fileWriter != null || this.buf != null && this.buf.length() != 0) {
                        this.flush();
                    }
                }
                finally {
                    if (this.fileWriter != null) {
                        this.fileWriter.close();
                    }
                }
                this.fileWriter = null;
                if (this.stateStack.size() == 0) {
                    break;
                }
                this.nestOutputFileEnd(true);
            }
        }
        finally {
            for (SavedState s : this.stateStack) {
                try {
                    s.fileWriter.close();
                }
                catch (Throwable exc) {}
            }
            this.stateStack.clear();
            this.closed = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    @Override
    void dropOutputFile() throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.close();
            if (this.dst.isFile()) {
                this.dst.delete();
            }
        }
        this.fileWriter = NullWriter.INSTANCE;
        this.buf = null;
    }

    @Override
    void restartOutputFile() throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.close();
        }
        this.initOutputBufferAndWriter();
    }

    @Override
    void renameOutputFile(String newName) throws IOException {
        File newDst = this.deduceNewDst(newName);
        if (this.dst.equals(newDst)) {
            return;
        }
        if (this.fileWriter != null) {
            File parent;
            this.flush();
            this.fileWriter.close();
            this.initOutputBufferAndWriter();
            if (!this.dst.isFile()) {
                throw new IOException("Can't find the file to rename: " + this.dst.getPath());
            }
            if (newDst.isFile()) {
                newDst.delete();
            }
            if ((parent = newDst.getParentFile()) != null && !parent.exists()) {
                parent.mkdirs();
            }
            if (!this.dst.renameTo(newDst)) {
                throw new IOException("Failed to rename " + this.dst.getPath() + " to " + newDst.getPath());
            }
            this.append = true;
        }
        this.dst = newDst;
    }

    @Override
    void changeOutputFile(String newName, boolean append) throws IOException {
        File newDst = this.deduceNewDst(newName);
        if (this.dst.equals(newDst)) {
            return;
        }
        for (int i = this.stateStack.size() - 1; i >= 0; --i) {
            SavedState s = (SavedState)this.stateStack.get(i);
            if (!s.dst.equals(newDst)) continue;
            if (this.sharedSavedState != null && s == this.sharedSavedState) break;
            throw new IOException("Something is already using this file as output: " + newDst.getAbsolutePath());
        }
        this.flush();
        this.fileWriter.close();
        this.initOutputBufferAndWriter();
        this.append = append;
        this.dst = newDst;
    }

    @Override
    void nestOutputFileBegin(String newName, boolean append) throws IOException {
        File newDst = this.deduceNewDst(newName);
        SavedState s = new SavedState();
        s.store();
        this.stateStack.add(s);
        for (int i = this.stateStack.size() - 1; i >= 0; --i) {
            s = (SavedState)this.stateStack.get(i);
            if (!s.dst.equals(newDst)) continue;
            s.load();
            this.sharedSavedState = s;
            return;
        }
        this.initOutputBufferAndWriter();
        this.sharedSavedState = null;
        this.append = append;
        this.dst = newDst;
    }

    @Override
    void nestOutputFileEnd(boolean alreadyClosed) throws IOException {
        SavedState s;
        if (this.stateStack.size() == 0) {
            throw new RuntimeException("There is no more saved state in the state-stack!");
        }
        if (this.sharedSavedState != null) {
            s = this.sharedSavedState.sharedSavedState;
            this.sharedSavedState.store();
            this.sharedSavedState.sharedSavedState = s;
        } else if (!alreadyClosed) {
            this.flush();
            this.fileWriter.close();
        }
        s = (SavedState)this.stateStack.remove(this.stateStack.size() - 1);
        s.load();
    }

    @Override
    void setOutputEncoding(String enc) throws IOException {
        if (this.fileWriter != null && !(this.fileWriter instanceof NullWriter)) {
            throw new IOException("Can't change the output encoding becasue some of the output was already written to the file.");
        }
        this.enc = enc.equals("host") ? System.getProperty("file.encoding") : enc;
    }

    @Override
    String getOutputEncoding() {
        return this.enc;
    }

    @Override
    void setIgnoreFlush(boolean ignore) {
        this.ignoreFlush = ignore;
    }

    private void createFileWriter() throws IOException {
        File p = this.dst.getParentFile();
        if (p != null) {
            p.mkdirs();
        }
        this.fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.dst.getPath(), this.append), this.enc));
    }

    private File deduceNewDst(String newName) throws IOException {
        newName = FileUtil.pathToUnixStyle(newName);
        return FileUtil.resolveRelativeUnixPath(this.engine.getOutputRoot(), this.dst.getParentFile(), newName);
    }

    private void initOutputBufferAndWriter() {
        this.fileWriter = null;
        if (this.buf == null) {
            this.buf = new StringBuffer(160);
        } else {
            this.buf.delete(0, this.buf.length());
        }
        this.freeBuf = 160;
    }

    @Override
    public File getOutputFile() {
        return this.dst;
    }

    private class SavedState {
        private File dst;
        private String enc;
        private int freeBuf;
        private StringBuffer buf;
        private Writer fileWriter;
        private boolean append;
        private SavedState sharedSavedState;

        private SavedState() {
        }

        private void store() {
            this.dst = FmppFileOutputWriter.this.dst;
            this.enc = FmppFileOutputWriter.this.enc;
            this.freeBuf = FmppFileOutputWriter.this.freeBuf;
            this.buf = FmppFileOutputWriter.this.buf;
            this.fileWriter = FmppFileOutputWriter.this.fileWriter;
            this.append = FmppFileOutputWriter.this.append;
            this.sharedSavedState = FmppFileOutputWriter.this.sharedSavedState;
        }

        private void load() {
            FmppFileOutputWriter.this.dst = this.dst;
            FmppFileOutputWriter.this.enc = this.enc;
            FmppFileOutputWriter.this.freeBuf = this.freeBuf;
            FmppFileOutputWriter.this.buf = this.buf;
            FmppFileOutputWriter.this.append = this.append;
            FmppFileOutputWriter.this.fileWriter = this.fileWriter;
            FmppFileOutputWriter.this.sharedSavedState = this.sharedSavedState;
        }
    }
}

