/*
 * Decompiled with CFR 0.152.
 */
package fmpp.dataloaders;

import fmpp.Engine;
import fmpp.dataloaders.AntDataLoader;
import fmpp.util.BugException;
import fmpp.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class AntPropertiesDataLoader
extends AntDataLoader {
    @Override
    public Object load(Engine eng, List args, Task task) throws StringUtil.ParseException {
        Project proj = task.getProject();
        if (args.size() == 0) {
            return proj.getProperties();
        }
        HashMap<String, String> exposedProps = new HashMap<String, String>();
        for (int i = 0; i < args.size(); ++i) {
            Object xValue;
            String value;
            Object o = args.get(i);
            if (!(o instanceof String)) {
                throw new IllegalArgumentException("The parameters of antProperites data loader must be all strings; the names of the Ant properties to expose.");
            }
            String name = (String)o;
            int type = 0;
            if (name.endsWith("?n")) {
                type = 1;
            } else if (name.endsWith("?b")) {
                type = 2;
            } else if (name.endsWith("?d")) {
                type = 3;
            } else if (name.endsWith("?t")) {
                type = 4;
            } else if (name.endsWith("?dt")) {
                type = 5;
            } else if (name.endsWith("?s")) {
                type = 6;
            }
            if (type != 0) {
                name = name.substring(0, name.lastIndexOf(63));
            }
            if ((value = proj.getProperty(name)) == null) continue;
            if (type == 0 || type == 6) {
                xValue = value;
            } else if (type == 1) {
                try {
                    xValue = StringUtil.stringToBigDecimal(value);
                }
                catch (StringUtil.ParseException e) {
                    throw new StringUtil.ParseException("The value of property " + StringUtil.jQuote(name) + " is invalid.", e);
                }
            } else if (type == 2) {
                try {
                    xValue = StringUtil.stringToBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (StringUtil.ParseException e) {
                    throw new StringUtil.ParseException("The value of property " + StringUtil.jQuote(name) + " is invalid.", e);
                }
            } else if (type == 3) {
                try {
                    xValue = StringUtil.stringToDate(value, eng.getTimeZone());
                }
                catch (StringUtil.ParseException e) {
                    throw new StringUtil.ParseException("The value of property " + StringUtil.jQuote(name) + " is invalid.", e);
                }
            } else if (type == 4) {
                try {
                    xValue = StringUtil.stringToTime(value, eng.getTimeZone());
                }
                catch (StringUtil.ParseException e) {
                    throw new StringUtil.ParseException("The value of property " + StringUtil.jQuote(name) + " is invalid.", e);
                }
            } else if (type == 5) {
                try {
                    xValue = StringUtil.stringToDateTime(value, eng.getTimeZone());
                }
                catch (StringUtil.ParseException e) {
                    throw new StringUtil.ParseException("The value of property " + StringUtil.jQuote(name) + " is invalid.", e);
                }
            } else {
                throw new BugException("Unknown type " + type);
            }
            exposedProps.put(name, (String)xValue);
        }
        return exposedProps;
    }
}

