/*
 * Decompiled with CFR 0.152.
 */
package fmpp.dataloaders;

import fmpp.dataloaders.FileDataLoader;
import fmpp.models.CsvSequence;
import fmpp.util.DataLoaderUtil;
import fmpp.util.StringUtil;
import freemarker.template.TemplateModelException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;

public class CsvDataLoader
extends FileDataLoader {
    @Override
    protected Object load(InputStream data) throws IOException, TemplateModelException, StringUtil.ParseException {
        String encoding = this.engine.getSourceEncoding();
        if (this.args.size() < 1 || this.args.size() > 3) {
            throw new IllegalArgumentException("csv data loader needs 1 or 2 arguments: csv(filename) or csv(filename, options)");
        }
        CsvSequence csvs = new CsvSequence();
        if (this.args.size() > 1) {
            Object obj = this.args.get(1);
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("The 2nd argument (options) must be a hash.");
            }
            boolean aHeaderOpWasUsed = false;
            Map options = (Map)obj;
            for (Map.Entry ent : options.entrySet()) {
                String opname = (String)ent.getKey();
                if (opname.equals("headers")) {
                    if (aHeaderOpWasUsed) {
                        throw new IllegalArgumentException("Only one of the \"headers\" and \"replaceHeaders\" options can be used at once.");
                    }
                    csvs.setExternalHeaderRow(DataLoaderUtil.getStringArrayOption(opname, ent.getValue()));
                    csvs.setHasHeaderRow(false);
                    aHeaderOpWasUsed = true;
                    continue;
                }
                if (opname.equals("replaceHeaders")) {
                    if (aHeaderOpWasUsed) {
                        throw new IllegalArgumentException("Only one of the \"headers\" and \"replaceHeaders\" options can be used at once.");
                    }
                    csvs.setExternalHeaderRow(DataLoaderUtil.getStringArrayOption(opname, ent.getValue()));
                    csvs.setHasHeaderRow(true);
                    aHeaderOpWasUsed = true;
                    continue;
                }
                if (opname.equals("normalizeHeaders")) {
                    csvs.setNormalizeHeaders(DataLoaderUtil.getBooleanOption(opname, ent.getValue()));
                    continue;
                }
                if (opname.equals("trimCells")) {
                    csvs.setTrimCells(DataLoaderUtil.getBooleanOption(opname, ent.getValue()));
                    continue;
                }
                if (opname.equals("emptyValue")) {
                    csvs.setEmptyValues(DataLoaderUtil.getStringArrayOption(opname, ent.getValue(), true));
                    continue;
                }
                if (opname.equals("separator")) {
                    csvs.setSeparator(DataLoaderUtil.getCharOption(opname, ent.getValue()));
                    continue;
                }
                if (opname.equals("groupingSeparator")) {
                    csvs.setGroupingSeparator(DataLoaderUtil.getCharOption(opname, ent.getValue()));
                    continue;
                }
                if (opname.equals("decimalSeparator")) {
                    csvs.setDecimalSeparator(DataLoaderUtil.getCharOption(opname, ent.getValue()));
                    continue;
                }
                if (opname.equals("encoding")) {
                    encoding = DataLoaderUtil.getStringOption(opname, ent.getValue());
                    continue;
                }
                if (opname.equals("altTrue")) {
                    csvs.setAltTrue(DataLoaderUtil.getStringOption(opname, ent.getValue()));
                    continue;
                }
                if (opname.equals("altFalse")) {
                    csvs.setAltFalse(DataLoaderUtil.getStringOption(opname, ent.getValue()));
                    continue;
                }
                if (opname.equals("dateFormat")) {
                    try {
                        csvs.setDateFormatPattern(DataLoaderUtil.getStringOption(opname, ent.getValue()));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new StringUtil.ParseException("The value of option " + StringUtil.jQuote(opname) + " is illegal.", e);
                    }
                }
                if (opname.equals("timeFormat")) {
                    try {
                        csvs.setTimeFormatPattern(DataLoaderUtil.getStringOption(opname, ent.getValue()));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new StringUtil.ParseException("The value of option " + StringUtil.jQuote(opname) + " is illegal.", e);
                    }
                }
                if (opname.equals("dateTimeFormat")) {
                    try {
                        csvs.setDateTimeFormatPattern(DataLoaderUtil.getStringOption(opname, ent.getValue()));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new StringUtil.ParseException("The value of option " + StringUtil.jQuote(opname) + " is illegal.", e);
                    }
                }
                throw new IllegalArgumentException("Unknown option: " + StringUtil.jQuote(opname) + ". The supported options are: " + "encoding, separator, headers, replaceHeaders, " + "normalizeHeaders, trimCells, emptyValue, " + "groupingSeparator, decimalSeparator, altTrue, " + "altFalse");
            }
        }
        csvs.setTimeZone(this.engine.getTimeZone());
        BufferedReader r = new BufferedReader(new InputStreamReader(data, encoding));
        ((Reader)r).mark(2);
        char firstChar = (char)((Reader)r).read();
        if (firstChar != '\ufeff') {
            ((Reader)r).reset();
        }
        csvs.load(r);
        return csvs;
    }
}

