/*
 * Decompiled with CFR 0.152.
 */
package fmpp.dataloaders;

import fmpp.Engine;
import fmpp.tdd.DataLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

public abstract class FileDataLoader
implements DataLoader {
    protected Engine engine;
    protected List args;
    protected File dataFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(Engine engine, List args) throws Exception {
        this.engine = engine;
        this.args = args;
        if (args.size() < 1) {
            throw new IllegalArgumentException("At least 1 argument (file name) needed");
        }
        Object obj = args.get(0);
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("The 1st argument (file name) must be a string.");
        }
        String path = (String)obj;
        path = path.replace('/', File.separatorChar);
        this.dataFile = new File(path);
        if (!this.dataFile.isAbsolute()) {
            this.dataFile = new File(engine.getDataRoot(), path);
        }
        try (FileInputStream in = new FileInputStream(this.dataFile);){
            Object object = this.load(in);
            return object;
        }
    }

    protected abstract Object load(InputStream var1) throws Exception;
}

