/*
 * Decompiled with CFR 0.152.
 */
package fmpp.dataloaders;

import fmpp.dataloaders.FileDataLoader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;

public class TextDataLoader
extends FileDataLoader {
    @Override
    protected Object load(InputStream data) throws Exception {
        int i;
        String encoding;
        if (this.args.size() < 1 || this.args.size() > 2) {
            throw new IllegalArgumentException("text data loader needs 1 or 2 arguments: text(filename) or text(filename, encoding)");
        }
        if (this.args.size() > 1) {
            Object obj = this.args.get(1);
            if (!(obj instanceof String)) {
                throw new IllegalArgumentException("The 2nd argument (encoding) must be a strings.");
            }
            encoding = (String)obj;
        } else {
            encoding = this.engine.getSourceEncoding();
        }
        StringWriter w = new StringWriter();
        InputStreamReader r = new InputStreamReader(data, encoding);
        char[] buffer = new char[4096];
        while ((i = r.read(buffer)) != -1) {
            w.write(buffer, 0, i);
        }
        String s = w.toString();
        if (s.startsWith("\ufeff")) {
            s = s.substring(1);
        }
        return s;
    }
}

