/*
 * Decompiled with CFR 0.152.
 */
package fmpp.localdatabuilders;

import bsh.EvalError;
import bsh.Interpreter;
import fmpp.DataModelBuildingException;
import fmpp.Engine;
import fmpp.LocalDataBuilder;
import fmpp.TemplateEnvironment;
import fmpp.setting.SettingException;
import fmpp.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;

public class BshLocalDataBuilder
implements LocalDataBuilder {
    private static final String PARAM_ENDING = "ending";
    private static final String PARAM_REMOVE_EXTENSION = "removeExtension";
    private static final String PARAM_IGNORE_MISSING = "ignoreMissing";
    private static final String PARAM_ENCODING = "encoding";
    private String ending = ".bsh";
    private boolean removeExtension;
    private boolean ignoreMissing;
    private String encoding;

    public static BshLocalDataBuilder createInstanceForSetting(String fName, List params) throws SettingException {
        BshLocalDataBuilder builder = new BshLocalDataBuilder();
        if (params.size() != 0) {
            if (params.size() != 1) {
                throw new SettingException("The number of parameters to function \"" + fName + "\" must be 1 or 0, but now there are " + params.size() + " parameters specified.");
            }
            Object o = params.get(0);
            if (!(o instanceof Map)) {
                throw new SettingException("The parameter to function \"" + fName + "\" must be a hash, but now it was a " + fmpp.tdd.Interpreter.getTypeName(o) + ".");
            }
            for (Map.Entry ent : ((Map)o).entrySet()) {
                String name = (String)ent.getKey();
                Object value = ent.getValue();
                if (name.equals(PARAM_ENDING)) {
                    if (!(value instanceof String)) {
                        throw new SettingException("In calling of function \"" + fName + "\", " + "the value of option \"" + PARAM_ENDING + "\" must be a string, but now it was a " + fmpp.tdd.Interpreter.getTypeName(value) + ".");
                    }
                    builder.setEnding((String)value);
                    continue;
                }
                if (name.equals(PARAM_REMOVE_EXTENSION)) {
                    if (!(value instanceof Boolean)) {
                        throw new SettingException("In calling of function \"" + fName + "\", " + "the value of option \"" + PARAM_REMOVE_EXTENSION + "\" must be a boolean, but now it was a " + fmpp.tdd.Interpreter.getTypeName(value) + ".");
                    }
                    builder.setRemoveExtension((Boolean)value);
                    continue;
                }
                if (name.equals(PARAM_IGNORE_MISSING)) {
                    if (!(value instanceof Boolean)) {
                        throw new SettingException("In calling of function \"" + fName + "\", " + "the value of option \"" + PARAM_IGNORE_MISSING + "\" must be a boolean, but now it was a " + fmpp.tdd.Interpreter.getTypeName(value) + ".");
                    }
                    builder.setIgnoreMissing((Boolean)value);
                    continue;
                }
                if (name.equals(PARAM_ENCODING)) {
                    if (!(value instanceof String)) {
                        throw new SettingException("In calling of function \"" + fName + "\", " + "the value of option \"" + PARAM_ENCODING + "\" must be a string, but now it was a " + fmpp.tdd.Interpreter.getTypeName(value) + ".");
                    }
                    builder.setEncoding((String)value);
                    continue;
                }
                throw new SettingException("In calling of function \"" + fName + "\", " + "option " + StringUtil.jQuote(name) + " is not supported. Supported options are: \"" + PARAM_ENDING + "\", \"" + PARAM_REMOVE_EXTENSION + "\", \"" + PARAM_IGNORE_MISSING + "\".");
            }
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map build(Engine eng, TemplateEnvironment env) throws FileNotFoundException, DataModelBuildingException {
        Object res;
        File f;
        int si;
        int di;
        String fileName = env.getSourceFile().getPath();
        if (this.removeExtension && (di = fileName.lastIndexOf(46)) != -1 && (si = fileName.lastIndexOf(File.separatorChar)) < di) {
            fileName = fileName.substring(0, di);
        }
        if (!(f = new File(fileName = fileName + this.ending)).isFile()) {
            if (this.ignoreMissing) {
                return null;
            }
            throw new FileNotFoundException("Can't find the BeansShell script file for the source file. The BeanShell file should be: " + f.getAbsolutePath());
        }
        Interpreter bship = new Interpreter();
        try {
            bship.set("engine", (Object)eng);
            bship.set("templateEnvironment", (Object)env);
        }
        catch (EvalError e) {
            throw new DataModelBuildingException("Failed to prepare BeanShell execution.", e);
        }
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(f), this.encoding == null ? eng.getSourceEncoding() : this.encoding);){
            res = bship.eval((Reader)r);
        }
        catch (IOException e) {
            throw new DataModelBuildingException("Failed to execute BeanShell script file: " + f.getAbsolutePath(), e);
        }
        catch (EvalError e) {
            throw new DataModelBuildingException("Failed to execute BeanShell script file: " + f.getAbsolutePath(), e);
        }
        if (!(res instanceof Map)) {
            throw new DataModelBuildingException("The BeanShell script file (" + f.getAbsolutePath() + ") must return a java.util.Map, " + "but it has returned " + (res != null ? "an object of class " + res.getClass().getName() + "." : "null."));
        }
        return (Map)res;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEnding() {
        return this.ending;
    }

    public void setEnding(String ending) {
        if (ending.length() == 0) {
            throw new IllegalArgumentException("Postix must not be an empty string.");
        }
        this.ending = ending;
    }

    public boolean getIgnoreMissing() {
        return this.ignoreMissing;
    }

    public void setIgnoreMissing(boolean ignoreMissing) {
        this.ignoreMissing = ignoreMissing;
    }

    public boolean getRemoveExtension() {
        return this.removeExtension;
    }

    public void setRemoveExtension(boolean removeExtension) {
        this.removeExtension = removeExtension;
    }
}

