/*
 * Decompiled with CFR 0.152.
 */
package fmpp.models;

import fmpp.models.TemplateModelUtils;
import fmpp.models.WritableHash;
import fmpp.models.WritableSequence;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class SetTransform
extends TemplateModelUtils
implements TemplateTransformModel {
    public Writer getWriter(Writer out, Map params) throws TemplateModelException, IOException {
        WritableSequence seq = null;
        WritableHash hash = null;
        int index = 0;
        String key = null;
        boolean hasIndex = false;
        TemplateModel value = null;
        for (Map.Entry e : params.entrySet()) {
            String pname = (String)e.getKey();
            Object pvalue = e.getValue();
            if ("seq".equals(pname)) {
                if (!(pvalue instanceof WritableSequence)) {
                    throw new TemplateModelException("The \"seq\" parameter must be a writable sequence variable.");
                }
                seq = (WritableSequence)pvalue;
                continue;
            }
            if ("hash".equals(pname)) {
                if (!(pvalue instanceof WritableHash)) {
                    throw new TemplateModelException("The \"hash\" parameter must be a writable hash variable.");
                }
                hash = (WritableHash)pvalue;
                continue;
            }
            if ("index".equals(pname)) {
                if (!(pvalue instanceof TemplateNumberModel)) {
                    throw new TemplateModelException("The \"index\" parameter must be a numberical value.");
                }
                index = ((TemplateNumberModel)pvalue).getAsNumber().intValue();
                hasIndex = true;
                continue;
            }
            if ("key".equals(pname)) {
                if (!(pvalue instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("The \"key\" parameter must be a string value.");
                }
                key = ((TemplateScalarModel)pvalue).getAsString();
                continue;
            }
            if ("value".equals(pname)) {
                value = (TemplateModel)pvalue;
                continue;
            }
            throw this.newUnsupportedParamException(pname);
        }
        if (seq != null) {
            if (value == null) {
                throw this.newMissingParamException("value");
            }
            if (!hasIndex) {
                throw this.newMissingParamException("index");
            }
            if (index < 0 || index >= seq.getList().size()) {
                throw new TemplateModelException("Index out of bounds.");
            }
            seq.getList().set(index, value);
        } else if (hash != null) {
            if (value == null) {
                throw this.newMissingParamException("value");
            }
            if (key == null) {
                throw this.newMissingParamException("key");
            }
            hash.getMap().put(key, value);
        } else {
            throw this.newMissingParamException("seq or hash");
        }
        return null;
    }
}

