/*
 * Decompiled with CFR 0.152.
 */
package fmpp.progresslisteners;

import fmpp.Engine;
import fmpp.ProcessingException;
import fmpp.ProgressListener;
import fmpp.util.FileUtil;
import fmpp.util.MiscUtil;
import fmpp.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;

public class LoggerProgressListener
implements ProgressListener {
    private static final String LOG_FILE_HEADER = "FMPP log file";
    private static final String LOG_FILE_HEADER_OLD = "--- BEGIN LOG FILE ---";
    private final PrintWriter out;
    private int executedCount;
    private int copiedCount;
    private int renderedCount;
    private int errorCount;
    private int warningCount;
    private long startTime;

    public LoggerProgressListener() {
        this(System.err);
    }

    public LoggerProgressListener(OutputStream out) {
        this(new PrintWriter(out, true));
    }

    public LoggerProgressListener(PrintWriter out) {
        this.out = out;
    }

    public LoggerProgressListener(File logFile) throws IOException {
        this(logFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerProgressListener(File logFile, boolean append) throws IOException {
        boolean logFileExists;
        boolean bl = logFileExists = logFile.exists() && logFile.length() != 0L;
        if (logFileExists) {
            try (FileReader r = new FileReader(logFile);){
                boolean h1 = true;
                boolean h2 = true;
                int ln1 = LOG_FILE_HEADER.length();
                int ln2 = LOG_FILE_HEADER_OLD.length();
                int i = 0;
                while (h1 || h2) {
                    int c = ((Reader)r).read();
                    if (h1) {
                        if (LOG_FILE_HEADER.charAt(i) != c) {
                            h1 = false;
                        }
                        if (i == ln1 - 1) break;
                    }
                    if (h2) {
                        if (LOG_FILE_HEADER_OLD.charAt(i) != c) {
                            h2 = false;
                        }
                        if (i == ln2 - 1) break;
                    }
                    ++i;
                }
                if (!h1 && !h2) {
                    throw new IOException("Do not want to modify the log file, because it seems not be an FMPP log file. If this is a corruped log file, please delete it manually.");
                }
            }
        }
        this.out = new PrintWriter((Writer)new FileWriter(logFile.getAbsolutePath(), append), true);
        if (!append || !logFileExists) {
            this.out.println(LOG_FILE_HEADER);
            this.println("Log file created: " + new Date());
        } else {
            this.println();
        }
        this.println();
    }

    @Override
    public void notifyProgressEvent(Engine engine, int event, File src, int pMode, Throwable error, Object param) {
        switch (event) {
            case 1: {
                String freemarkerVersion;
                String fmppVersion;
                this.startTime = System.currentTimeMillis();
                this.errorCount = 0;
                this.warningCount = 0;
                this.executedCount = 0;
                this.copiedCount = 0;
                this.println("===============================================================================");
                this.println("PROCESSING SESSION STARTED: " + new Date());
                try {
                    fmppVersion = Engine.getVersionNumber();
                }
                catch (Throwable e) {
                    fmppVersion = "??? (" + e + ")";
                }
                try {
                    freemarkerVersion = Engine.getFreeMarkerVersionNumber();
                }
                catch (Throwable e) {
                    freemarkerVersion = "??? (" + e + ")";
                }
                this.println("FMPP version: " + fmppVersion + " (using FreeMarker " + freemarkerVersion + ")");
                int startIndex = 0;
                int dotCount = 0;
                while ((startIndex = fmppVersion.indexOf(46, startIndex)) != -1) {
                    ++startIndex;
                    ++dotCount;
                }
                if (dotCount == 3) {
                    String buildInfo;
                    try {
                        buildInfo = Engine.getBuildInfo();
                    }
                    catch (Throwable e) {
                        buildInfo = "??? (" + e + ")";
                    }
                    this.println("Unreleased \"nightly\" FMPP version! Version number doesn't reflect changes,");
                    this.println("so watch the build date too: " + buildInfo);
                }
                this.println();
                break;
            }
            case 6: {
                ++this.warningCount;
                this.println("-------------------------------------------------------------------------------");
                this.println("*** WARNING: " + (String)param);
                if (src != null) {
                    try {
                        this.println("Source file: " + FileUtil.getRelativePath(engine.getSourceRoot(), src));
                    }
                    catch (IOException e) {
                        this.println("???");
                    }
                }
                this.println();
                break;
            }
            case 4: {
                this.println("===============================================================================");
                this.println("END OF PROCESSING SESSION");
                this.println();
                this.println("Summary:\n" + this.executedCount + " executed + " + this.renderedCount + " xmlRendered + " + this.copiedCount + " copied = " + (this.executedCount + this.copiedCount + this.renderedCount) + " successfully processed\n" + this.errorCount + " failed, " + this.warningCount + " warning(s)");
                this.println("Time elapsed: " + (double)(System.currentTimeMillis() - this.startTime) / 1000.0 + " seconds");
                break;
            }
            case 3: {
                if (error != null) {
                    ++this.errorCount;
                    break;
                }
                if (pMode == 2) {
                    ++this.copiedCount;
                    break;
                }
                if (pMode == 1) {
                    ++this.executedCount;
                    break;
                }
                if (pMode != 4) break;
                ++this.renderedCount;
                break;
            }
        }
        if (error != null) {
            if (event != 4) {
                this.println("-------------------------------------------------------------------------------");
                this.println("!!! ERROR");
            } else {
                this.println();
                this.println("WARNING! Processing session was interrupted:");
                this.println();
            }
            if (error instanceof ProcessingException) {
                src = ((ProcessingException)error).getSourceFile();
            }
            if (src != null) {
                this.println("> Source file:");
                try {
                    this.println(FileUtil.getRelativePath(engine.getSourceRoot(), src));
                }
                catch (IOException e) {
                    this.println("???");
                }
            }
            if (event == 3 && engine.getStopOnError()) {
                this.out.println("> Error message (see also full stack trace at session end):");
                this.out.print(MiscUtil.causeMessages(error));
            } else {
                Throwable cause;
                this.println("> Error message with stack trace:");
                if (error instanceof ProcessingException && (cause = error.getCause()) != null) {
                    error = cause;
                }
                error.printStackTrace(this.out);
            }
            this.out.flush();
            this.println();
        }
        if (event == 4) {
            this.println("===============================================================================");
        }
    }

    public PrintWriter getPrintWriter() {
        return this.out;
    }

    public void close() {
        this.out.close();
    }

    public void flush() {
        this.out.flush();
    }

    public void printlnNW(String text) {
        this.out.println(text);
    }

    public void printNW(String text) {
        this.out.print(text);
    }

    public void println() {
        this.out.println();
    }

    public void println(Object obj) {
        this.println(obj.toString());
    }

    public void println(String text) {
        this.println(text, 0);
    }

    public void println(String text, int indent) {
        this.out.println(StringUtil.wrap(text, 80, indent));
    }

    public void printStackTrace(Throwable exc) {
        this.printlnNW("--- Java stack trace: ---");
        exc.printStackTrace(this.out);
        this.println();
    }
}

