/*
 * Decompiled with CFR 0.152.
 */
package fmpp.tdd;

import fmpp.tdd.EvalException;
import fmpp.tdd.EvaluationEnvironment;
import fmpp.tdd.Fragment;
import fmpp.tdd.FunctionCall;
import fmpp.util.BugException;
import fmpp.util.FileUtil;
import fmpp.util.MiscUtil;
import fmpp.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Interpreter {
    public static final EvaluationEnvironment SIMPLE_EVALUATION_ENVIRONMENT = new EvaluationEnvironment(){

        @Override
        public Object evalFunctionCall(FunctionCall f, Interpreter ip) {
            return f;
        }

        @Override
        public Object notify(int event, Interpreter ip, String name, Object extra) {
            return null;
        }
    };
    private static final boolean[] UQSTR_CHARS = new boolean[]{true, true, true, true, true, true, true, true, true, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true, true, true, false, false, false, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false};
    private int p;
    private int ln;
    EvaluationEnvironment ee;
    private String tx;
    private String fileName;
    private boolean skipWSFoundNL;
    private static final String ENCODING_COMMENT_1 = "encoding";
    private static final String ENCODING_COMMENT_2 = "charset";

    private Interpreter() {
    }

    public static Object eval(String text, EvaluationEnvironment ee, boolean forceStringValues, String fileName) throws EvalException {
        Interpreter ip = new Interpreter();
        ip.init(text, fileName, ee);
        ip.skipWS();
        if (ip.p == ip.ln) {
            throw ip.newSyntaxError("The text is empty.");
        }
        Object res = ip.fetchExpression(forceStringValues, false);
        ip.skipWS();
        if (ip.p < ip.ln) {
            throw ip.newSyntaxError("Extra character(s) after the expression.");
        }
        return res;
    }

    public static Object eval(Fragment fragment, EvaluationEnvironment ee, boolean forceStringValues) throws EvalException {
        Interpreter ip = new Interpreter();
        ip.init(fragment, ee);
        ip.skipWS();
        if (ip.p == ip.ln) {
            throw ip.newSyntaxError("The text is empty.");
        }
        Object res = ip.fetchExpression(forceStringValues, false);
        ip.skipWS();
        if (ip.p < ip.ln) {
            throw ip.newSyntaxError("Extra character(s) after the expression.");
        }
        return res;
    }

    public static Object eval(String text, String fileName) throws EvalException {
        return Interpreter.eval(text, null, false, fileName);
    }

    public static Object eval(String text) throws EvalException {
        return Interpreter.eval(text, null, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map evalAsHash(String text, EvaluationEnvironment ee, boolean forceStringValues, String fileName) throws EvalException {
        Interpreter ip = new Interpreter();
        ip.init(text, fileName, ee);
        HashMap res = new HashMap();
        boolean done = false;
        try {
            try {
                ip.ee.notify(5, ip, null, res);
                done = true;
            }
            catch (Throwable e) {
                throw ip.newWrappedError(e);
            }
            Map map = ip.fetchHashInner(res, ' ', forceStringValues);
            return map;
        }
        finally {
            if (done) {
                try {
                    ip.ee.notify(-5, ip, null, res);
                }
                catch (Throwable e) {
                    throw ip.newWrappedError(e);
                }
            }
        }
    }

    public static Map evalAsHash(String text) throws EvalException {
        return Interpreter.evalAsHash(text, null, false, null);
    }

    public static Map evalAsHash(String text, String fileName) throws EvalException {
        return Interpreter.evalAsHash(text, null, false, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List evalAsSequence(String text, EvaluationEnvironment ee, boolean forceStringValues, String fileName) throws EvalException {
        Interpreter ip = new Interpreter();
        ip.init(text, fileName, ee);
        ArrayList res = new ArrayList();
        boolean done = false;
        try {
            try {
                ip.ee.notify(4, ip, null, res);
                done = true;
            }
            catch (Throwable e) {
                throw ip.newWrappedError(e);
            }
            List list = ip.fetchSequenceInner(res, ' ', forceStringValues);
            return list;
        }
        finally {
            if (done) {
                try {
                    ip.ee.notify(-4, ip, null, res);
                }
                catch (Throwable e) {
                    throw ip.newWrappedError(e);
                }
            }
        }
    }

    public static List evalAsSequence(String text) throws EvalException {
        return Interpreter.evalAsSequence(text, null, false, null);
    }

    public static List evalAsSequence(String text, String fileName) throws EvalException {
        return Interpreter.evalAsSequence(text, null, false, fileName);
    }

    public static String loadTdd(InputStream in, String defaultEncoding) throws IOException {
        byte[] b = FileUtil.loadByteArray(in);
        return Interpreter.loadTdd(b, defaultEncoding);
    }

    public static String loadTdd(byte[] b, String defaultEncoding) throws IOException {
        String de = Interpreter.detectEncoding(b);
        if (de != null) {
            defaultEncoding = de;
        }
        return new String(b, defaultEncoding);
    }

    public static String dump(Object value) {
        StringBuffer buf = new StringBuffer();
        Interpreter.dumpValue(buf, value, "");
        return buf.toString();
    }

    public static String getTypeName(Object value) {
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof List) {
            return "sequence";
        }
        if (value instanceof Map) {
            return "hash";
        }
        if (value instanceof FunctionCall) {
            return "function call";
        }
        if (value != null) {
            return value.getClass().getName();
        }
        return "null";
    }

    public int getPosition() {
        return this.p;
    }

    public String getText() {
        return this.tx;
    }

    public String getFileName() {
        return this.fileName;
    }

    public EvaluationEnvironment getEvaluationEnvironment() {
        return this.ee;
    }

    private List fetchSequenceInner(List list, char terminator, boolean forceStringValues) throws EvalException {
        char c;
        int listP = this.p - 1;
        this.skipWS();
        if (terminator == ' ') {
            listP = this.p;
        }
        do {
            if (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                if (c == terminator) {
                    return list;
                }
                if (c == ',') {
                    throw this.newSyntaxError("List item is missing before the comma.");
                }
            } else {
                if (terminator == ' ') {
                    return list;
                }
                throw this.newSyntaxError("Reached the end of the text, but the list was not closed with " + StringUtil.jQuoteOrName(terminator) + ".", listP);
            }
            list.add(this.fetchExpression(forceStringValues, false));
        } while ((c = this.skipSeparator(terminator, null, "This is a list, and not a hash.")) != terminator);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Map fetchHashInner(Map map, char terminator, boolean forceStringValues) throws EvalException {
        mapP = this.p - 1;
        this.skipWS();
        if (terminator == ' ') {
            mapP = this.p;
        }
        do {
            if (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                if (c == terminator) {
                    return map;
                }
                if (c == ',') {
                    throw this.newSyntaxError("Key-value pair is missing before the comma.");
                }
            } else {
                if (terminator == ' ') {
                    return map;
                }
                throw this.newSyntaxError("Reached the end of the text, but the map was not closed with " + StringUtil.jQuoteOrName(terminator) + ".", mapP);
            }
            keyP = this.p;
            o1 = this.fetchExpression(false, true);
            if (o1 instanceof FunctionCall) {
                keyFunc = (FunctionCall)o1;
                try {
                    o1 = this.ee.evalFunctionCall(keyFunc, this);
                }
                catch (Throwable e) {
                    throw this.newError("Failed to evaluate function " + StringUtil.jQuote(keyFunc.getName()) + ".", keyP, e);
                }
            } else {
                keyFunc = null;
            }
            c = this.skipSeparator(terminator, null, null);
            if (c == ':') {
                if (!(o1 instanceof String)) {
                    if (keyFunc != o1) {
                        throw this.newError("The key must be a String, but it is a(n) " + Interpreter.getTypeName(o1) + ".", keyP);
                    }
                    throw this.newError("You can't use the function here, because it can't be evaluated in this context.", keyP);
                }
                if (this.p == this.ln) {
                    throw this.newSyntaxError("The key must be followed by a value because colon was used.", keyP);
                }
                done = false;
                try {
                    try {
                        nr = this.ee.notify(1, this, (String)o1, null);
                        done = true;
                    }
                    catch (Throwable e) {
                        throw this.newWrappedError(e, keyP);
                    }
                    if (nr == null) {
                        o2 = this.fetchExpression(forceStringValues, false);
                        map.put(o1, o2);
                    } else {
                        p2 = this.p;
                        this.skipExpression(false);
                        if (nr == EvaluationEnvironment.RETURN_FRAGMENT) {
                            map.put(o1, new Fragment(this.tx, p2, this.p, this.fileName));
                        }
                    }
                }
                finally {
                    if (done) {
                        try {
                            this.ee.notify(-1, this, (String)o1, null);
                        }
                        catch (Throwable e) {
                            throw this.newWrappedError(e);
                        }
                    }
                }
                c = this.skipSeparator(terminator, null, "Colon is for separating the key from the value, and the value was alredy given previously.");
                continue;
            }
            if (c != ',' && c != terminator && c != ' ') continue;
            if (keyFunc == null) {
                if (o1 instanceof String) {
                    done = false;
                    try {
                        try {
                            nr = this.ee.notify(1, this, (String)o1, null);
                            done = true;
                        }
                        catch (Throwable e) {
                            throw this.newWrappedError(e, keyP);
                        }
                        if (nr != null && nr != EvaluationEnvironment.RETURN_FRAGMENT) ** GOTO lbl100
                        map.put(o1, Boolean.TRUE);
                    }
                    finally {
                        if (done) {
                            try {
                                this.ee.notify(-1, this, (String)o1, null);
                            }
                            catch (Throwable e) {
                                throw this.newWrappedError(e);
                            }
                        }
                    }
                }
                if (o1 instanceof Map) {
                    map.putAll((Map)o1);
                    continue;
                }
                throw this.newError("This expression should be either a string or a hash, but it is a(n) " + Interpreter.getTypeName(o1) + ".", keyP);
            }
            if (o1 instanceof Map) {
                map.putAll((Map)o1);
                continue;
            }
            if (keyFunc == o1) {
                throw this.newError("You can't use the function here, because it can't be evaluated in this context.", keyP);
            }
            throw this.newError("Function doesn't evalute to a Map, but to " + Interpreter.getTypeName(o1) + ", so it can't be merged into the hash.", keyP);
lbl100:
            // 6 sources

        } while (c != terminator);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fetchExpression(boolean forceStr, boolean hashKey) throws EvalException {
        if (this.p >= this.ln) {
            throw new BugException("Calling fetchExpression when p >= ln.");
        }
        char c = this.tx.charAt(this.p);
        if (c == '{') {
            Object res;
            ++this.p;
            HashMap map = new HashMap();
            boolean done = false;
            try {
                Object nr;
                try {
                    nr = this.ee.notify(5, this, null, map);
                    done = true;
                }
                catch (Throwable e) {
                    throw this.newWrappedError(e);
                }
                if (nr == null) {
                    this.fetchHashInner(map, '}', forceStr);
                    res = map;
                } else {
                    --this.p;
                    int p2 = this.p;
                    this.skipExpression(false);
                    res = new Fragment(this.tx, p2, this.p, this.fileName);
                    --this.p;
                }
            }
            finally {
                if (done) {
                    try {
                        this.ee.notify(-5, this, null, map);
                    }
                    catch (Throwable e) {
                        throw this.newWrappedError(e);
                    }
                }
            }
            ++this.p;
            return res;
        }
        if (c == '[') {
            ++this.p;
            ArrayList res = new ArrayList();
            boolean done = false;
            try {
                try {
                    this.ee.notify(4, this, null, res);
                    done = true;
                }
                catch (Throwable e) {
                    throw this.newWrappedError(e);
                }
                this.fetchSequenceInner(res, ']', forceStr);
            }
            finally {
                if (done) {
                    try {
                        this.ee.notify(-4, this, null, res);
                    }
                    catch (Throwable e) {
                        throw this.newWrappedError(e);
                    }
                }
            }
            ++this.p;
            return res;
        }
        int b = this.p;
        if (c == '\"' || c == '\'') {
            char q = c;
            ++this.p;
            while (this.p < this.ln && (c = this.tx.charAt(this.p)) != '\\') {
                ++this.p;
                if (c != q) continue;
                return this.tx.substring(b + 1, this.p - 1);
            }
            if (this.p == this.ln) {
                throw this.newSyntaxError("The closing " + StringUtil.jQuoteOrName(q) + " of the string is missing.", b);
            }
            int bidx = b + 1;
            StringBuffer buf = new StringBuffer();
            block49: while (true) {
                buf.append(this.tx.substring(bidx, this.p));
                if (this.p == this.ln - 1) {
                    throw this.newSyntaxError("The closing " + StringUtil.jQuoteOrName(q) + " of the string is missing.", b);
                }
                c = this.tx.charAt(this.p + 1);
                switch (c) {
                    case '\"': {
                        buf.append('\"');
                        bidx = this.p + 2;
                        break;
                    }
                    case '\'': {
                        buf.append('\'');
                        bidx = this.p + 2;
                        break;
                    }
                    case '\\': {
                        buf.append('\\');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        bidx = this.p + 2;
                        break;
                    }
                    case 't': {
                        buf.append('\t');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'f': {
                        buf.append('\f');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'b': {
                        buf.append('\b');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'g': {
                        buf.append('>');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'l': {
                        buf.append('<');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'a': {
                        buf.append('&');
                        bidx = this.p + 2;
                        break;
                    }
                    case '{': {
                        buf.append('{');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'u': 
                    case 'x': {
                        int z;
                        this.p += 2;
                        int x = this.p;
                        int y = 0;
                        int n = z = this.ln - this.p > 4 ? this.p + 4 : this.ln;
                        while (this.p < z) {
                            char c2 = this.tx.charAt(this.p);
                            if (c2 >= '0' && c2 <= '9') {
                                y <<= 4;
                                y += c2 - 48;
                            } else if (c2 >= 'a' && c2 <= 'f') {
                                y <<= 4;
                                y += c2 - 97 + 10;
                            } else {
                                if (c2 < 'A' || c2 > 'F') break;
                                y <<= 4;
                                y += c2 - 65 + 10;
                            }
                            ++this.p;
                        }
                        if (x >= this.p) {
                            throw this.newSyntaxError("Invalid hexadecimal UNICODE escape in the string literal.", x - 2);
                        }
                        buf.append((char)y);
                        bidx = this.p;
                        break;
                    }
                    default: {
                        if (Interpreter.isWS(c)) {
                            boolean hasWS = false;
                            bidx = this.p + 1;
                            do {
                                if (c != '\n' && c != '\r') continue;
                                if (hasWS) break;
                                hasWS = true;
                                if (c != '\r' || bidx >= this.ln - 1 || this.tx.charAt(bidx + 1) != '\n') continue;
                                ++bidx;
                            } while (++bidx != this.ln && Interpreter.isWS(c = this.tx.charAt(bidx)));
                            if (hasWS) break;
                            throw this.newSyntaxError("Invalid usage of escape sequence \\white-space. This escape sequence can be used only before line-break.");
                        }
                        throw this.newSyntaxError("Invalid escape sequence \\" + c + " in the string literal.");
                    }
                }
                this.p = bidx;
                while (true) {
                    if (this.p == this.ln) {
                        throw this.newSyntaxError("The closing " + StringUtil.jQuoteOrName(q) + " of the string is missing.", b);
                    }
                    c = this.tx.charAt(this.p);
                    if (c == '\\') continue block49;
                    if (c == q) {
                        buf.append(this.tx.substring(bidx, this.p));
                        ++this.p;
                        return buf.toString();
                    }
                    ++this.p;
                }
                break;
            }
        }
        char c2 = this.p < this.ln - 1 ? (char)this.tx.charAt(this.p + 1) : (char)' ';
        if (c == 'r' && (c2 == '\"' || c2 == '\'')) {
            char q = c2;
            this.p += 2;
            while (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                ++this.p;
                if (c != q) continue;
                return this.tx.substring(b + 2, this.p - 1);
            }
            throw this.newSyntaxError("The closing " + StringUtil.jQuoteOrName(q) + " of the string is missing.", b);
        }
        while (!((c = this.tx.charAt(this.p)) <= '\u00a0' ? !(UQSTR_CHARS[c] || this.p == b && c == '+' || !hashKey && c == ':') : Interpreter.isWS(c))) {
            ++this.p;
            if (this.p != this.ln) continue;
        }
        if (b == this.p) {
            throw this.newSyntaxError("Unexpected character.", b);
        }
        String s = this.tx.substring(b, this.p);
        int funcP = b;
        int oldP = this.p++;
        c = this.skipWS();
        if (c == '(') {
            List params;
            boolean done = false;
            try {
                try {
                    this.ee.notify(3, this, s, null);
                }
                catch (Throwable e) {
                    throw this.newWrappedError(e, funcP);
                }
                done = true;
                params = this.fetchSequenceInner(new ArrayList(), ')', forceStr);
            }
            finally {
                if (done) {
                    try {
                        this.ee.notify(-3, this, s, null);
                    }
                    catch (Throwable e) {
                        throw this.newWrappedError(e);
                    }
                }
            }
            ++this.p;
            FunctionCall func = new FunctionCall(s, params);
            if (!hashKey) {
                try {
                    return this.ee.evalFunctionCall(func, this);
                }
                catch (Throwable e) {
                    throw this.newError("Failed to evaluate function " + StringUtil.jQuote(func.getName()) + ".", b, e);
                }
            }
            return func;
        }
        this.p = oldP;
        if (!forceStr && !hashKey) {
            if (s.equals("true")) {
                return Boolean.TRUE;
            }
            if (s.equals("false")) {
                return Boolean.FALSE;
            }
            c = s.charAt(0);
            if (c >= '0' && c <= '9' || c == '+' || c == '-') {
                String s2 = c == '+' ? s.substring(1) : s;
                try {
                    return new Integer(s2);
                }
                catch (NumberFormatException exc) {
                    try {
                        return new BigDecimal(s2);
                    }
                    catch (NumberFormatException exc2) {
                        // empty catch block
                    }
                }
            }
        }
        return s;
    }

    private void skipExpression(boolean hashKey) throws EvalException {
        if (this.p >= this.ln) {
            throw new BugException("Calling fetchExpression when p >= ln.");
        }
        char c = this.tx.charAt(this.p);
        if (c == '{') {
            ++this.p;
            this.skipListing('}');
            ++this.p;
            return;
        }
        if (c == '[') {
            ++this.p;
            this.skipListing(']');
            ++this.p;
            return;
        }
        if (c == '<') {
            ++this.p;
            this.skipListing('>');
            ++this.p;
            return;
        }
        if (c == '(') {
            ++this.p;
            this.skipListing(')');
            ++this.p;
            return;
        }
        int b = this.p;
        if (c == '\"' || c == '\'') {
            char q = c;
            ++this.p;
            while (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                if (c == '\\' && this.p != this.ln - 1) {
                    ++this.p;
                }
                ++this.p;
                if (c != q) continue;
                return;
            }
            throw this.newSyntaxError("The closing " + StringUtil.jQuoteOrName(q) + " of the string is missing.", b);
        }
        char c2 = this.p < this.ln - 1 ? (char)this.tx.charAt(this.p + 1) : (char)' ';
        if (c == 'r' && (c2 == '\"' || c2 == '\'')) {
            char q = c2;
            this.p += 2;
            while (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                ++this.p;
                if (c != q) continue;
                return;
            }
            throw this.newSyntaxError("The closing " + StringUtil.jQuoteOrName(q) + " of the string is missing.", b);
        }
        while (!((c = this.tx.charAt(this.p)) <= '\u00a0' ? !(UQSTR_CHARS[c] || this.p == b && c == '+' || !hashKey && c == ':') : Interpreter.isWS(c))) {
            ++this.p;
            if (this.p != this.ln) continue;
        }
        if (b == this.p) {
            throw this.newSyntaxError("Unexpected character.", b);
        }
        int oldP = this.p++;
        c = this.skipWS();
        if (c == '(') {
            this.skipListing(')');
            ++this.p;
        } else {
            this.p = oldP;
        }
    }

    private void skipListing(char terminator) throws EvalException {
        char c;
        int listP = this.p - 1;
        this.skipWS();
        if (terminator == ' ') {
            listP = this.p;
        }
        do {
            if (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                if (c == terminator) {
                    return;
                }
            } else {
                if (terminator == ' ') {
                    return;
                }
                throw this.newSyntaxError("Reached the end of the text, but the closing " + StringUtil.jQuoteOrName(terminator) + " is missing.", listP);
            }
            if (c == ',' || c == ':' || c == ';' || c == '=') {
                ++this.p;
                continue;
            }
            this.skipExpression(false);
        } while ((c = this.skipWS()) != terminator);
    }

    private char skipSeparator(char terminator, String commaBadReason, String colonBadReason) throws EvalException {
        int intialP = this.p;
        char c = this.skipWS();
        boolean plusConverted = false;
        if (c == '+') {
            throw this.newSyntaxError("The + operator (\"hash union\") is deprecated since FMPP 0.9.0, and starting from FMPP 0.9.9 it is not allowed at all. Please use \"hash addition\" instead. For example, assuming that your configuration file is in .properties format (same as .cfg), instead of this:\ndata={a:1, b:2} + properties(data/style.properties) + birds:csv(data/birds.csv)\nyour should write this:\ndata=a:1, b:2, tdd(data/style.tdd), birds:csv(data/birds.csv)\nFor more information on hash addition please see:\nhttp://fmpp.sourceforge.net/tdd.html#hashAddition");
        }
        if (c == ',' || c == ':') {
            if (commaBadReason != null && c == ',') {
                if (!plusConverted) {
                    throw this.newSyntaxError("Comma (,) shouldn't be used here. " + commaBadReason);
                }
                throw this.newSyntaxError("Plus sign (+), which is treated as comma (,) in this case, shouldn't be used here. " + commaBadReason);
            }
            if (colonBadReason != null && c == ':') {
                throw this.newSyntaxError("Colon (:) shouldn't be used here. " + colonBadReason);
            }
            ++this.p;
            this.skipWS();
            return c;
        }
        if (c == terminator) {
            return terminator;
        }
        if (c == ';') {
            throw this.newSyntaxError("Semicolon (;) was unexpected here. If you want to separate items in a listing then use comma (,) instead.");
        }
        if (c == '=') {
            throw this.newSyntaxError("Equals sign (=) was unexpected here. If you want to associate a key with a value then use colon (:) instead.");
        }
        if (c == ' ') {
            return c;
        }
        if (this.skipWSFoundNL) {
            if (commaBadReason != null) {
                throw this.newSyntaxError("Line-break shouldn't be used before this iteam as separator (which is the same as using comma). " + commaBadReason);
            }
            return ',';
        }
        if (this.p == intialP) {
            throw this.newSyntaxError("Character " + StringUtil.jQuoteOrName(this.tx.charAt(this.p)) + " shouldn't occur here.");
        }
        throw this.newSyntaxError("No separator was used before the item. Items in listings should be separated with comma (,) or line-break. Keys and values in hashes should be separated with colon (:).");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private char skipWS() throws EvalException {
        this.skipWSFoundNL = false;
        while (this.p < this.ln) {
            char c = this.tx.charAt(this.p);
            if (!Interpreter.isWS(c)) {
                if (c == '#' && this.isLineEmptyBefore(this.p)) {
                    do {
                        ++this.p;
                        if (this.p != this.ln) continue;
                        return ' ';
                    } while ((c = this.tx.charAt(this.p)) != '\n' && c != '\r');
                } else {
                    if (c != '<' || this.p >= this.ln - 3 || this.tx.charAt(this.p + 1) != '#' || this.tx.charAt(this.p + 2) != '-' || this.tx.charAt(this.p + 3) != '-') return c;
                    int commentP = this.p;
                    do {
                        ++this.p;
                        if (this.p < this.ln - 2) continue;
                        throw this.newSyntaxError("Comment was not closed with \"-->\".", commentP);
                    } while (this.tx.charAt(this.p) != '-' || this.tx.charAt(this.p + 1) != '-' || this.tx.charAt(this.p + 2) != '>');
                    this.p += 2;
                }
            } else if (c == '\r' || c == '\n') {
                this.skipWSFoundNL = true;
            }
            ++this.p;
        }
        return ' ';
    }

    private boolean isLineEmptyBefore(int pos) {
        --pos;
        while (pos >= 0) {
            char c = this.tx.charAt(pos);
            if (c == '\n' || c == '\r') {
                return true;
            }
            if (!Interpreter.isWS(c)) {
                return false;
            }
            --pos;
        }
        return true;
    }

    private void init(String text, String fileName, EvaluationEnvironment ee) {
        this.p = 0;
        this.skipWSFoundNL = false;
        this.tx = text;
        this.ln = text.length();
        this.fileName = fileName;
        this.ee = ee == null ? SIMPLE_EVALUATION_ENVIRONMENT : ee;
    }

    private void init(Fragment fr, EvaluationEnvironment ee) {
        this.p = fr.getFragmentStart();
        this.skipWSFoundNL = false;
        this.tx = fr.getText();
        this.ln = fr.getFragmentEnd();
        this.fileName = fr.getFileName();
        this.ee = ee == null ? SIMPLE_EVALUATION_ENVIRONMENT : ee;
    }

    private static boolean isWS(char c) {
        return Character.isWhitespace(c) || c == '\ufeff';
    }

    private static String detectEncoding(byte[] b) {
        String s;
        int p;
        int ln = b.length;
        for (p = 0; p < ln && Character.isWhitespace(Interpreter.toChar(b[p])); ++p) {
        }
        if (p == ln) {
            return null;
        }
        char c = Interpreter.toChar(b[p]);
        if (c != '#') {
            if (p > ln - 3 || c != '\u00ef' || Interpreter.toChar(b[p + 1]) != '\u00bb' || Interpreter.toChar(b[p + 2]) != '\u00bf' || Interpreter.toChar(b[p + 3]) != '#') {
                return null;
            }
            p += 3;
        }
        ++p;
        int bp = p = Interpreter.detectEncoding_skipNonNLWS(b, p);
        while (p < ln && ((c = Interpreter.toChar(b[p])) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            ++p;
        }
        if (p - bp != ENCODING_COMMENT_1.length() && p - bp != ENCODING_COMMENT_2.length()) {
            return null;
        }
        try {
            s = new String(b, bp, p - bp, "ISO-8859-1").toLowerCase();
        }
        catch (UnsupportedEncodingException e) {
            throw new BugException("ISO-8859-1 decoding failed.", e);
        }
        if (!s.equals(ENCODING_COMMENT_1) && !s.equals(ENCODING_COMMENT_2)) {
            return null;
        }
        if ((p = Interpreter.detectEncoding_skipNonNLWS(b, p)) == ln) {
            return null;
        }
        c = Interpreter.toChar(b[p]);
        if (c != ':') {
            return null;
        }
        ++p;
        if ((p = Interpreter.detectEncoding_skipNonNLWS(b, p)) == ln) {
            return null;
        }
        bp = p;
        while (p < ln && !Character.isWhitespace(Interpreter.toChar(b[p]))) {
            ++p;
        }
        if (bp == p) {
            return null;
        }
        try {
            s = new String(b, bp, p - bp, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new BugException("ISO-8859-1 decoding failed.", e);
        }
        return s;
    }

    private static int detectEncoding_skipNonNLWS(byte[] b, int p) {
        char c;
        int ln = b.length;
        while (p < ln && Character.isWhitespace(c = Interpreter.toChar(b[p])) && c != '\r' && c != '\n') {
            ++p;
        }
        return p;
    }

    private static char toChar(byte b) {
        return (char)(0xFF & b);
    }

    private static void dumpMap(StringBuffer out, Map m, String indent) {
        for (Map.Entry ent : m.entrySet()) {
            out.append(indent + StringUtil.jQuote((String)ent.getKey()) + ": ");
            Interpreter.dumpValue(out, ent.getValue(), indent);
            out.append(StringUtil.LINE_BREAK);
        }
    }

    private static void dumpMapSL(StringBuffer out, Map m) {
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            out.append(StringUtil.jQuote((String)ent.getKey()) + ":");
            Interpreter.dumpValueSL(out, ent.getValue());
            if (!it.hasNext()) continue;
            out.append(", ");
        }
    }

    private static void dumpList(StringBuffer out, List ls, String indent) {
        for (Object obj : ls) {
            out.append(indent);
            Interpreter.dumpValue(out, obj, indent);
            out.append(StringUtil.LINE_BREAK);
        }
    }

    private static void dumpListSL(StringBuffer out, List ls) {
        Iterator it = ls.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Interpreter.dumpValueSL(out, obj);
            if (!it.hasNext()) continue;
            out.append(", ");
        }
    }

    private static void dumpValue(StringBuffer out, Object o, String indent) {
        if (o instanceof Number || o instanceof Boolean) {
            out.append(o);
        } else if (o instanceof String) {
            out.append(StringUtil.jQuote((String)o));
        } else if (o instanceof Map) {
            out.append("{");
            out.append(StringUtil.LINE_BREAK);
            Interpreter.dumpMap(out, (Map)o, indent + "    ");
            out.append(indent + "}");
        } else if (o instanceof List) {
            out.append("[");
            out.append(StringUtil.LINE_BREAK);
            Interpreter.dumpList(out, (List)o, indent + "    ");
            out.append(indent + "]");
        } else if (o instanceof FunctionCall) {
            FunctionCall dir = (FunctionCall)o;
            out.append(dir.getName());
            out.append("(");
            Interpreter.dumpListSL(out, dir.getParams());
            out.append(")");
        } else if (o == null) {
            out.append("<null>");
        } else {
            out.append("<");
            out.append(o.getClass().getName());
            out.append(" ");
            out.append(StringUtil.jQuote(o.toString()));
            out.append(">");
        }
    }

    private static void dumpValueSL(StringBuffer out, Object o) {
        if (o instanceof Number || o instanceof Boolean) {
            out.append(o);
        } else if (o instanceof String) {
            out.append(StringUtil.jQuote((String)o));
        } else if (o instanceof Map) {
            out.append("{");
            Interpreter.dumpMapSL(out, (Map)o);
            out.append("}");
        } else if (o instanceof List) {
            out.append("[");
            Interpreter.dumpListSL(out, (List)o);
            out.append("]");
        } else if (o instanceof FunctionCall) {
            FunctionCall dir = (FunctionCall)o;
            out.append(dir.getName());
            out.append("(");
            Interpreter.dumpListSL(out, dir.getParams());
            out.append(")");
        } else {
            out.append("<");
            out.append(o.getClass().getName());
            out.append(" ");
            out.append(StringUtil.jQuote(o.toString()));
            out.append(">");
        }
    }

    private EvalException newSyntaxError(String message) {
        return this.newSyntaxError(message, this.p);
    }

    private EvalException newSyntaxError(String message, int position) {
        return new EvalException("TDD syntax error: " + message, this.tx, position, this.fileName);
    }

    private EvalException newError(String message, int position) {
        return new EvalException("TDD error: " + message, this.tx, position, this.fileName);
    }

    private EvalException newError(String message, int position, Throwable cause) {
        return new EvalException("TDD error: " + message, this.tx, position, this.fileName, cause);
    }

    private EvalException newWrappedError(Throwable e) {
        return this.newWrappedError(e, this.p);
    }

    private EvalException newWrappedError(Throwable e, int p) {
        if (e instanceof EvalException) {
            return (EvalException)e;
        }
        return new EvalException("Error while evaluating TDD: " + e.getMessage(), this.tx, p, this.fileName, MiscUtil.getCauseException(e));
    }
}

