/*
 * Decompiled with CFR 0.152.
 */
package fmpp.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class FileUtil {
    public static String getRelativePath(File fromDir, File toFileOrDir) throws IOException {
        File tof;
        File fromf;
        boolean otoEndsWithSep;
        boolean needSepEndForDirs;
        char sep = File.separatorChar;
        String ofrom = fromDir.getCanonicalPath();
        String oto = toFileOrDir.getCanonicalPath();
        if (!ofrom.endsWith(File.separator)) {
            ofrom = ofrom + sep;
            needSepEndForDirs = false;
        } else {
            needSepEndForDirs = true;
        }
        if (!oto.endsWith(File.separator)) {
            oto = oto + sep;
            otoEndsWithSep = false;
        } else {
            otoEndsWithSep = true;
        }
        String from = ofrom.toLowerCase();
        String to = oto.toLowerCase();
        StringBuffer path = new StringBuffer(oto.length());
        int fromln = from.length();
        while (!to.regionMatches(0, from, 0, fromln) || !(fromf = new File(ofrom.substring(0, needSepEndForDirs ? fromln : fromln - 1))).equals(tof = new File(oto.substring(0, needSepEndForDirs ? fromln : fromln - 1)))) {
            path.append(".." + sep);
            --fromln;
            while (fromln > 0 && from.charAt(fromln - 1) != sep) {
                --fromln;
            }
            if (fromln != 0) continue;
            throw new IOException("Could not find common parent directory in these paths: " + ofrom + " and " + oto);
        }
        path.append(oto.substring(fromln));
        if (!otoEndsWithSep && path.length() != 0) {
            path.setLength(path.length() - 1);
        }
        return path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst, boolean copyLMD) throws IOException {
        byte[] buffer = new byte[65536];
        try (FileInputStream in = new FileInputStream(src);){
            long srcLMD = 0L;
            if (copyLMD && (srcLMD = src.lastModified()) == 0L) {
                throw new IOException("Failed to get the last modification time of " + src.getAbsolutePath());
            }
            try (FileOutputStream out = new FileOutputStream(dst);){
                int ln;
                while ((ln = ((InputStream)in).read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, ln);
                }
            }
            if (srcLMD != 0L) {
                dst.setLastModified(srcLMD);
            }
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        FileUtil.copyFile(src, dst, true);
    }

    public static boolean isInsideOrEquals(File file, File ascendant) {
        while (!file.equals(ascendant)) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return true;
    }

    public static boolean isInside(File file, File ascendant) {
        if (!file.equals(ascendant)) {
            return false;
        }
        do {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        } while (!file.equals(ascendant));
        return true;
    }

    public static File resolveRelativeUnixPath(File root, File wd, String path) throws IOException {
        File c;
        int i;
        if (path.startsWith("/")) {
            i = 1;
            c = root.getAbsoluteFile();
        } else {
            i = 0;
            c = wd.getAbsoluteFile();
        }
        int ln = path.length();
        while (i < ln) {
            int si = path.indexOf(i, 47);
            if (si == -1) {
                si = ln;
            }
            String step = path.substring(i, si);
            i = si + 1;
            if (step.equals(".")) continue;
            if (step.equals("..")) {
                if ((c = c.getParentFile()) != null) continue;
                throw new IOException("Parent directory not found.");
            }
            c = new File(c, step);
        }
        if (!FileUtil.isInsideOrEquals(c = c.getCanonicalFile(), root)) {
            throw new IOException("Attempt to leave the root directory.");
        }
        return c;
    }

    public static String compressPath(String path, int maxPathLength) {
        if (path.length() > maxPathLength) {
            int r = path.length() - maxPathLength + 3;
            int i = path.lastIndexOf(File.separatorChar);
            if (i == -1) {
                i = path.lastIndexOf(47);
            }
            if (i <= r) {
                return "..." + path.substring(r);
            }
            return path.substring(0, i - r) + "..." + path.substring(i);
        }
        return path;
    }

    public static String pathToUnixStyle(String path) {
        path = path.replace(File.separatorChar, '/');
        if (File.separatorChar != '\\') {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static String removeSlashPrefix(String path) {
        if (path.startsWith("/") && !path.startsWith("//")) {
            return path.substring(1);
        }
        return path;
    }

    public static String pathPatternToPerl5Regex(String text) {
        StringBuffer sb = new StringBuffer();
        if (!text.startsWith("/")) {
            text = "/" + text;
        }
        if (text.endsWith("/")) {
            text = text + "**";
        }
        char[] chars = text.toCharArray();
        int ln = chars.length;
        for (int i = 0; i < ln; ++i) {
            char c = chars[i];
            if (c == '\\' || c == '^' || c == '.' || c == '$' || c == '|' || c == '(' || c == ')' || c == '[' || c == ']' || c == '+' || c == '{' || c == '}' || c == '@') {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (i == 0 && ln > 2 && chars[0] == '*' && chars[1] == '*' && chars[2] == '/') {
                sb.append(".*/");
                i += 2;
                continue;
            }
            if (c == '/' && i + 2 < ln && chars[i + 1] == '*' && chars[i + 2] == '*') {
                if (i + 3 == ln) {
                    sb.append("/.*");
                } else {
                    sb.append("(/.*)?");
                }
                i += 2;
                continue;
            }
            if (c == '*') {
                sb.append("[^/]*");
                continue;
            }
            if (c == '?') {
                sb.append("[^/]");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(InputStream in, String charset) throws IOException {
        StringBuffer sb = new StringBuffer(1024);
        try (InputStreamReader r = charset != null ? new InputStreamReader(in, charset) : new InputStreamReader(in);){
            int ln;
            char[] buf = new char[4096];
            while ((ln = r.read(buf)) != -1) {
                sb.append(buf, 0, ln);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadByteArray(InputStream in) throws IOException {
        int size = 0;
        int bcap = 1024;
        byte[] b = new byte[bcap];
        try {
            int rdn;
            while ((rdn = in.read(b, size, bcap - size)) != -1) {
                if (bcap != (size += rdn)) continue;
                byte[] newB = new byte[bcap *= 2];
                System.arraycopy(b, 0, newB, 0, size);
                b = newB;
            }
        }
        finally {
            in.close();
        }
        if (b.length != size) {
            byte[] newB = new byte[size];
            System.arraycopy(b, 0, newB, 0, size);
            return newB;
        }
        return b;
    }
}

