/*
 * Decompiled with CFR 0.152.
 */
package fmpp.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public class RuntimeExceptionCC
extends RuntimeException {
    private Throwable cause;
    private static final boolean BEFORE_1_4 = RuntimeExceptionCC.before14();

    private static boolean before14() {
        Class<Exception> ec = Exception.class;
        try {
            ec.getMethod("getCause", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        return false;
    }

    public RuntimeExceptionCC() {
    }

    public RuntimeExceptionCC(String s) {
        super(s);
    }

    public RuntimeExceptionCC(Throwable cause) {
        this.cause = cause;
    }

    public RuntimeExceptionCC(String s, Throwable cause) {
        super(s);
        this.cause = cause;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (BEFORE_1_4 && this.cause != null) {
            System.err.print("Caused by: ");
            this.cause.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (BEFORE_1_4 && this.cause != null) {
            s.print("Caused by: ");
            this.cause.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (BEFORE_1_4 && this.cause != null) {
            s.print("Caused by: ");
            this.cause.printStackTrace(s);
        }
    }
}

