/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.internal.Iterators;
import com.google.inject.servlet.ServletScopes;
import com.google.inject.servlet.UriPatternMatcher;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServletDefinition {
    private final String pattern;
    private final Key<? extends HttpServlet> servletKey;
    private final UriPatternMatcher patternMatcher;
    private final Map<String, String> initParams;
    private final AtomicReference<HttpServlet> httpServlet = new AtomicReference();

    public ServletDefinition(String pattern, Key<? extends HttpServlet> servletKey, UriPatternMatcher patternMatcher, Map<String, String> initParams) {
        this.pattern = pattern;
        this.servletKey = servletKey;
        this.patternMatcher = patternMatcher;
        this.initParams = Collections.unmodifiableMap(new HashMap<String, String>(initParams));
    }

    boolean shouldServe(String uri) {
        return this.patternMatcher.matches(uri);
    }

    public void init(final ServletContext servletContext, Injector injector, Set<HttpServlet> initializedSoFar) throws ServletException {
        if (!ServletScopes.isSingletonBinding(injector.getBinding(this.servletKey))) {
            throw new ServletException("Servlets must be bound as singletons. " + this.servletKey + " was not bound in singleton scope.");
        }
        HttpServlet httpServlet = injector.getInstance(this.servletKey);
        this.httpServlet.set(httpServlet);
        if (initializedSoFar.contains(httpServlet)) {
            return;
        }
        httpServlet.init(new ServletConfig(){

            public String getServletName() {
                return ServletDefinition.this.servletKey.toString();
            }

            public ServletContext getServletContext() {
                return servletContext;
            }

            public String getInitParameter(String s) {
                return (String)ServletDefinition.this.initParams.get(s);
            }

            public Enumeration getInitParameterNames() {
                return Iterators.asEnumeration(ServletDefinition.this.initParams.keySet().iterator());
            }
        });
        initializedSoFar.add(httpServlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Set<HttpServlet> destroyedSoFar) {
        HttpServlet reference = this.httpServlet.get();
        if (null == reference || destroyedSoFar.contains(reference)) {
            return;
        }
        try {
            reference.destroy();
        }
        finally {
            destroyedSoFar.add(reference);
        }
    }

    public boolean service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        boolean serve = this.shouldServe(((HttpServletRequest)servletRequest).getServletPath());
        if (serve) {
            this.doService(servletRequest, servletResponse);
        }
        return serve;
    }

    void doService(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequestWrapper request = new HttpServletRequestWrapper((HttpServletRequest)servletRequest){
            private String path;
            private boolean pathComputed;
            private boolean pathInfoComputed;
            private String pathInfo;
            {
                this.pathComputed = false;
                this.pathInfoComputed = false;
            }

            public String getPathInfo() {
                if (!this.pathInfoComputed) {
                    int servletPathLength = this.getServletPath().length();
                    this.pathInfo = this.getRequestURI().substring(this.getContextPath().length()).replaceAll("[/]{2,}", "/").substring(servletPathLength);
                    if ("".equals(this.pathInfo) && servletPathLength != 0) {
                        this.pathInfo = null;
                    }
                    this.pathInfoComputed = true;
                }
                return this.pathInfo;
            }

            public String getServletPath() {
                return this.computePath();
            }

            public String getPathTranslated() {
                String info = this.getPathInfo();
                return null == info ? null : this.getRealPath(info);
            }

            private String computePath() {
                if (!this.pathComputed) {
                    String servletPath = super.getServletPath();
                    this.path = ServletDefinition.this.patternMatcher.extractPath(servletPath);
                    this.pathComputed = true;
                    if (null == this.path) {
                        this.path = servletPath;
                    }
                }
                return this.path;
            }
        };
        this.httpServlet.get().service((ServletRequest)request, servletResponse);
    }

    String getKey() {
        return this.servletKey.toString();
    }

    String getPattern() {
        return this.pattern;
    }
}

