/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.requesthandlers;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.jstestdriver.requesthandlers.GatewayConfiguration;
import com.google.jstestdriver.requesthandlers.HttpMethod;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.requesthandlers.RequestMatcher;
import com.google.jstestdriver.requesthandlers.UnsupportedMethodErrorSender;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(RequestDispatcher.class);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final List<RequestMatcher> matchers;
    private final Map<RequestMatcher, Provider<RequestHandler>> handlerProviders;
    private GatewayConfiguration gatewayConfiguration;
    private final UnsupportedMethodErrorSender errorSender;

    @Inject
    public RequestDispatcher(HttpServletRequest request, HttpServletResponse response, List<RequestMatcher> matchers, Map<RequestMatcher, Provider<RequestHandler>> handlerProviders, GatewayConfiguration gatewayConfiguration, UnsupportedMethodErrorSender errorSender) {
        this.request = request;
        this.response = response;
        this.matchers = matchers;
        this.handlerProviders = handlerProviders;
        this.gatewayConfiguration = gatewayConfiguration;
        this.errorSender = errorSender;
    }

    public void dispatch() throws IOException {
        try {
            HttpMethod method = HttpMethod.valueOf(this.request.getMethod());
            String uri = this.request.getRequestURI();
            boolean pathMatched = false;
            for (RequestMatcher matcher : this.matchers) {
                if (!matcher.uriMatches(uri)) continue;
                pathMatched = true;
                if (!matcher.methodMatches(method)) continue;
                logger.trace("handling {} {}", (Object)uri, (Object)this.request);
                this.handlerProviders.get(matcher).get().handleIt();
                return;
            }
            for (RequestMatcher matcher : this.gatewayConfiguration.getMatchers()) {
                if (!matcher.uriMatches(uri)) continue;
                pathMatched = true;
                if (!matcher.methodMatches(method)) continue;
                logger.trace("gatewaying {} {}", (Object)uri, (Object)this.request);
                this.gatewayConfiguration.getRequestHandler(matcher).handleIt();
                return;
            }
            if (pathMatched) {
                this.errorSender.methodNotAllowed();
            } else {
                this.response.sendError(404, "Not found.");
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("Error in request {}", e);
            this.errorSender.methodNotAllowed();
        }
        catch (Exception e) {
            logger.error("Error in request {}", e);
        }
    }
}

