/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.jstestdriver.BrowserPanic;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.browser.BrowserPanicException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BrowserPanicResponseStream
implements ResponseStream {
    private static final Logger logger = LoggerFactory.getLogger(BrowserPanicResponseStream.class);
    private final Gson gson = new Gson();

    BrowserPanicResponseStream() {
    }

    public void stream(Response response) {
        if (response.getResponseType() == Response.ResponseType.BROWSER_PANIC) {
            try {
                BrowserPanic panic = (BrowserPanic)this.gson.fromJson(response.getResponse(), response.getResponseType().type);
                BrowserPanicException exception = new BrowserPanicException(panic.getBrowserInfo(), "");
                logger.error("Browser not found : {}\n Exception: {}", new Object[]{response.getResponse(), exception});
                throw exception;
            }
            catch (JsonSyntaxException e) {
                throw new RuntimeException(String.format("Failed to deserialize |%s|", response.getResponse()), e);
            }
        }
    }

    public void finish() {
    }
}

