/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.browser.BrowserCaptureEvent;
import com.google.jstestdriver.browser.BrowserIdStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CapturedBrowsers
extends Observable {
    private static final Logger logger = LoggerFactory.getLogger(CapturedBrowsers.class);
    private final Map<String, SlaveBrowser> slaves = new ConcurrentHashMap<String, SlaveBrowser>();
    private final BrowserIdStrategy idStrategy;

    @Inject
    public CapturedBrowsers(BrowserIdStrategy idStrategy) {
        this.idStrategy = idStrategy;
    }

    public SlaveBrowser getBrowser(String id) {
        return this.slaves.get(id);
    }

    public String getUniqueId() {
        return Long.toString(this.idStrategy.nextId());
    }

    public void addSlave(SlaveBrowser slave) {
        this.slaves.put(slave.getId(), slave);
        this.setChanged();
        this.notifyObservers(new BrowserCaptureEvent(BrowserCaptureEvent.Event.CONNECTED, slave));
    }

    public Collection<SlaveBrowser> getSlaveBrowsers() {
        return this.slaves.values();
    }

    public List<BrowserInfo> getBrowsers() {
        ArrayList<BrowserInfo> browsersList = new ArrayList<BrowserInfo>();
        for (SlaveBrowser slave : this.getSlaveBrowsers()) {
            browsersList.add(slave.getBrowserInfo());
        }
        return browsersList;
    }

    public void removeSlave(String id) {
        logger.debug("remove browser {}", (Object)id);
        SlaveBrowser slave = this.slaves.remove(id);
        logger.debug("remove browser {}", slave);
        this.setChanged();
        this.notifyObservers(new BrowserCaptureEvent(BrowserCaptureEvent.Event.DISCONNECTED, slave));
    }

    public String toString() {
        return String.format("CapturedBrowsers(%s)", this.slaves);
    }
}

