/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.BrowserPanic;
import com.google.jstestdriver.DryRunInfo;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.LoadedFiles;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.TestCase;
import com.google.jstestdriver.browser.BrowserPanicException;
import com.google.jstestdriver.hooks.TestListener;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.model.RunData;
import com.google.jstestdriver.protocol.BrowserLog;
import java.io.PrintStream;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryRunAction
implements BrowserAction {
    private final List<String> expressions;
    private final ResponseStreamFactory responseStreamFactory;

    public DryRunAction(ResponseStreamFactory responseStreamFactory, List<String> expressions) {
        this.responseStreamFactory = responseStreamFactory;
        this.expressions = expressions;
    }

    @Override
    public ResponseStream run(String id, JsTestDriverClient client, RunData runData, JstdTestCase testCase) {
        ResponseStream responseStream = this.responseStreamFactory.getDryRunActionResponseStream();
        client.dryRunFor(id, responseStream, this.expressions, testCase);
        return responseStream;
    }

    public static class DryRunActionResponseStream
    implements ResponseStream {
        private final Gson gson = new Gson();
        private final PrintStream out;
        private final TestListener listener;

        public DryRunActionResponseStream(PrintStream out, TestListener testResultListener) {
            this.out = out;
            this.listener = testResultListener;
        }

        public void finish() {
        }

        public void stream(Response response) {
            BrowserInfo browser = response.getBrowser();
            switch (response.getResponseType()) {
                case TEST_QUERY_RESULT: {
                    DryRunInfo dryRunInfo = this.gson.fromJson(response.getResponse(), DryRunInfo.class);
                    for (TestCase testCase : dryRunInfo.getTestCases()) {
                        this.listener.onTestRegistered(browser, testCase);
                    }
                    this.out.println(String.format("%s %s: %s tests %s", browser.getName(), browser.getVersion(), dryRunInfo.getNumTests(), dryRunInfo.getTestNames()));
                    break;
                }
                case FILE_LOAD_RESULT: {
                    LoadedFiles files = (LoadedFiles)this.gson.fromJson(response.getResponse(), response.getGsonType());
                    for (FileResult result : files.getLoadedFiles()) {
                        this.listener.onFileLoad(response.getBrowser(), result);
                    }
                    break;
                }
                case BROWSER_PANIC: {
                    BrowserPanic panic = (BrowserPanic)this.gson.fromJson(response.getResponse(), response.getGsonType());
                    throw new BrowserPanicException(panic.getBrowserInfo(), panic.getCause());
                }
                case LOG: {
                    BrowserLog log = (BrowserLog)this.gson.fromJson(response.getResponse(), response.getGsonType());
                    LoggerFactory.getLogger(log.getSource()).debug(log.getMessage());
                }
            }
        }
    }
}

