/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.JsonElement;
import com.google.inject.Inject;
import com.google.jstestdriver.Server;
import com.google.jstestdriver.util.StopWatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServer
implements Server {
    private static final Logger logger = LoggerFactory.getLogger(HttpServer.class);
    private final StopWatch stopWatch;

    @Inject
    public HttpServer(StopWatch stopWatch) {
        this.stopWatch = stopWatch;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String fetch(String url) {
        String string;
        this.stopWatch.start("fetch %s", url);
        HttpURLConnection connection = null;
        logger.trace("Fetching {}", (Object)url);
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.connect();
            String response = this.toString(connection.getInputStream());
            logger.trace("Fetch response {}", (Object)response);
            string = response;
            if (connection != null) {
                connection.disconnect();
            }
        }
        catch (MalformedURLException e) {
            try {
                throw new RuntimeException(e);
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    connection.disconnect();
                }
                this.stopWatch.stop("fetch %s", url);
                throw throwable;
            }
        }
        this.stopWatch.stop("fetch %s", url);
        return string;
    }

    public void ping(String url) {
        HttpURLConnection connection = null;
        logger.trace("Pinging {}", (Object)url);
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.connect();
            connection.getInputStream();
            logger.trace("Pinged {}", (Object)url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String toString(InputStream inputStream) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = inputStream.read()) != -1) {
            sb.append((char)ch);
        }
        inputStream.close();
        return sb.toString();
    }

    @Override
    public String post(String url, Map<String, String> params) {
        String string;
        block5: {
            this.stopWatch.start("post %s", url);
            HttpURLConnection connection = null;
            try {
                logger.trace("Post url:{} \nParams:\n{} \n", (Object)url, params);
                String paramsString = this.convertParamsToString(params);
                connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", Integer.toString(paramsString.getBytes().length));
                OutputStreamWriter oWriter = new OutputStreamWriter(connection.getOutputStream());
                oWriter.write(paramsString);
                oWriter.close();
                connection.connect();
                String response = this.toString(connection.getInputStream());
                logger.trace("Post response:\n{}", (Object)response);
                string = response;
                if (connection == null) break block5;
                connection.disconnect();
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Connection error", e);
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        connection.disconnect();
                    }
                    this.stopWatch.stop("post %s", url);
                    throw throwable;
                }
            }
        }
        this.stopWatch.stop("post %s", url);
        return string;
    }

    @Override
    public String postJson(String url, JsonElement json) {
        String string;
        block5: {
            this.stopWatch.start("postJson %s", url);
            HttpURLConnection connection = null;
            try {
                logger.trace("Post url:{}\nJSON:\n{}\n", (Object)url, (Object)json);
                String jsonString = json.toString();
                connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setRequestProperty("Content-Type", "application/jsonrequest");
                connection.setRequestProperty("Content-Length", Integer.toString(jsonString.getBytes().length));
                OutputStreamWriter oWriter = new OutputStreamWriter(connection.getOutputStream());
                oWriter.write(jsonString);
                oWriter.close();
                connection.connect();
                String response = this.toString(connection.getInputStream());
                logger.trace("Post response:\n{}\n", (Object)response);
                string = response;
                if (connection == null) break block5;
                connection.disconnect();
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Connection error on: " + connection, e);
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        connection.disconnect();
                    }
                    this.stopWatch.stop("postJson %s", url);
                    throw throwable;
                }
            }
        }
        this.stopWatch.stop("postJson %s", url);
        return string;
    }

    public String convertParamsToString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            sb.append(String.format("%s=%s", URLEncoder.encode(entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8")));
            while (iterator.hasNext()) {
                entry = iterator.next();
                sb.append(String.format("&%s=%s", URLEncoder.encode(entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8")));
            }
        }
        return sb.toString();
    }

    @Override
    public String startSession(String baseUrl, String id) {
        return this.fetch(baseUrl + "/fileSet?id=" + id + "&session=start");
    }

    @Override
    public void stopSession(String baseUrl, String id, String sessionId) {
        this.fetch(baseUrl + "/fileSet?id=" + id + "&session=stop" + "&sessionId=" + sessionId);
    }
}

