/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.JsTestDriverServer;
import com.google.jstestdriver.browser.BrowserCaptureEvent;
import com.google.jstestdriver.browser.BrowserReaper;
import com.google.jstestdriver.config.ExecutionType;
import com.google.jstestdriver.hooks.FileInfoScheme;
import com.google.jstestdriver.hooks.ServerListener;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.server.JettyModule;
import com.google.jstestdriver.server.JstdTestCaseStore;
import com.google.jstestdriver.server.handlers.JstdHandlersModule;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTestDriverServerImpl
implements JsTestDriverServer,
Observer {
    private static final Logger logger = LoggerFactory.getLogger(JsTestDriverServerImpl.class);
    private Server server;
    private final int port;
    private final int sslPort;
    private final CapturedBrowsers capturedBrowsers;
    private final JstdTestCaseStore testCaseStore;
    private final long browserTimeout;
    private Timer timer;
    private final HandlerPathPrefix handlerPrefix;
    private final Set<ServerListener> listeners;
    private final Set<FileInfoScheme> schemes;
    private final ExecutionType executionType;
    private final Boolean debug;
    private static final ServerNotification<ServerListener> STARTED_NOTIFICATION = new ServerNotification<ServerListener>(){

        @Override
        public void notify(ServerListener listener) {
            listener.serverStarted();
        }
    };
    private static final ServerNotification<ServerListener> STOPPED_NOTIFICATION = new ServerNotification<ServerListener>(){

        @Override
        public void notify(ServerListener listener) {
            listener.serverStopped();
        }
    };

    @Inject
    public JsTestDriverServerImpl(@Assisted(value="port") int port, @Assisted(value="sslPort") int sslPort, @Assisted JstdTestCaseStore testCaseStore, CapturedBrowsers capturedBrowsers, @Named(value="browserTimeout") long browserTimeout, @Named(value="serverHandlerPrefix") HandlerPathPrefix handlerPrefix, Set<ServerListener> listeners, Set<FileInfoScheme> schemes, @Named(value="executionType") ExecutionType executionType, @Named(value="debug") Boolean debug) {
        this.port = port;
        this.sslPort = sslPort;
        this.capturedBrowsers = capturedBrowsers;
        this.testCaseStore = testCaseStore;
        this.browserTimeout = browserTimeout;
        this.handlerPrefix = handlerPrefix;
        this.listeners = listeners;
        this.schemes = schemes;
        this.executionType = executionType;
        this.debug = debug;
        this.initServer();
    }

    private void initServer() {
        if (this.server != null) {
            logger.warn("Attempt to start a started server");
        } else {
            this.capturedBrowsers.deleteObserver(this);
            this.capturedBrowsers.addObserver(this);
            this.server = Guice.createInjector(new JettyModule(this.port, this.sslPort, this.handlerPrefix), new JstdHandlersModule(this.capturedBrowsers, this.testCaseStore, this.browserTimeout, this.handlerPrefix, this.schemes, this.executionType, this.debug)).getInstance(Server.class);
            this.server.addLifeCycleListener(new JettyLifeCycleLogger());
        }
    }

    @Override
    public void start() {
        try {
            this.initServer();
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new BrowserReaper(this.capturedBrowsers), this.browserTimeout, this.browserTimeout);
            this.server.start();
            logger.info("Started the JsTD server on {} with execution type {}", this.port, (Object)this.executionType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try {
            this.timer.cancel();
            if (this.server != null) {
                this.server.stop();
                this.server.join();
                this.server = null;
            }
            logger.debug("Stopped the server.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void notifyListeners(ServerNotification<ServerListener> notification) {
        for (ServerListener listener : this.listeners) {
            notification.notify(listener);
        }
    }

    @Override
    public boolean isHealthy() {
        String url = "http://127.0.0.1:" + this.port + this.handlerPrefix.prefixPath("/hello");
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                return true;
            }
            logger.warn("Bad response code {} from server: {}", responseCode, connection.getContent());
            return false;
        }
        catch (MalformedURLException e) {
            logger.warn("Bad url {}", e);
        }
        catch (IOException e) {
            logger.warn("Server not ready.", e);
        }
        return false;
    }

    @Override
    public void update(Observable o, Object arg) {
        logger.debug("Server Event {}, {}" + o, arg);
        BrowserCaptureEvent event = (BrowserCaptureEvent)arg;
        BrowserInfo info = event.getBrowser().getBrowserInfo();
        switch (event.event) {
            case CONNECTED: {
                this.notifyListeners(new BrowserCaptureNotification(info));
                break;
            }
            case DISCONNECTED: {
                this.notifyListeners(new BrowserPanickedNotification(info));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ServerNotification<T> {
        public void notify(ServerListener var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BrowserCaptureNotification
    implements ServerNotification<ServerListener> {
        private final BrowserInfo info;

        private BrowserCaptureNotification(BrowserInfo info) {
            this.info = info;
        }

        @Override
        public void notify(ServerListener listener) {
            listener.browserCaptured(this.info);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BrowserPanickedNotification
    implements ServerNotification<ServerListener> {
        private final BrowserInfo info;

        private BrowserPanickedNotification(BrowserInfo info) {
            this.info = info;
        }

        @Override
        public void notify(ServerListener listener) {
            listener.browserPanicked(this.info);
        }
    }

    private final class JettyLifeCycleLogger
    implements LifeCycle.Listener {
        private JettyLifeCycleLogger() {
        }

        public void lifeCycleStopping(LifeCycle arg0) {
            logger.debug("Server stopping");
        }

        public void lifeCycleStopped(LifeCycle arg0) {
            JsTestDriverServerImpl.this.notifyListeners(STOPPED_NOTIFICATION);
            logger.debug("Server stopped");
        }

        public void lifeCycleStarting(LifeCycle arg0) {
            logger.debug("Server starting");
        }

        public void lifeCycleStarted(LifeCycle arg0) {
            JsTestDriverServerImpl.this.notifyListeners(STARTED_NOTIFICATION);
            logger.debug("Server started");
        }

        public void lifeCycleFailure(LifeCycle arg0, Throwable arg1) {
            logger.warn("Server failed", arg1);
        }
    }
}

