/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.jstestdriver.BrowserPanic;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.LoadedFiles;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.TestResultGenerator;
import com.google.jstestdriver.browser.BrowserPanicException;
import com.google.jstestdriver.hooks.TestListener;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunTestsActionResponseStream
implements ResponseStream {
    private static final Logger logger = LoggerFactory.getLogger(RunTestsActionResponseStream.class);
    private final TestResultGenerator testResultGenerator;
    private final TestListener listener;
    private final FailureAccumulator accumulator;
    private final Gson gson = new Gson();

    public RunTestsActionResponseStream(TestResultGenerator testResultGenerator, TestListener listener, FailureAccumulator accumulator) {
        this.testResultGenerator = testResultGenerator;
        this.listener = listener;
        this.accumulator = accumulator;
        logger.debug("listener for tests " + listener);
    }

    public void stream(Response response) {
        switch (response.getResponseType()) {
            case TEST_RESULT: {
                Collection<TestResult> testResults = this.testResultGenerator.getTestResults(response);
                for (TestResult result : testResults) {
                    if (result.getResult() == TestResult.Result.failed || result.getResult() == TestResult.Result.error) {
                        this.accumulator.add();
                    }
                    this.listener.onTestComplete(result);
                }
                break;
            }
            case FILE_LOAD_RESULT: {
                LoadedFiles files = (LoadedFiles)this.gson.fromJson(response.getResponse(), response.getGsonType());
                for (FileResult result : files.getLoadedFiles()) {
                    this.listener.onFileLoad(response.getBrowser(), result);
                    if (result.isSuccess()) continue;
                    this.accumulator.add();
                }
                break;
            }
            case BROWSER_PANIC: {
                BrowserPanic panic = (BrowserPanic)this.gson.fromJson(response.getResponse(), response.getGsonType());
                throw new BrowserPanicException(panic.getBrowserInfo(), panic.getCause());
            }
        }
    }

    public void finish() {
        this.listener.finish();
    }
}

