/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.common.base.Function;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.browser.BrowserRunner;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.util.StopWatch;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserControl {
    private final Function<JstdTestCase, String> TESTCASE_TO_ID = new Function<JstdTestCase, String>(){

        @Override
        public String apply(JstdTestCase testCase) {
            return testCase.getId();
        }
    };
    private static final String CAPTURE_URL = String.format("%%s/capture/%s/%%s/%s/%%s/%s/%%s/", "id", "timeout", "upload_size");
    private static final String CAPTURE_URL_WITH_TESTCASE_IDS = String.format("%%s/capture/%s/%%s/%s/%%s/%s/%%s/%s/%%s", "id", "timeout", "upload_size", "testcase_id");
    private static final Logger logger = LoggerFactory.getLogger(BrowserControl.class);
    private final BrowserRunner runner;
    private final String serverAddress;
    private final StopWatch stopWatch;
    private final JsTestDriverClient client;
    private final List<JstdTestCase> testCases;
    private final long browserTimeout;

    @Inject
    public BrowserControl(@Assisted BrowserRunner runner, @Assisted String serverAddress, StopWatch stopWatch, JsTestDriverClient client, @Assisted List<JstdTestCase> testCases, @Named(value="browserTimeout") long browserTimeout) {
        this.runner = runner;
        this.serverAddress = serverAddress;
        this.stopWatch = stopWatch;
        this.client = client;
        this.testCases = testCases;
        this.browserTimeout = browserTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String captureBrowser(String browserId) throws InterruptedException {
        String string;
        try {
            this.stopWatch.start("browser start %s", browserId);
            String url = this.testCases.isEmpty() ? String.format(CAPTURE_URL, this.serverAddress, browserId, Math.max(this.runner.getHeartbeatTimeout(), this.browserTimeout), this.runner.getUploadSize()) : String.format(CAPTURE_URL_WITH_TESTCASE_IDS, this.serverAddress, browserId, Math.max(this.runner.getHeartbeatTimeout(), this.browserTimeout), this.runner.getUploadSize(), this.testCases.get(0).getId());
            this.runner.startBrowser(url);
            long timeOut = TimeUnit.MILLISECONDS.convert(Math.max((long)this.runner.getTimeout(), this.browserTimeout), TimeUnit.SECONDS);
            long start = System.currentTimeMillis();
            try {
                logger.debug(String.format("Browser timeout %s for %s", timeOut, browserId));
                this.stopWatch.start("Capturing browser", browserId);
                while (!this.isBrowserCaptured(browserId, this.client)) {
                    Thread.sleep(50L);
                    if (System.currentTimeMillis() - start <= timeOut) continue;
                    throw new RuntimeException("Could not start browser " + this.runner + " in " + this.runner.getTimeout());
                }
            }
            catch (Throwable throwable) {
                this.stopWatch.stop("Capturing browser", browserId);
                throw throwable;
            }
            this.stopWatch.stop("Capturing browser", browserId);
            logger.debug("Browser {} started with id {}", this.runner, (Object)browserId);
            string = browserId;
        }
        catch (Throwable throwable) {
            this.stopWatch.stop("browser start %s", browserId);
            throw throwable;
        }
        this.stopWatch.stop("browser start %s", browserId);
        return string;
    }

    public void stopBrowser() {
        this.stopWatch.start("browser stop %s", this.runner);
        this.runner.stopBrowser();
        this.stopWatch.stop("browser stop %s", this.runner);
    }

    public boolean isBrowserCaptured(String browserId, JsTestDriverClient client) {
        for (BrowserInfo browserInfo : client.listBrowsers()) {
            if (!browserId.equals(String.valueOf(browserInfo.getId())) || !browserInfo.serverReceivedHeartbeat() || !browserInfo.browserReady()) continue;
            logger.debug("Started {}", browserInfo);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BrowserControlFactory {
        public BrowserControl create(BrowserRunner var1, String var2, List<JstdTestCase> var3);
    }
}

