/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.jstestdriver.ProcessFactory;
import com.google.jstestdriver.browser.BrowserRunner;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineBrowserRunner
implements BrowserRunner {
    private static final Logger logger = LoggerFactory.getLogger(CommandLineBrowserRunner.class);
    private final String browserPath;
    private final String browserArgs;
    private final ProcessFactory processFactory;
    private Process process;
    private LogReader logReader = new NullLogReader();

    public CommandLineBrowserRunner(String browserPath, String browserArgs, ProcessFactory processFactory) {
        this(browserPath, browserArgs, processFactory, Executors.newCachedThreadPool());
    }

    public CommandLineBrowserRunner(String browserPath, String browserArgs, ProcessFactory processFactory, ExecutorService executor) {
        this.browserPath = browserPath;
        this.processFactory = processFactory;
        this.browserArgs = browserArgs;
    }

    public void startBrowser(String serverAddress) {
        try {
            String processArgs = "";
            if (this.browserArgs.contains("%s")) {
                processArgs = this.browserArgs.replace("%s", serverAddress);
            } else {
                if (this.browserArgs.length() > 0) {
                    processArgs = this.browserArgs + " ";
                }
                processArgs = processArgs + serverAddress;
            }
            String[] args = processArgs.split(" ");
            String[] finalArgs = new String[args.length + 1];
            finalArgs[0] = this.browserPath;
            System.arraycopy(args, 0, finalArgs, 1, args.length);
            this.process = this.processFactory.start(finalArgs);
            this.logReader = new LogReaderImpl(this.process.getErrorStream(), this.process.getInputStream());
        }
        catch (IOException e) {
            logger.error("Could not start: {} because {}", (Object)this.browserPath, (Object)e.toString());
            throw new RuntimeException(e);
        }
    }

    public void stopBrowser() {
        try {
            this.logReader.stop();
            this.process.destroy();
            if (this.process.exitValue() != 0) {
                logger.warn("Unexpected shutdown " + this.process + " " + this.process.exitValue() + "\nLogs:" + this.getLog());
            }
        }
        catch (IllegalThreadStateException e) {
            logger.warn("Process refused to exit [" + this.browserPath + " ]: " + this.process);
        }
    }

    public int getTimeout() {
        return 30;
    }

    public int getNumStartupTries() {
        return 1;
    }

    public long getHeartbeatTimeout() {
        return 30000L;
    }

    public int getUploadSize() {
        return 50;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.browserPath == null ? 0 : this.browserPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandLineBrowserRunner)) {
            return false;
        }
        CommandLineBrowserRunner other = (CommandLineBrowserRunner)obj;
        return (this.browserPath == null && other.browserPath == null || this.browserPath.equals(other.browserPath)) && (this.browserArgs == null && other.browserArgs == null || this.browserArgs.equals(other.browserArgs));
    }

    public String toString() {
        return "CommandLineBrowserRunner [\nbrowserPath=" + this.browserPath + "\nargs=" + this.browserArgs + ",\nprocess=" + this.process + ",\n process log={\n" + this.getLog() + "\n}]";
    }

    private String getLog() {
        return this.logReader.getLog();
    }

    private static class LogReaderImpl
    implements Runnable,
    LogReader {
        private final InputStream errorStream;
        private final InputStream inputStream;
        private AtomicBoolean stream = new AtomicBoolean(true);
        private StringBuffer errLog = new StringBuffer();
        private StringBuffer outLog = new StringBuffer();

        public LogReaderImpl(InputStream errorStream, InputStream inputStream) {
            this.errorStream = errorStream;
            this.inputStream = inputStream;
        }

        public void stop() {
            this.stream.set(false);
        }

        public String getLog() {
            String out = "error:\n" + this.errLog + "\nout:\n" + this.outLog;
            this.errLog.delete(0, this.errLog.length());
            this.outLog.delete(0, this.outLog.length());
            return out;
        }

        public void run() {
            byte[] errBuffer = new byte[512];
            byte[] stdOutBuffer = new byte[512];
            try {
                while (this.stream.get()) {
                    while (this.errorStream.available() > 0) {
                        this.errorStream.read(errBuffer);
                        this.errLog.append(errBuffer);
                    }
                    while (this.inputStream.available() > 0) {
                        this.inputStream.read(stdOutBuffer);
                        this.outLog.append(errBuffer);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class NullLogReader
    implements LogReader {
        private NullLogReader() {
        }

        public void stop() {
        }

        public String getLog() {
            return "Not Started";
        }

        public void run() {
        }
    }

    static interface LogReader {
        public void stop();

        public String getLog();

        public void run();
    }
}

