/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.ConfigurationParser;
import com.google.jstestdriver.config.ConfigurationSource;
import com.google.jstestdriver.config.DefaultConfiguration;
import com.google.jstestdriver.model.BasePaths;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class DefaultConfigurationSource
implements ConfigurationSource {
    public File getParentFile() {
        return new File(".").getAbsoluteFile();
    }

    public Configuration parse(BasePaths basePaths, ConfigurationParser configParser) {
        File configFile = new File("jsTestDriver.conf").getAbsoluteFile();
        if (!configFile.exists()) {
            return new DefaultConfiguration(basePaths);
        }
        try {
            return configParser.parse(new InputStreamReader((InputStream)new FileInputStream(configFile), Charset.defaultCharset()), basePaths);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return "jsTestDriver.conf";
    }

    public String toString() {
        return "DefaultConfigurationSource [name=jsTestDriver.conf]";
    }
}

