/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.jstestdriver.ActionRunner;
import com.google.jstestdriver.Args4jFlagsParser;
import com.google.jstestdriver.FlagsParser;
import com.google.jstestdriver.JsTestDriver;
import com.google.jstestdriver.PluginLoader;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.ConfigurationException;
import com.google.jstestdriver.config.ConfigurationSource;
import com.google.jstestdriver.config.UserConfigurationSource;
import com.google.jstestdriver.config.YamlParser;
import com.google.jstestdriver.embedded.JsTestDriverImpl;
import com.google.jstestdriver.hooks.ActionListProcessor;
import com.google.jstestdriver.hooks.FileLoadPostProcessor;
import com.google.jstestdriver.hooks.JsTestDriverValidator;
import com.google.jstestdriver.hooks.PluginInitializer;
import com.google.jstestdriver.hooks.ServerListener;
import com.google.jstestdriver.hooks.TestListener;
import com.google.jstestdriver.model.BasePaths;
import com.google.jstestdriver.runner.RunnerMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTestDriverBuilder {
    private static final List<JsTestDriverValidator> DEFAULT_VALIDATORS = Lists.newArrayList(new JsTestDriverValidator(){

        public void validate(Injector injector) throws AssertionError {
            Preconditions.checkArgument(injector.getInstance(Key.get(new TypeLiteral<Set<ResponseStreamFactory>>(){})).size() > 0);
            Preconditions.checkArgument(injector.getInstance(Key.get(new TypeLiteral<Set<ActionListProcessor>>(){})).size() > 0);
            Preconditions.checkArgument(injector.getInstance(Key.get(new TypeLiteral<Set<FileLoadPostProcessor>>(){})).size() > 0);
            injector.getInstance(ActionRunner.class);
        }
    });
    private BasePaths basePaths = new BasePaths(new File[0]);
    private List<Module> pluginModules = Lists.newArrayList();
    private String[] flags = new String[0];
    private Configuration configuration;
    private final PluginLoader pluginLoader = new PluginLoader();
    private int port = -1;
    private final List<ServerListener> serverListeners = Lists.newArrayList();
    private final List<TestListener> testListeners = Lists.newArrayList();
    private RunnerMode runnerMode = RunnerMode.QUIET;
    private String serverAddress;
    private final List<JsTestDriverValidator> validators = Lists.newArrayList();
    private boolean raiseOnFailure = false;
    private boolean preload = false;
    private final List<Class<? extends PluginInitializer>> pluginInitializers = Lists.newArrayList();
    private final List<PluginInitializer> pluginInitializersInstances = Lists.newArrayList();
    private FlagsParser flagsParser = new Args4jFlagsParser();

    public JsTestDriverBuilder setDefaultConfiguration(String configPath) {
        this.setConfigurationSource(new UserConfigurationSource(new File(configPath)));
        return this;
    }

    public JsTestDriverBuilder setDefaultConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public JsTestDriverBuilder shouldValidate(boolean validate, JsTestDriverValidator ... extraValidators) {
        if (validate) {
            this.validators.addAll(DEFAULT_VALIDATORS);
            for (JsTestDriverValidator jsTestDriverValidator : extraValidators) {
                this.validators.add(jsTestDriverValidator);
            }
        } else {
            this.validators.clear();
        }
        return this;
    }

    public JsTestDriverBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    @Deprecated
    public JsTestDriverBuilder setFlagsParser(FlagsParser flagsParser) {
        this.flagsParser = flagsParser;
        return this;
    }

    public JsTestDriverBuilder addServerListener(ServerListener testServerListener) {
        this.serverListeners.add(testServerListener);
        return this;
    }

    public JsTestDriverBuilder raiseExceptionOnTestFailure(boolean raiseOnFailure) {
        this.raiseOnFailure = raiseOnFailure;
        return this;
    }

    public JsTestDriver build() throws AssertionError {
        if (this.configuration == null) {
            throw new ConfigurationException("A default configuration is required.");
        }
        ArrayList<Module> plugins = Lists.newArrayList(this.pluginModules);
        plugins.add(new ListenerBindingModule(this.serverListeners, this.testListeners));
        ArrayList<Module> initializers = Lists.newArrayList(new PluginInitializerModule(this.pluginInitializers, this.pluginInitializersInstances));
        initializers.addAll(this.pluginModules);
        this.basePaths.addAll(this.configuration.getBasePaths());
        this.configuration.getBasePaths().addAll(this.basePaths);
        JsTestDriverImpl jsTestDriver = new JsTestDriverImpl(this.configuration, this.pluginLoader, this.runnerMode, this.flags, this.port, plugins, initializers, this.basePaths, this.serverAddress, this.raiseOnFailure, this.preload, this.flagsParser);
        if (!this.validators.isEmpty()) {
            jsTestDriver.validate(this.validators.toArray(new JsTestDriverValidator[this.validators.size()]));
        }
        return jsTestDriver;
    }

    public JsTestDriverBuilder withPluginInitializer(Class<? extends PluginInitializer> initializer) {
        this.pluginInitializers.add(initializer);
        return this;
    }

    public JsTestDriverBuilder withPluginInitializer(PluginInitializer initializer) {
        this.pluginInitializersInstances.add(initializer);
        return this;
    }

    public JsTestDriverBuilder setRunnerMode(RunnerMode runnerMode) {
        this.runnerMode = runnerMode;
        return this;
    }

    public JsTestDriverBuilder addTestListener(TestListener testResultListener) {
        this.testListeners.add(testResultListener);
        return this;
    }

    public JsTestDriverBuilder setServer(String serverAddress) {
        this.serverAddress = serverAddress;
        return this;
    }

    public JsTestDriverBuilder addBaseDir(File file) {
        this.basePaths.add(file);
        return this;
    }

    public JsTestDriverBuilder setConfigurationSource(ConfigurationSource source) {
        this.setDefaultConfiguration(source.parse(this.basePaths, new YamlParser()));
        return this;
    }

    public JsTestDriverBuilder addPluginModules(List<Module> pluginModules) {
        this.pluginModules = pluginModules;
        return this;
    }

    public JsTestDriverBuilder setFlags(String[] flags) {
        this.flags = flags;
        return this;
    }

    public JsTestDriverBuilder preloadFiles() {
        this.preload = true;
        return this;
    }

    public JsTestDriverBuilder addBasePaths(BasePaths basePaths) {
        this.basePaths.addAll(basePaths);
        return this;
    }

    public JsTestDriverBuilder addBasePaths(File ... basePaths) {
        this.basePaths.addAll((Collection<? extends File>)Arrays.asList(basePaths));
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenerBindingModule
    implements Module {
        private final List<? extends ServerListener> serverListeners;
        private final List<? extends TestListener> testListeners;

        ListenerBindingModule(List<? extends ServerListener> serverListeners, List<? extends TestListener> testListeners) {
            this.serverListeners = serverListeners;
            this.testListeners = testListeners;
        }

        @Override
        public void configure(Binder binder) {
            Multibinder<ServerListener> serverSetBinder = Multibinder.newSetBinder(binder, ServerListener.class);
            for (ServerListener serverListener : this.serverListeners) {
                serverSetBinder.addBinding().toInstance(serverListener);
            }
            Multibinder<TestListener> testSetBinder = Multibinder.newSetBinder(binder, TestListener.class);
            for (TestListener testListener : this.testListeners) {
                testSetBinder.addBinding().toInstance(testListener);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PluginInitializerModule
    implements Module {
        private final List<Class<? extends PluginInitializer>> initializers;
        private final List<PluginInitializer> instances;

        public PluginInitializerModule(List<Class<? extends PluginInitializer>> initializers, List<PluginInitializer> instances) {
            this.initializers = initializers;
            this.instances = instances;
        }

        @Override
        public void configure(Binder binder) {
            Multibinder<PluginInitializer> setBinder = Multibinder.newSetBinder(binder, PluginInitializer.class);
            for (Class<? extends PluginInitializer> clazz : this.initializers) {
                setBinder.addBinding().to(clazz);
            }
            for (PluginInitializer pluginInitializer : this.instances) {
                setBinder.addBinding().toInstance(pluginInitializer);
            }
        }
    }
}

