/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.embedded;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.jstestdriver.ActionRunner;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.FlagsParser;
import com.google.jstestdriver.HttpServer;
import com.google.jstestdriver.JsTestDriver;
import com.google.jstestdriver.PluginLoader;
import com.google.jstestdriver.TestCase;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.config.CmdLineFlag;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.ConfigurationException;
import com.google.jstestdriver.config.InitializeModule;
import com.google.jstestdriver.config.Initializer;
import com.google.jstestdriver.config.UserConfigurationSource;
import com.google.jstestdriver.config.YamlParser;
import com.google.jstestdriver.hooks.JsTestDriverValidator;
import com.google.jstestdriver.hooks.TestListener;
import com.google.jstestdriver.model.BasePaths;
import com.google.jstestdriver.model.ConcretePathPrefix;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.model.NullPathPrefix;
import com.google.jstestdriver.runner.RunnerMode;
import com.google.jstestdriver.util.NullStopWatch;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTestDriverImpl
implements JsTestDriver {
    private Configuration defaultConfiguration;
    private PluginLoader pluginLoader;
    private List<Module> initializerModules;
    private RunnerMode runnerMode;
    private String[] defaultFlags;
    private int port;
    private List<Module> pluginModules;
    private BasePaths basePaths;
    private String serverAddress;
    private boolean raiseOnFailure;
    private boolean preload;
    private FlagsParser flagsParser;

    public JsTestDriverImpl(Configuration configuration, PluginLoader pluginLoader, RunnerMode runnerMode, String[] flags, int port, List<Module> pluginModules, List<Module> initializerModules, BasePaths basePaths, String serverAddress, boolean raiseOnFailure, boolean preload, FlagsParser flagsParser) {
        this.defaultConfiguration = configuration;
        this.pluginLoader = pluginLoader;
        this.initializerModules = initializerModules;
        this.runnerMode = runnerMode;
        this.defaultFlags = flags;
        this.port = port;
        this.pluginModules = pluginModules;
        this.basePaths = basePaths;
        this.serverAddress = serverAddress;
        this.raiseOnFailure = raiseOnFailure;
        this.preload = preload;
        this.flagsParser = flagsParser;
    }

    @Override
    public void startServer() {
        if (this.port == -1) {
            throw new ConfigurationException("Port not defined, cannot start local server.");
        }
        if (this.preload) {
            this.runConfigurationWithFlags(this.defaultConfiguration, this.createFlagsArray("--port", String.valueOf(this.port), "--preloadFiles"), new Module[0]);
        } else {
            this.runConfigurationWithFlags(this.defaultConfiguration, this.createFlagsArray("--port", String.valueOf(this.port)), new Module[0]);
        }
    }

    @Override
    public void stopServer() {
        CmdLineFlag handlerPrefixFlag = this.findServerHandlerPrefixFlag();
        HandlerPathPrefix prefix = new NullPathPrefix();
        if (handlerPrefixFlag != null) {
            prefix = new ConcretePathPrefix(handlerPrefixFlag.value);
        }
        StringBuilder urlBuilder = new StringBuilder(this.defaultConfiguration.getServer(this.serverAddress, this.port, prefix));
        urlBuilder.append("/");
        urlBuilder.append("quit");
        new HttpServer(new NullStopWatch()).ping(urlBuilder.toString());
    }

    @Override
    public List<TestResult> runConfiguration() {
        ArrayList<TestResult> results = Lists.newArrayList();
        this.runConfigurationWithFlags(this.defaultConfiguration, this.defaultFlags, new Module[0]);
        return results;
    }

    @Override
    public List<TestResult> runAllTests(String path) {
        return this.runAllTests(this.parseConfiguration(path));
    }

    @Override
    public List<TestResult> runAllTests(Configuration config) {
        TestResultCollector testResultCollector = new TestResultCollector();
        String server = config.getServer(this.serverAddress, this.port, new NullPathPrefix());
        this.runConfigurationWithFlags(config, this.createFlagsArray("--tests", "all", "--server", server), new TestListenerModule(testResultCollector));
        return testResultCollector.getResults();
    }

    @Override
    public List<TestResult> runTests(String path, List<String> tests) {
        return this.runTests(this.parseConfiguration(path), tests);
    }

    @Override
    public List<TestResult> runTests(Configuration config, List<String> tests) {
        TestResultCollector testResultCollector = new TestResultCollector();
        String server = config.getServer(this.serverAddress, this.port, new NullPathPrefix());
        this.runConfigurationWithFlags(config, this.createFlagsArray("--server", server, "--tests", Joiner.on(",").join(tests)), new TestListenerModule(testResultCollector));
        return testResultCollector.getResults();
    }

    @Override
    public void reset() {
        String server = this.defaultConfiguration.getServer(this.serverAddress, this.port, new NullPathPrefix());
        this.runConfigurationWithFlags(this.defaultConfiguration, this.createFlagsArray("--reset", "--server", server), new Module[0]);
    }

    @Override
    public List<TestCase> getTestCasesFor(String path) {
        return this.getTestCasesFor(this.parseConfiguration(path));
    }

    @Override
    public List<TestCase> getTestCasesFor(Configuration config) {
        TestCaseCollector testCaseCollector = new TestCaseCollector();
        String server = config.getServer(this.serverAddress, this.port, new NullPathPrefix());
        this.runConfigurationWithFlags(config, this.createFlagsArray("--dryRunFor", "all", "--server", server), new TestListenerModule(testCaseCollector));
        return testCaseCollector.getTestCases();
    }

    @Override
    public void captureBrowser(String browserPath) {
        throw new RuntimeException("not implemented");
    }

    private String[] createFlagsArray(String ... coreflags) {
        ArrayList<String> flags = Lists.newArrayList(coreflags);
        CmdLineFlag handlerPrefixFlag = this.findServerHandlerPrefixFlag();
        if (handlerPrefixFlag != null) {
            handlerPrefixFlag.addToArgs(flags);
        }
        flags.add("--raiseOnFailure");
        flags.add(Boolean.toString(this.raiseOnFailure));
        String[] flagsArray = flags.toArray(new String[flags.size()]);
        return flagsArray;
    }

    private Configuration parseConfiguration(String path) {
        File configFile = new File(path);
        if (!configFile.exists()) {
            throw new ConfigurationException("Could not find " + configFile);
        }
        UserConfigurationSource userConfigurationSource = new UserConfigurationSource(configFile);
        return userConfigurationSource.parse(this.basePaths, new YamlParser());
    }

    private void runConfigurationWithFlags(Configuration config, String[] flags, Module ... additionalRunTimeModules) {
        this.createRunnerInjector(config, flags, additionalRunTimeModules).getInstance(ActionRunner.class).runActions();
    }

    private Injector createRunnerInjector(Configuration config, String[] flags, Module ... additionalRunTimeModules) {
        if (config == null) {
            throw new ConfigurationException("Configuration cannot be null.");
        }
        ArrayList<Module> initializeModules = Lists.newArrayList(this.initializerModules);
        try {
            LogManager.getLogManager().readConfiguration(this.runnerMode.getLogConfig());
            System.out.println("setting runnermode " + (Object)((Object)this.runnerMode));
            BasePaths basePaths = this.getPathResolver(config);
            initializeModules.add(new InitializeModule(this.pluginLoader, basePaths, this.flagsParser, this.runnerMode));
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not find " + config.getBasePaths(), e);
        }
        Injector initializeInjector = Guice.createInjector(initializeModules);
        List<Module> actionRunnerModules = initializeInjector.getInstance(Initializer.class).initialize(this.pluginModules, config, this.runnerMode, flags);
        actionRunnerModules.addAll(Lists.newArrayList(additionalRunTimeModules));
        Injector injector = Guice.createInjector(actionRunnerModules);
        return injector;
    }

    void validate(JsTestDriverValidator ... validatiors) {
        Injector injector = this.createRunnerInjector(this.defaultConfiguration, this.createFlagsArray(new String[0]), new Module[0]);
        for (JsTestDriverValidator validator : validatiors) {
            validator.validate(injector);
        }
    }

    private CmdLineFlag findServerHandlerPrefixFlag() {
        for (int i = 0; i < this.defaultFlags.length; ++i) {
            if (!this.defaultFlags[i].startsWith("--serverHandlerPrefix")) continue;
            String flag = this.defaultFlags[i];
            String value = "";
            if (i + 1 < this.defaultFlags.length) {
                value = this.defaultFlags[i + 1];
            }
            return new CmdLineFlag(flag, value);
        }
        return null;
    }

    private BasePaths getPathResolver(Configuration config) {
        BasePaths mergedPaths = new BasePaths(new File[0]);
        for (int i = 0; i < this.defaultFlags.length; ++i) {
            if (!"--basePath".equals(this.defaultFlags[i])) continue;
            if (i + 1 >= this.defaultFlags.length) break;
            for (String path : this.defaultFlags[i + 1].split(",")) {
                mergedPaths.add(new File(path));
            }
            break;
        }
        mergedPaths = mergedPaths.merge(this.basePaths);
        return mergedPaths.merge(config.getBasePaths());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TestResultCollector
    implements TestListener {
        private final List<TestResult> results = Lists.newLinkedList();

        private TestResultCollector() {
        }

        @Override
        public void onTestRegistered(BrowserInfo browser, TestCase testCase) {
        }

        @Override
        public void onTestComplete(TestResult testResult) {
            this.results.add(testResult);
        }

        @Override
        public void onFileLoad(BrowserInfo browserInfo, FileResult fileResult) {
        }

        @Override
        public void finish() {
        }

        public List<TestResult> getResults() {
            return this.results;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TestCaseCollector
    implements TestListener {
        private final List<TestCase> testCases = Lists.newLinkedList();

        private TestCaseCollector() {
        }

        @Override
        public void onTestRegistered(BrowserInfo browser, TestCase testCase) {
            this.testCases.add(testCase);
        }

        @Override
        public void onTestComplete(TestResult testResult) {
        }

        @Override
        public void onFileLoad(BrowserInfo browserInfo, FileResult fileResult) {
        }

        @Override
        public void finish() {
        }

        public List<TestCase> getTestCases() {
            return this.testCases;
        }
    }

    private static final class TestListenerModule
    implements Module {
        private final TestListener listener;

        private TestListenerModule(TestListener listener) {
            this.listener = listener;
        }

        public void configure(Binder binder) {
            Multibinder.newSetBinder(binder, TestListener.class).addBinding().toInstance(this.listener);
        }
    }
}

