/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasePaths
implements Collection<File> {
    private final Set<File> paths;

    public BasePaths(File ... paths) {
        this(Sets.newHashSet(paths));
    }

    public BasePaths(List<File> paths) {
        this(Sets.newHashSet(paths));
    }

    public BasePaths(Set<File> paths) {
        this.paths = paths;
    }

    @Override
    public boolean add(File arg0) {
        return this.paths.add(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends File> arg0) {
        return this.paths.addAll(arg0);
    }

    @Override
    public void clear() {
        this.paths.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.paths.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.paths.containsAll(arg0);
    }

    @Override
    public boolean equals(Object arg0) {
        return ((Object)this.paths).equals(arg0);
    }

    @Override
    public int hashCode() {
        return ((Object)this.paths).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    @Override
    public Iterator<File> iterator() {
        return this.paths.iterator();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.paths.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.paths.retainAll(arg0);
    }

    @Override
    public int size() {
        return this.paths.size();
    }

    @Override
    public boolean remove(Object object) {
        return this.paths.remove(object);
    }

    @Override
    public Object[] toArray() {
        return this.paths.toArray();
    }

    @Override
    public <T> T[] toArray(T[] target) {
        return this.paths.toArray(target);
    }

    public BasePaths applyRelativePath(String relativePath) {
        HashSet<File> relativePaths = Sets.newHashSet();
        for (File path : this.paths) {
            relativePaths.add(new File(path, relativePath));
        }
        return new BasePaths(relativePaths);
    }

    public BasePaths merge(Collection<File> newPaths) {
        HashSet<File> merged = Sets.newHashSet(newPaths);
        merged.addAll(this.paths);
        return new BasePaths(merged);
    }

    public String toString() {
        return "BasePaths [paths=" + this.paths + "]";
    }

    public String toErrorString(String filePath) {
        ArrayList<String> errorPaths = Lists.newArrayListWithCapacity(this.paths.size());
        for (File basePath : this.paths) {
            errorPaths.add(new File(basePath, filePath).getAbsolutePath());
        }
        return "[\n" + Joiner.on("\n\t").join(errorPaths) + "\n]";
    }
}

