/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.model;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.model.JstdTestCaseDelta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JstdTestCase
implements Iterable<FileInfo> {
    private static final Logger logger = LoggerFactory.getLogger(JstdTestCase.class);
    private List<FileInfo> dependencies;
    private List<FileInfo> tests;
    private List<FileInfo> plugins;
    private String id;

    public JstdTestCase() {
    }

    public JstdTestCase(List<FileInfo> dependencies, List<FileInfo> tests, List<FileInfo> plugins, String id) {
        this.dependencies = dependencies;
        this.tests = tests;
        this.plugins = plugins;
        this.id = id;
    }

    public List<FileInfo> getTests() {
        return this.tests;
    }

    public List<FileInfo> getDependencies() {
        return this.dependencies;
    }

    public List<FileInfo> getPlugins() {
        return this.plugins;
    }

    public JstdTestCase applyDelta(JstdTestCaseDelta delta) {
        return new JstdTestCase(this.applyUpdates(this.dependencies, delta.getDependencies()), this.applyUpdates(this.tests, delta.getTests()), this.applyUpdates(this.plugins, delta.getPlugins()), this.id);
    }

    public JstdTestCaseDelta createUnloadedDelta() {
        return new JstdTestCaseDelta(this.findUnloaded(this.dependencies), this.findUnloaded(this.tests), this.findUnloaded(this.plugins));
    }

    private List<FileInfo> findUnloaded(List<FileInfo> files) {
        ArrayList<FileInfo> unloaded = Lists.newArrayList();
        for (FileInfo file : files) {
            if (file.isLoaded()) continue;
            unloaded.add(file);
        }
        return unloaded;
    }

    private List<FileInfo> applyUpdates(List<FileInfo> original, List<FileInfo> update) {
        HashMap<String, FileInfo> updates = Maps.newHashMap();
        ArrayList<FileInfo> merged = Lists.newArrayList();
        for (FileInfo fileInfo : update) {
            updates.put(fileInfo.getFilePath(), fileInfo);
        }
        for (FileInfo fileInfo : original) {
            if (updates.containsKey(fileInfo.getFilePath())) {
                merged.add((FileInfo)updates.get(fileInfo.getFilePath()));
                continue;
            }
            merged.add(fileInfo);
        }
        return merged;
    }

    public Set<FileInfo> toFileSet() {
        LinkedHashSet<FileInfo> fileSet = Sets.newLinkedHashSet(this.plugins);
        fileSet.addAll(this.dependencies);
        fileSet.addAll(this.tests);
        return fileSet;
    }

    public JstdTestCase updatePlugins(List<FileInfo> plugins) {
        ArrayList<FileInfo> combined = Lists.newArrayListWithExpectedSize(plugins.size() + this.plugins.size());
        combined.addAll(this.plugins);
        combined.addAll(plugins);
        return new JstdTestCase(this.dependencies, this.tests, combined, this.id);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dependencies == null ? 0 : ((Object)this.dependencies).hashCode());
        result = 31 * result + (this.plugins == null ? 0 : ((Object)this.plugins).hashCode());
        result = 31 * result + (this.tests == null ? 0 : ((Object)this.tests).hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JstdTestCase other = (JstdTestCase)obj;
        if (this.dependencies == null ? other.dependencies != null : !((Object)this.dependencies).equals(other.dependencies)) {
            return false;
        }
        if (this.plugins == null ? other.plugins != null : !((Object)this.plugins).equals(other.plugins)) {
            return false;
        }
        if (this.tests == null ? other.tests != null : !((Object)this.tests).equals(other.tests)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "JstdTestCase ([dependencies=" + (logger.isDebugEnabled() || logger.isTraceEnabled() ? this.dependencies : this.dependencies) + ", plugins=" + this.plugins + ", tests=" + this.tests + ",id=" + this.id + "]";
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Iterator<FileInfo> iterator() {
        return Iterables.concat(this.plugins, this.dependencies, this.tests).iterator();
    }

    public List<FileInfo> getServable() {
        ArrayList<FileInfo> servable = Lists.newArrayListWithExpectedSize(this.tests.size() + this.plugins.size() + this.dependencies.size());
        for (FileInfo file : this) {
            if (file.isServeOnly()) continue;
            servable.add(file);
        }
        return servable;
    }
}

