/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.output;

import com.google.inject.Inject;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.TestCase;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.hooks.TestListener;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTestResultListener
implements TestListener {
    private static final Logger logger = LoggerFactory.getLogger(MultiTestResultListener.class);
    private final Set<TestListener> delegates;

    @Inject
    public MultiTestResultListener(Set<TestListener> delegates) {
        this.delegates = delegates;
        logger.debug("listener:{} delegates: {}", this, delegates);
    }

    @Override
    public void onTestComplete(TestResult testResult) {
        for (TestListener delegate : this.delegates) {
            delegate.onTestComplete(testResult);
        }
    }

    @Override
    public void finish() {
        for (TestListener delegate : this.delegates) {
            delegate.finish();
        }
    }

    @Override
    public void onFileLoad(BrowserInfo browser, FileResult fileResult) {
        for (TestListener delegate : this.delegates) {
            delegate.onFileLoad(browser, fileResult);
        }
    }

    @Override
    public void onTestRegistered(BrowserInfo browser, TestCase testCase) {
        for (TestListener delegate : this.delegates) {
            delegate.onTestRegistered(browser, testCase);
        }
    }
}

