/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.requesthandlers;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryProvider;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.servlet.RequestParameters;
import com.google.inject.servlet.RequestScoped;
import com.google.jstestdriver.annotations.RequestProtocol;
import com.google.jstestdriver.annotations.ResponseWriter;
import com.google.jstestdriver.requesthandlers.GatewayConfiguration;
import com.google.jstestdriver.requesthandlers.HttpMethod;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.requesthandlers.RequestHandlerServlet;
import com.google.jstestdriver.requesthandlers.RequestMatcher;
import com.google.jstestdriver.requesthandlers.RequestScope;
import com.google.jstestdriver.server.gateway.GatewayRequestHandler;
import com.google.jstestdriver.server.gateway.MockRequestHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestHandlersModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandlersModule.class);
    private final ImmutableList.Builder<RequestMatcher> matchers = ImmutableList.builder();
    private final RequestScope requestScope = new RequestScope();

    protected abstract void configureHandlers();

    @Override
    protected void configure() {
        this.configureHandlers();
        this.bindScope(RequestScoped.class, this.requestScope);
        this.bind(RequestScope.class).toInstance(this.requestScope);
        this.bind(new Key<List<RequestMatcher>>(){}).toInstance(this.matchers.build());
        this.bind(Servlet.class).to(RequestHandlerServlet.class).in(Singleton.class);
        this.bind(GatewayRequestHandler.Factory.class).toProvider(FactoryProvider.newFactory(GatewayRequestHandler.Factory.class, GatewayRequestHandler.class));
        this.bind(MockRequestHandler.Factory.class).toProvider(FactoryProvider.newFactory(MockRequestHandler.Factory.class, MockRequestHandler.class));
        this.bind(GatewayConfiguration.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    HttpClient provideHttpClient() {
        Protocol.registerProtocol("https", new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        manager.getParams().setDefaultMaxConnectionsPerHost(20);
        manager.getParams().setMaxTotalConnections(200);
        HttpClient client = new HttpClient(manager);
        client.getParams().setCookiePolicy("ignoreCookies");
        return client;
    }

    @Provides
    @Singleton
    ServletContext provideServletContext(Servlet servlet) {
        return ((GenericServlet)servlet).getServletContext();
    }

    @Provides
    @RequestScoped
    HttpServletRequest provideRequest() {
        return RequestHandlerServlet.getRequest();
    }

    @Provides
    @RequestScoped
    HttpMethod provideRequestMethod() {
        return HttpMethod.valueOf(RequestHandlerServlet.getRequest().getMethod());
    }

    @Provides
    @RequestScoped
    @RequestProtocol
    String provideRequestProtocol() {
        return RequestHandlerServlet.getRequest().getProtocol();
    }

    @Provides
    @RequestScoped
    @RequestParameters
    Map<String, String[]> provideRequestParameters() {
        return RequestHandlerServlet.getRequest().getParameterMap();
    }

    @Provides
    @RequestScoped
    HttpServletResponse provideResponse() {
        return RequestHandlerServlet.getResponse();
    }

    @Provides
    @RequestScoped
    @ResponseWriter
    PrintWriter provideResponseWriter() throws IOException {
        return RequestHandlerServlet.getResponse().getWriter();
    }

    protected void serve(HttpMethod method, String pattern, Class<? extends RequestHandler> withHttpHandler) {
        logger.debug("Registering {} on {} to {}", new Object[]{method, pattern, withHttpHandler});
        RequestMatcher matcher = new RequestMatcher(method, pattern);
        this.matchers.add(matcher);
        MapBinder.newMapBinder(this.binder(), RequestMatcher.class, RequestHandler.class).addBinding(matcher).to(withHttpHandler).in(RequestScoped.class);
    }
}

