/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.BrowserPanic;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.StreamMessage;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.runner.RunnerType;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommandGetHandler
implements RequestHandler {
    private static Logger logger = LoggerFactory.getLogger(CommandGetHandler.class);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final Gson gson;
    private final CapturedBrowsers capturedBrowsers;

    @Inject
    public CommandGetHandler(HttpServletRequest request, HttpServletResponse response, Gson gson, CapturedBrowsers capturedBrowsers) {
        this.request = request;
        this.response = response;
        this.gson = gson;
        this.capturedBrowsers = capturedBrowsers;
    }

    public void handleIt() throws IOException {
        if (this.request.getParameter("listBrowsers") != null) {
            this.response.getWriter().write(this.listBrowsers());
        } else if (this.request.getParameter("nextBrowserId") != null) {
            this.response.getWriter().write(this.capturedBrowsers.getUniqueId());
        } else {
            this.streamResponse(this.request.getParameter("id"), this.response.getWriter());
        }
        this.response.getWriter().flush();
    }

    public String listBrowsers() {
        ArrayList<BrowserInfo> browsers = Lists.newArrayList();
        for (SlaveBrowser browser : this.capturedBrowsers.getSlaveBrowsers()) {
            if (browser.getRunnerType() == RunnerType.BROWSER) continue;
            browsers.add(browser.getBrowserInfo());
        }
        return this.gson.toJson(browsers);
    }

    private void streamResponse(String id, PrintWriter writer) {
        SlaveBrowser browser = this.capturedBrowsers.getBrowser(id);
        writer.write(this.gson.toJson(this.getResponse(browser)));
    }

    private StreamMessage getResponse(SlaveBrowser browser) {
        StreamMessage cmdResponse = null;
        while (cmdResponse == null) {
            if (!browser.isAlive()) {
                SlaveBrowser deadBrowser = this.capturedBrowsers.getBrowser(browser.getId());
                this.capturedBrowsers.removeSlave(browser.getId());
                Response response = new Response();
                BrowserInfo browserInfo = deadBrowser.getBrowserInfo();
                response.setBrowser(browserInfo);
                response.setResponse(this.gson.toJson(new BrowserPanic(browserInfo, String.format("Browser unresponsive since %s during %s", browser.getLastHeartbeat(), browser.getCommandRunning()))));
                response.setType(BrowserPanic.TYPE_NAME);
                return new StreamMessage(true, response);
            }
            cmdResponse = this.substituteBrowserInfo(browser.getResponse());
        }
        return cmdResponse;
    }

    private StreamMessage substituteBrowserInfo(StreamMessage cmdResponse) {
        Response response = cmdResponse.getResponse();
        SlaveBrowser slaveBrowser = this.capturedBrowsers.getBrowser(response.getBrowser().getId().toString());
        if (slaveBrowser != null) {
            response.setBrowser(slaveBrowser.getBrowserInfo());
        } else {
            BrowserInfo nullBrowserInfo = new BrowserInfo();
            nullBrowserInfo.setId(response.getBrowser().getId());
            nullBrowserInfo.setName("unknown browser");
            nullBrowserInfo.setVersion("unknown version");
            nullBrowserInfo.setOs("unknown os");
            response.setBrowser(nullBrowserInfo);
        }
        return new StreamMessage(cmdResponse.isLast(), response);
    }
}

