/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.inject.Inject;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.annotations.ResponseWriter;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;

class HomeHandler
implements RequestHandler {
    private final CapturedBrowsers capturedBrowsers;
    private final HttpServletResponse response;
    private final PrintWriter writer;

    @Inject
    public HomeHandler(CapturedBrowsers capturedBrowsers, HttpServletResponse response, @ResponseWriter PrintWriter writer) {
        this.capturedBrowsers = capturedBrowsers;
        this.response = response;
        this.writer = writer;
    }

    public void handleIt() throws IOException {
        this.response.setContentType("text/html");
        this.writer.write("<html><head><title>JsTestDriver</title>");
        this.writer.write("<script>");
        this.writer.write("function getEl(id){return document.getElementById(id);}");
        this.writer.write("function toggle(id) {\n");
        this.writer.write("if (getEl(id).style.display=='block') {");
        this.writer.write("getEl(id).style.display='none';");
        this.writer.write("} else {");
        this.writer.write("getEl(id).style.display='block';}");
        this.writer.write("}</script>");
        this.writer.write("</head><body>");
        this.writer.write("<a href=\"/capture\">Capture This Browser</a><br/>");
        this.writer.write("<a href=\"/capture?strict\">Capture This Browser in strict mode</a><br/>");
        this.writer.write("<p><strong>Captured Browsers: (");
        this.writer.write(String.valueOf(this.capturedBrowsers.getSlaveBrowsers().size()));
        this.writer.write(")</strong></p>");
        for (SlaveBrowser browser : this.capturedBrowsers.getSlaveBrowsers()) {
            this.writer.write("<div>");
            BrowserInfo info = browser.getBrowserInfo();
            this.writer.write("Id: " + info.getId() + "<br/>");
            this.writer.write("Name: " + info.getName() + "<br/>");
            this.writer.write("Version: " + info.getVersion() + "<br/>");
            this.writer.write("Operating System: " + info.getOs() + "<br/>");
            this.writer.write(browser.inUse() ? "In use.<br/>" : "Not in use.<br/>");
            this.writer.write(String.format("RunnerType %s <br/>", new Object[]{browser.getRunnerType()}));
            if (browser.getCommandRunning() != null) {
                this.writer.write("Currently running " + browser.getCommandRunning() + "<br/>");
            } else {
                this.writer.write("Currently waiting...<br/>");
            }
            this.writer.write("<input type='button' value='List Files' onclick=\"toggle('f" + browser.getId() + "')\"/>");
            this.writer.write("<ul style='display:none' id='f" + browser.getId() + "'>");
            for (FileInfo fileInfo : browser.getFileSet()) {
                this.writer.write("<li>");
                this.writer.write(fileInfo.getDisplayPath());
                this.writer.write("</li>");
            }
            this.writer.write("</ul>");
            this.writer.write("<input type='button' value='Show Responses' onclick=\"toggle('r" + browser.getId() + "')\"/>");
            this.writer.write("<pre id='r" + browser.getId() + "' style='display:none'>");
            this.writer.write(browser.viewResponses());
            this.writer.write("</pre>");
            this.writer.write("</div>");
            this.writer.flush();
        }
        this.writer.write("</body></html>");
        this.writer.flush();
    }
}

