/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import ohos.FileUtils;
import ohos.Log;
import ohos.ScanErrorEnum;
import ohos.Utility;

public class ScanStatDuplicate {
    private static final String UNPACK_NAME = "unpack";
    private static final String DUPLICATE_FOLDER_NAME = "duplicate";
    private static final String EMPTY_STRING = "";
    private static final String SHA_256 = "SHA-256";
    private static final String RESULT_MD5 = "md5";
    private static final String RESULT_SIZE = "size";
    private static final String RESULT_FILES = "files";
    private static final String DUPLICATE_DESC = "find the duplicated files";
    private static final String DUPLICATE_PARAM = "--stat-duplicate";
    private static final String TASK_TYPE = "taskType";
    private static final String TASK_DESC = "taskDesc";
    private static final String PARAM = "param";
    private static final String START_TIME = "startTime";
    private static final String STOP_TIME = "stopTime";
    private static final String RESULT = "result";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private static final int MD5_BUFFER_SIZE = 1024;
    private static final long DUPLICATE_TYPE = 1L;
    private static final int MD5_LENGTH = 16;
    private static final long SHOW_SIZE = 10L;
    private static final String HTML_BUTTON_SHOW = "<button id=\"show_%s\" type=\"button\" onclick=\"show_%s()\" style=\"display: block\">more</button>";
    private static final String HTML_BUTTON_HIDE = "<button id=\"hide_%s\" type=\"button\" onclick=\"hide_%s()\" style=\"display: none\">close</button>";
    private static final String HTML_TABLE_BOX = "<table class=\"boxTable\">";
    private static final String HTML_TABLE_END = "</table>";
    private static final String HTML_TR_TD_LAYOUT = "<tr class=\"layout\"><td class=\"key\">";
    private static final String HTML_TR_TD_VALUE = "</td><td class=\"value\">";
    private static final String HTML_TR_TD_END = "</td></tr>";
    private static final String HTML_TR_TD_RESULT = "<tr class=\"result\"><td class=\"key\">";
    private static final String HTML_TR_TD = "<tr%s><td%s>";
    private static final String HTML_TD_END_TD = "</td><td%s>";
    private static final String HTML_LI_CIRCLE = "<li type=\"circle\">";
    private static final String HTML_LI_END = "</li>";
    private static final String HTML_TR_TD_DUPLICATE_KEY = "<tr class=\"duplicateLayout\"><td class=\"duplicateKey\">";
    private static final String HTML_TD_DUPLICATE_VALUE = "</td><td class=\"duplicateValue\"><ul>";
    private static final String HTML_UL_TD_TR_END = "</ul></td></tr>";
    private static final String HTML_UL_HEAD = "<ul>";
    private static final String CLASS_DUPLICATE_LAYOUT = " class=\"duplicateLayout\"";
    private static final String CLASS_DUPLICATE_KEY = " class=\"duplicateKey\"";
    private static final String CLASS_DUPLICATE_VALUE = " class=\"duplicateValue\"";
    private static final String HTML_LI_HEAD = "<li>";
    private static final String HTML_LI_DUPLICATE = "<li class=\"duplicate\">";
    private static final String HTML_TABLE_DUPLICATE = "<table class=\"duplicateTable\">";
    private static final String HTML_TABLE_LI_END = "</table></li>";
    private static final String HTML_UL_END = "</ul>";
    private static final Log LOG = new Log(ScanStatDuplicate.class.toString());

    public String statDuplicate(Utility utility, List<String> list, List<String> list2) throws IOException, NoSuchAlgorithmException {
        List<String> list3;
        DuplicateResult duplicateResult = new DuplicateResult();
        duplicateResult.setStartTime(ScanStatDuplicate.getCurrentTime());
        List<ParamModel> list4 = this.getDuplicateResList(list2);
        File file = new File(utility.getOutPath());
        if (!file.exists() && !file.mkdirs()) {
            LOG.error(ScanErrorEnum.STAT_DUPLICATE_CREATE_FILE_ERROR.toString());
        }
        ArrayList<ParamModel> arrayList = new ArrayList<ParamModel>();
        for (ParamModel object2 : list4) {
            list3 = object2.getFiles();
            if (list3.size() <= 1) continue;
            arrayList.add(object2);
        }
        duplicateResult.setResult(arrayList);
        duplicateResult.setStopTime(ScanStatDuplicate.getCurrentTime());
        String string = ScanStatDuplicate.getHtmlRow(TASK_TYPE, duplicateResult.getTaskType());
        String string2 = ScanStatDuplicate.getHtmlRow(TASK_DESC, duplicateResult.getTaskDesc());
        list3 = ScanStatDuplicate.getHtmlRow(PARAM, duplicateResult.getParam());
        String string3 = ScanStatDuplicate.getHtmlRow(START_TIME, duplicateResult.getStartTime());
        String string4 = ScanStatDuplicate.getHtmlRow(STOP_TIME, duplicateResult.getStopTime());
        String string5 = ScanStatDuplicate.getResultHtml(duplicateResult.getResult());
        String string6 = ScanStatDuplicate.getHtmlRowResultClass(RESULT, string5);
        String string7 = HTML_TABLE_BOX + (String)string + string2 + (String)((Object)list3) + string3 + string4 + string6 + HTML_TABLE_END;
        String string8 = JSON.toJSONString((Object)duplicateResult, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
        list.add(string8);
        return string7;
    }

    private static String getCurrentTime() {
        long l = System.currentTimeMillis();
        return new SimpleDateFormat(DATE_FORMAT).format(l);
    }

    private List<ParamModel> getDuplicateResList(List<String> list) throws IOException, NoSuchAlgorithmException {
        ArrayList<ParamModel> arrayList = new ArrayList<ParamModel>();
        for (String string : list) {
            List<String> list2;
            boolean bl = true;
            String string2 = this.md5HashCode(string);
            for (ParamModel paramModel : arrayList) {
                String string3 = paramModel.getMd5();
                if (!string3.equals(string2)) continue;
                list2 = paramModel.getFiles();
                list2.add(this.splitPath(string, UNPACK_NAME));
                paramModel.setFiles(list2);
                bl = false;
            }
            if (!bl) continue;
            ParamModel paramModel = new ParamModel();
            long l = FileUtils.getFileSize(string);
            paramModel.setMd5(string2);
            paramModel.setSize(l);
            list2 = paramModel.getFiles();
            list2.add(this.splitPath(string, UNPACK_NAME));
            arrayList.add(paramModel);
        }
        return arrayList;
    }

    private static String getHtmlRow(String string, long l) {
        return HTML_TR_TD_LAYOUT + string + HTML_TR_TD_VALUE + l + HTML_TR_TD_END;
    }

    private static String getHtmlRow(String string, String string2) {
        return HTML_TR_TD_LAYOUT + string + HTML_TR_TD_VALUE + string2 + HTML_TR_TD_END;
    }

    private static String getHtmlRowResultClass(String string, String string2) {
        return HTML_TR_TD_RESULT + string + HTML_TR_TD_VALUE + string2 + HTML_TR_TD_END;
    }

    private static String getHtmlRowResult(String string, long l, String string2, String string3, String string4) {
        return String.format(HTML_TR_TD + string + HTML_TD_END_TD + l + HTML_TR_TD_END, string2, string3, string4);
    }

    private static String getHtmlRowResult(String string, String string2, String string3, String string4, String string5) {
        return String.format(HTML_TR_TD + string + HTML_TD_END_TD + string2 + HTML_TR_TD_END, string3, string4, string5);
    }

    private static String getHtmlRowResult(String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder(EMPTY_STRING);
        for (String string2 : list) {
            stringBuilder.insert(0, HTML_LI_CIRCLE + string2 + HTML_LI_END);
        }
        return HTML_TR_TD_DUPLICATE_KEY + string + HTML_TD_DUPLICATE_VALUE + stringBuilder + HTML_UL_TD_TR_END;
    }

    private static String getResultHtml(List<ParamModel> list) {
        StringBuilder stringBuilder = new StringBuilder(EMPTY_STRING);
        stringBuilder.append(HTML_UL_HEAD);
        for (int i = 0; i < list.size(); ++i) {
            ParamModel paramModel = list.get(i);
            String string = ScanStatDuplicate.getHtmlRowResult(RESULT_MD5, paramModel.getMd5(), CLASS_DUPLICATE_LAYOUT, CLASS_DUPLICATE_KEY, CLASS_DUPLICATE_VALUE);
            String string2 = ScanStatDuplicate.getHtmlRowResult(RESULT_SIZE, paramModel.getSize(), CLASS_DUPLICATE_LAYOUT, CLASS_DUPLICATE_KEY, CLASS_DUPLICATE_VALUE);
            String string3 = ScanStatDuplicate.getHtmlRowResult(RESULT_FILES, paramModel.getFiles());
            String string4 = 10L > (long)i ? HTML_LI_HEAD : HTML_LI_DUPLICATE;
            String string5 = string4 + HTML_TABLE_DUPLICATE + string + string2 + string3 + HTML_TABLE_LI_END;
            stringBuilder.append(string5);
        }
        stringBuilder.append(HTML_UL_END);
        if ((long)list.size() > 10L) {
            stringBuilder.append(String.format(HTML_BUTTON_SHOW, DUPLICATE_FOLDER_NAME, DUPLICATE_FOLDER_NAME));
            stringBuilder.append(String.format(HTML_BUTTON_HIDE, DUPLICATE_FOLDER_NAME, DUPLICATE_FOLDER_NAME));
        }
        return stringBuilder.toString();
    }

    private String md5HashCode(String string) throws IOException, NoSuchAlgorithmException {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance(SHA_256);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray, 0, 1024)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = messageDigest.digest();
            BigInteger bigInteger = new BigInteger(1, byArray2);
            string2 = bigInteger.toString(16);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                LOG.error((Object)((Object)ScanErrorEnum.STAT_DUPLICATE_INPUT_STREAM_ERROR) + iOException.getMessage());
                throw new IOException(ScanErrorEnum.STAT_DUPLICATE_INPUT_STREAM_ERROR.msg + iOException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOG.error((Object)((Object)ScanErrorEnum.STAT_DUPLICATE_MESSAGE_DIGEST_ERROR) + noSuchAlgorithmException.getMessage());
                throw new NoSuchAlgorithmException(ScanErrorEnum.STAT_DUPLICATE_MESSAGE_DIGEST_ERROR.msg + noSuchAlgorithmException.getMessage());
            }
        }
        ((InputStream)fileInputStream).close();
        return string2;
    }

    private String splitPath(String string, String string2) {
        String[] stringArray = string.split(string2);
        if (stringArray.length > 1) {
            return stringArray[1];
        }
        return string;
    }

    private static class DuplicateResult {
        private long taskType = 1L;
        private String taskDesc = "find the duplicated files";
        private String param = "--stat-duplicate";
        private String startTime = "";
        private String stopTime = "";
        private List<ParamModel> result = new ArrayList<ParamModel>();

        private DuplicateResult() {
        }

        public long getTaskType() {
            return this.taskType;
        }

        public void setTaskType(long l) {
            this.taskType = l;
        }

        public String getTaskDesc() {
            return this.taskDesc;
        }

        public void setTaskDesc(String string) {
            this.taskDesc = string;
        }

        public String getParam() {
            return this.param;
        }

        public void setParam(String string) {
            this.param = string;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String string) {
            this.startTime = string;
        }

        public String getStopTime() {
            return this.stopTime;
        }

        public void setStopTime(String string) {
            this.stopTime = string;
        }

        public List<ParamModel> getResult() {
            return this.result;
        }

        public void setResult(List<ParamModel> list) {
            this.result = list;
        }
    }

    private static class ParamModel {
        private String md5 = "";
        private long size;
        private List<String> files = new ArrayList<String>();

        private ParamModel() {
        }

        public String getMd5() {
            return this.md5;
        }

        public void setMd5(String string) {
            this.md5 = string;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long l) {
            this.size = l;
        }

        public List<String> getFiles() {
            return this.files;
        }

        public void setFiles(List<String> list) {
            this.files = list;
        }
    }
}

