/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import ohos.BundleException;
import ohos.FileUtils;
import ohos.Log;
import ohos.ScanErrorEnum;
import ohos.Utility;

public class ScanStatSuffix {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String SUFFIX_FOLDER_NAME = "suffix";
    private static final String UNPACK_NAME = "unpack";
    private static final String EMPTY_STRING = "";
    private static final String RESULT_FILES = "files";
    private static final String RESULT_TOTAL_SIZE = "totalSize";
    private static final String SUFFIX_DESC = "show files group by file type[.suffix]";
    private static final String SUFFIX_PARAM = "--stat-suffix";
    private static final String SUFFIX_TYPE_UNKNOWN = "unknownType";
    private static final String TASK_TYPE = "taskType";
    private static final String TASK_DESC = "taskDesc";
    private static final String PARAM = "param";
    private static final String START_TIME = "startTime";
    private static final String STOP_TIME = "stopTime";
    private static final String PATH_LIST = "pathList";
    private static final String RESULT = "result";
    private static final String HAP = ".hap";
    private static final String HSP = ".hsp";
    private static final String FILE_TYPE_SO = "so";
    private static final String TMP_FOLDER_NAME = "temporary";
    private static final String LIBS_NAME = "libs";
    private static final String USER_DIR = "user.dir";
    private static final String STATEMENT_FILE = "file:";
    private static final String STATEMENT_SIZE = "size:";
    private static final String STATEMENT_COMPRESS = "compress:";
    private static final int BUFFER_SIZE = 10240;
    private static final long SUFFIX_TYPE = 3L;
    private static final long SCAN_LEVEL = 2L;
    private static final long SHOW_SIZE = 10L;
    private static final String SPLIT_POINT = "\\.";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private static final String HTML_BUTTON_SHOW = "<button id=\"show_%s\" type=\"button\" onclick=\"show_%s()\" style=\"display: block\">more</button>";
    private static final String HTML_BUTTON_HIDE = "<button id=\"hide_%s\" type=\"button\" onclick=\"hide_%s()\" style=\"display: none\">close</button>";
    private static final String TABLE_BOXTABLE = "<table class=\"boxTable\">";
    private static final String TABLE_END = "</table>";
    private static final String TABLE_SUFFIX = "<table class=\"suffixTable\">";
    private static final String HTML_UL_HEAD = "<ul>";
    private static final String HTML_UL_END = "</ul>";
    private static final String HTML_LI_HEAD = "<li>";
    private static final String HTML_LI_END = "</li>";
    private static final String HTML_BR_HEAD = "<br>";
    private static final String HTML_LI_SUFFIX = "<li class=\"suffix\">";
    private static final String HTML_TR_STYLE = "<tr class=\"layout\"><td class=\"key\">";
    private static final String HTML_TD_STYLE = "</td><td class=\"value\">";
    private static final String HTML_TDTR_END = "</td></tr>";
    private static final String HTML_TDTR_HEAD = "<tr%s><td%s>";
    private static final String HTML_TDTR_SEND = "</td><td%s>";
    private static final String HTML_TRTD_STYLE = "<tr class=\"result\"><td class=\"key\">";
    private static final String CLASS_SUFFIXLAYOUT = " class=\"suffixLayout\"";
    private static final String CLASS_SUFFIXKEY = " class=\"suffixKey\"";
    private static final String CLASS_SUFFIXVALUE = " class=\"suffixValue\"";
    private static final String CLASS_TRTD_SUFFIXVALUE = "<tr class=\"suffixLayout\"><td class=\"suffixKey\">";
    private static final String CLASS_TD_SUFFIXVALUE = "</td><td class=\"suffixValue\">";
    private static final Log LOG = new Log(ScanStatSuffix.class.toString());

    public String statSuffix(Utility utility, List<String> list, List<String> list2) throws BundleException {
        SuffixResult suffixResult = new SuffixResult();
        suffixResult.setTaskType(3L);
        suffixResult.setTaskDesc(SUFFIX_DESC);
        suffixResult.setParam(SUFFIX_PARAM);
        suffixResult.setStartTime(ScanStatSuffix.getCurrentTime());
        String string = System.getProperty(USER_DIR);
        String string2 = string + File.separator + TMP_FOLDER_NAME;
        String string3 = utility.getInput();
        ScanStatSuffix.unpackHap(string3, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        suffixResult.setPathList(this.getPathListData(string2, string3, arrayList));
        List<ParamModelSuffix> list3 = this.setMapData(string2, list2, arrayList);
        File file = new File(string2);
        ScanStatSuffix.deleteFile(file);
        list3.sort(Comparator.comparing(ParamModelSuffix::getTotalSize).reversed());
        suffixResult.setResult(list3);
        File file2 = new File(utility.getOutPath());
        if (!file2.exists() && !file2.mkdirs()) {
            LOG.error(ScanErrorEnum.SUFFIX_MKDIRS_ERROR.toString());
        }
        suffixResult.setStopTime(ScanStatSuffix.getCurrentTime());
        String string4 = this.setHtmlData(suffixResult);
        String string5 = JSON.toJSONString((Object)suffixResult, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
        list.add(string5);
        return string4;
    }

    private List<String> getPathListData(String string, String string2, ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        FileUtils.getFileList(string, arrayList);
        File file = new File(string2);
        for (String string3 : arrayList) {
            if (!string3.contains(HAP) && !string3.contains(HSP)) continue;
            string3 = this.splitPath(string3, TMP_FOLDER_NAME);
            arrayList2.add(file.getName() + string3);
        }
        return arrayList2;
    }

    private List<ParamModelSuffix> setMapData(String string, List<String> list, ArrayList<String> arrayList) {
        HashMap<String, List<FileInfo>> hashMap = new HashMap<String, List<FileInfo>>();
        ArrayList<ParamModelSuffix> arrayList2 = new ArrayList<ParamModelSuffix>();
        for (String string2 : list) {
            hashMap = ScanStatSuffix.accountFileType(hashMap, string2);
        }
        for (String string2 : hashMap.keySet()) {
            List<Object> list2;
            ParamModelSuffix paramModelSuffix = new ParamModelSuffix();
            paramModelSuffix.setSuffix(string2);
            if (string2.equalsIgnoreCase(FILE_TYPE_SO)) {
                list2 = new ArrayList();
                List<FileInfo> list3 = hashMap.get(string2);
                long l = 0L;
                Object object = list3.iterator();
                while (object.hasNext()) {
                    FileInfo fileInfo = (FileInfo)object.next();
                    SoFile soFile = new SoFile();
                    soFile.setSize(fileInfo.getSize());
                    String string3 = fileInfo.getFile();
                    string3 = this.splitPath(string3, UNPACK_NAME);
                    soFile.setFile(string3);
                    int n = string3.indexOf(File.separator + LIBS_NAME);
                    String string4 = string3.substring(0, n);
                    File file = new File(string4);
                    long l2 = this.getOldSize(arrayList, file);
                    long l3 = this.getNewSize(list3, file);
                    soFile.setCompress(l2 < l3 ? TRUE : FALSE);
                    list2.add(soFile);
                    l += fileInfo.getSize();
                }
                object = new File(string);
                ScanStatSuffix.deleteFile((File)object);
                paramModelSuffix.setTotalSize(l);
                list2.sort(Comparator.comparing(FileInfo::getSize).reversed());
                paramModelSuffix.setFiles(list2);
            } else {
                list2 = hashMap.get(string2);
                for (FileInfo fileInfo : list2) {
                    String string5 = fileInfo.getFile();
                    fileInfo.setFile(this.splitPath(string5, UNPACK_NAME));
                }
                list2.sort(Comparator.comparing(FileInfo::getSize).reversed());
                paramModelSuffix.setFiles(list2);
                long l = list2.stream().mapToLong(FileInfo::getSize).sum();
                paramModelSuffix.setTotalSize(l);
            }
            arrayList2.add(paramModelSuffix);
        }
        return arrayList2;
    }

    private String setHtmlData(SuffixResult suffixResult) {
        String string = EMPTY_STRING;
        if (suffixResult.getPathList() != null && !suffixResult.getPathList().isEmpty()) {
            string = ScanStatSuffix.getPathListHtml(suffixResult.getPathList());
        }
        String string2 = EMPTY_STRING;
        if (!string.isEmpty() || !EMPTY_STRING.equals(string)) {
            string2 = ScanStatSuffix.getHtmlRow(PATH_LIST, string);
        }
        String string3 = ScanStatSuffix.getHtmlRow(TASK_TYPE, suffixResult.getTaskType());
        String string4 = ScanStatSuffix.getHtmlRow(TASK_DESC, suffixResult.getTaskDesc());
        String string5 = ScanStatSuffix.getHtmlRow(PARAM, suffixResult.getParam());
        String string6 = ScanStatSuffix.getHtmlRow(START_TIME, suffixResult.getStartTime());
        String string7 = ScanStatSuffix.getHtmlRow(STOP_TIME, suffixResult.getStopTime());
        String string8 = ScanStatSuffix.getResultHtmlOfSuffix(suffixResult.getResult());
        String string9 = ScanStatSuffix.getHtmlRowResultClass(RESULT, string8);
        return TABLE_BOXTABLE + string3 + string4 + string5 + string6 + string7 + string2 + string9 + TABLE_END;
    }

    private String splitPath(String string, String string2) {
        String[] stringArray = string.split(string2);
        if (stringArray.length > 1) {
            return stringArray[1];
        }
        return string;
    }

    private long getOldSize(List<String> list, File file) {
        long l = 0L;
        for (String string : list) {
            File file2 = new File(string);
            if (!file2.getName().equals(file.getName())) continue;
            l = file2.length();
        }
        return l;
    }

    private long getNewSize(List<FileInfo> list, File file) {
        long l = 0L;
        for (FileInfo fileInfo : list) {
            if (!fileInfo.getFile().contains(file.getPath())) continue;
            File file2 = new File(fileInfo.getFile());
            l += file2.length();
        }
        return l;
    }

    private static HashMap<String, List<FileInfo>> accountFileType(HashMap<String, List<FileInfo>> hashMap, String string) {
        File file = new File(string);
        String[] stringArray = file.getName().split(SPLIT_POINT);
        if (stringArray.length > 1) {
            String string2 = stringArray[stringArray.length - 1];
            if (hashMap.containsKey(string2)) {
                ScanStatSuffix.accountType(hashMap, file, string2);
            } else {
                ScanStatSuffix.accountTypeUnknown(hashMap, file, string2);
            }
        } else if (stringArray.length == 1) {
            if (hashMap.containsKey(SUFFIX_TYPE_UNKNOWN)) {
                ScanStatSuffix.accountType(hashMap, file, SUFFIX_TYPE_UNKNOWN);
            } else {
                ScanStatSuffix.accountTypeUnknown(hashMap, file, SUFFIX_TYPE_UNKNOWN);
            }
        }
        return hashMap;
    }

    private static void accountType(HashMap<String, List<FileInfo>> hashMap, File file, String string) {
        FileInfo fileInfo = ScanStatSuffix.getFileInfo(file);
        List<FileInfo> list = hashMap.get(string);
        list.add(fileInfo);
        hashMap.put(string, list);
    }

    private static void accountTypeUnknown(HashMap<String, List<FileInfo>> hashMap, File file, String string) {
        FileInfo fileInfo = ScanStatSuffix.getFileInfo(file);
        ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
        arrayList.add(fileInfo);
        hashMap.put(string, arrayList);
    }

    private static FileInfo getFileInfo(File file) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFile(file.getPath());
        long l = FileUtils.getFileSize(file.getPath());
        fileInfo.setSize(l);
        return fileInfo;
    }

    private static String getPathListHtml(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder(EMPTY_STRING);
        for (String string : list) {
            stringBuilder.append(string).append(HTML_BR_HEAD);
        }
        return stringBuilder.toString();
    }

    private static String getResultHtmlOfSuffix(List<ParamModelSuffix> list) {
        StringBuilder stringBuilder = new StringBuilder(EMPTY_STRING);
        stringBuilder.append(HTML_UL_HEAD);
        for (int i = 0; i < list.size(); ++i) {
            ParamModelSuffix paramModelSuffix = list.get(i);
            String string = paramModelSuffix.getSuffix().equalsIgnoreCase(FILE_TYPE_SO) ? ScanStatSuffix.getHtmlRowFileSo(RESULT_FILES, paramModelSuffix.getFiles()) : ScanStatSuffix.getHtmlRowFile(RESULT_FILES, paramModelSuffix.getFiles());
            String string2 = 10L > (long)i ? HTML_LI_HEAD : HTML_LI_SUFFIX;
            String string3 = ScanStatSuffix.getHtmlRowResult(SUFFIX_FOLDER_NAME, paramModelSuffix.getSuffix(), CLASS_SUFFIXLAYOUT, CLASS_SUFFIXKEY, CLASS_SUFFIXVALUE);
            String string4 = ScanStatSuffix.getHtmlRowResult(RESULT_TOTAL_SIZE, paramModelSuffix.getTotalSize(), CLASS_SUFFIXLAYOUT, CLASS_SUFFIXKEY, CLASS_SUFFIXVALUE);
            String string5 = string2 + TABLE_SUFFIX + string3 + string4 + string + TABLE_END + HTML_LI_END;
            stringBuilder.append(string5);
        }
        stringBuilder.append(HTML_UL_END);
        if ((long)list.size() > 10L) {
            stringBuilder.append(String.format(HTML_BUTTON_SHOW, SUFFIX_FOLDER_NAME, SUFFIX_FOLDER_NAME));
            stringBuilder.append(String.format(HTML_BUTTON_HIDE, SUFFIX_FOLDER_NAME, SUFFIX_FOLDER_NAME));
        }
        return stringBuilder.toString();
    }

    private static String getHtmlRow(String string, String string2) {
        return HTML_TR_STYLE + string + HTML_TD_STYLE + string2 + HTML_TDTR_END;
    }

    private static String getHtmlRow(String string, long l) {
        return HTML_TR_STYLE + string + HTML_TD_STYLE + l + HTML_TDTR_END;
    }

    private static String getHtmlRowResultClass(String string, String string2) {
        return HTML_TRTD_STYLE + string + HTML_TD_STYLE + string2 + HTML_TDTR_END;
    }

    private static String getHtmlRowResult(String string, String string2, String string3, String string4, String string5) {
        return String.format(HTML_TDTR_HEAD + string + HTML_TDTR_SEND + string2 + HTML_TDTR_END, string3, string4, string5);
    }

    private static String getHtmlRowResult(String string, long l, String string2, String string3, String string4) {
        return String.format(HTML_TDTR_HEAD + string + HTML_TDTR_SEND + l + HTML_TDTR_END, string2, string3, string4);
    }

    private static String getHtmlRowFile(String string, List<FileInfo> list) {
        StringBuilder stringBuilder = new StringBuilder(EMPTY_STRING);
        for (FileInfo fileInfo : list) {
            stringBuilder.insert(0, STATEMENT_FILE + fileInfo.getFile() + HTML_BR_HEAD);
            stringBuilder.insert(0, STATEMENT_SIZE + fileInfo.getSize() + HTML_BR_HEAD);
        }
        return CLASS_TRTD_SUFFIXVALUE + string + CLASS_TD_SUFFIXVALUE + stringBuilder + HTML_TDTR_END;
    }

    private static String getHtmlRowFileSo(String string, List<SoFile> list) {
        StringBuilder stringBuilder = new StringBuilder(EMPTY_STRING);
        for (SoFile soFile : list) {
            stringBuilder.insert(0, STATEMENT_FILE + soFile.getFile() + HTML_BR_HEAD);
            stringBuilder.insert(0, STATEMENT_SIZE + soFile.getSize() + HTML_BR_HEAD);
            stringBuilder.insert(0, STATEMENT_COMPRESS + soFile.getCompress() + HTML_BR_HEAD);
        }
        return CLASS_TRTD_SUFFIXVALUE + string + CLASS_TD_SUFFIXVALUE + stringBuilder + HTML_TDTR_END;
    }

    private static String getCurrentTime() {
        long l = System.currentTimeMillis();
        return new SimpleDateFormat(DATE_FORMAT).format(l);
    }

    private static void unpackHap(String string, String string2) throws BundleException {
        try (FileInputStream fileInputStream = new FileInputStream(string);
             ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));){
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            ScanStatSuffix.unpackEntryToFile(zipInputStream, string2);
        }
        catch (IOException iOException) {
            LOG.error((Object)((Object)ScanErrorEnum.SUFFIX_UNPACK_ERROR) + iOException.getMessage());
            throw new BundleException(ScanErrorEnum.SUFFIX_UNPACK_ERROR.msg + iOException.getMessage());
        }
    }

    private static void unpackEntryToFile(ZipInputStream zipInputStream, String string) throws BundleException, IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            File file = new File(string, string2);
            if (zipEntry.isDirectory()) {
                file.mkdirs();
                zipInputStream.closeEntry();
                continue;
            }
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                int n;
                byte[] byArray = new byte[10240];
                while ((n = zipInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                LOG.error((Object)((Object)ScanErrorEnum.SUFFIX_UNPACK_STREAM_ERROR) + iOException.getMessage());
                throw new BundleException(ScanErrorEnum.SUFFIX_UNPACK_STREAM_ERROR.msg + iOException.getMessage());
            }
            zipInputStream.closeEntry();
        }
    }

    private static void deleteFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                ScanStatSuffix.deleteFile(file2);
            }
        }
        file.delete();
    }

    private static class SuffixResult {
        private long taskType;
        private String taskDesc;
        private String param;
        private String startTime;
        private String stopTime;
        private List<String> pathList = new ArrayList<String>();
        private List<ParamModelSuffix> result = new ArrayList<ParamModelSuffix>();

        private SuffixResult() {
        }

        public long getTaskType() {
            return this.taskType;
        }

        public void setTaskType(long l) {
            this.taskType = l;
        }

        public String getTaskDesc() {
            return this.taskDesc;
        }

        public void setTaskDesc(String string) {
            this.taskDesc = string;
        }

        public String getParam() {
            return this.param;
        }

        public void setParam(String string) {
            this.param = string;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String string) {
            this.startTime = string;
        }

        public String getStopTime() {
            return this.stopTime;
        }

        public void setStopTime(String string) {
            this.stopTime = string;
        }

        public List<ParamModelSuffix> getResult() {
            return this.result;
        }

        public void setResult(List<ParamModelSuffix> list) {
            this.result = list;
        }

        public List<String> getPathList() {
            return this.pathList;
        }

        public void setPathList(List<String> list) {
            this.pathList = list;
        }
    }

    private static class ParamModelSuffix {
        private String suffix;
        private long totalSize;
        private List files = new ArrayList();

        private ParamModelSuffix() {
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String string) {
            this.suffix = string;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public void setTotalSize(long l) {
            this.totalSize = l;
        }

        public List getFiles() {
            return this.files;
        }

        public void setFiles(List list) {
            this.files = list;
        }
    }

    private static class FileInfo {
        private String file;
        private long size;

        private FileInfo() {
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String string) {
            this.file = string;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long l) {
            this.size = l;
        }
    }

    private static class SoFile
    extends FileInfo {
        private String compress = "false";

        private SoFile() {
        }

        public String getCompress() {
            return this.compress;
        }

        public void setCompress(String string) {
            this.compress = string;
        }
    }
}

