/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import ohos.BundleException;
import ohos.Log;
import ohos.Utility;

class FileUtils {
    private static final int BUFFER_SIZE = 1024;
    private static final int SHA256_BUFFER_SIZE = 10240;
    private static final Log LOG = new Log(FileUtils.class.toString());
    private static final String RESOURCE_PATH = "resources/base/profile/";
    private static final String SHA256 = "SHA-256";
    private static final String PATTERN = "[0-9A-Za-z/].{0,4095}";

    FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileData(String string) {
        File file = new File(string);
        long l = file.length();
        byte[] byArray = new byte[(int)l];
        if (l > Integer.MAX_VALUE) {
            LOG.error("file too big.");
            return byArray;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int n = 0;
            for (int i = 0; i < byArray.length && (n = fileInputStream.read(byArray, i, byArray.length - i)) >= 0; i += n) {
            }
        }
        catch (IOException iOException) {
            byte[] byArray2;
            try {
                LOG.error("getFileData IOException error: " + iOException.getMessage());
                byArray2 = new byte[(int)l];
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(fileInputStream);
                throw throwable;
            }
            FileUtils.closeStream(fileInputStream);
            return byArray2;
        }
        FileUtils.closeStream(fileInputStream);
        return byArray;
    }

    public static Optional<String> searchFile(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileUtils.getFileList(string2, arrayList);
        for (String string3 : arrayList) {
            if (!string3.endsWith(string)) continue;
            return Optional.ofNullable(string3);
        }
        return Optional.empty();
    }

    public static void getFileList(String string, ArrayList<String> arrayList) {
        File file = new File(string);
        if (!file.exists()) {
            LOG.error("getFileList: file is not exists.");
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            LOG.error("getFileList: no file in this file path.");
            return;
        }
        for (File file2 : fileArray) {
            try {
                if (file2.isFile()) {
                    arrayList.add(file2.getCanonicalPath());
                    continue;
                }
                if (file2.isDirectory()) {
                    FileUtils.getFileList(file2.getCanonicalPath(), arrayList);
                    continue;
                }
                LOG.error("It's not file or directory.");
            }
            catch (IOException iOException) {
                LOG.error("IOException error: " + iOException.getMessage());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<String> getFileContent(String string) {
        if (string.isEmpty()) {
            return Optional.empty();
        }
        BufferedReader bufferedReader = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string2;
            fileInputStream = new FileInputStream(string);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
        }
        catch (IOException iOException) {
            Optional<String> optional;
            try {
                LOG.error("get file content fail, msg is " + iOException.getMessage());
                optional = Optional.empty();
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(bufferedReader);
                FileUtils.closeStream(inputStreamReader);
                FileUtils.closeStream(fileInputStream);
                throw throwable;
            }
            FileUtils.closeStream(bufferedReader);
            FileUtils.closeStream(inputStreamReader);
            FileUtils.closeStream(fileInputStream);
            return optional;
        }
        FileUtils.closeStream(bufferedReader);
        FileUtils.closeStream(inputStreamReader);
        FileUtils.closeStream(fileInputStream);
        return Optional.ofNullable(stringBuilder.toString());
    }

    public static void closeStream(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            LOG.error("stream close Error, msg is " + iOException.getMessage());
        }
    }

    public static void deleteFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String string, String string2) {
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        ZipFile zipFile = null;
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                int n2;
                ++n;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry == null) continue;
                String string3 = string2 + File.separator + zipEntry.getName();
                if (!FileUtils.matchPattern(string3)) {
                    LOG.error("Input invalid file: " + string3);
                    throw new BundleException("Input invalid file " + string3);
                }
                if (zipEntry.isDirectory()) {
                    new File(string3).mkdirs();
                    continue;
                }
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                File file2 = new File(string3);
                File file3 = file2.getParentFile();
                if (file3 != null && !file3.exists()) {
                    file3.mkdirs();
                }
                fileOutputStream = new FileOutputStream(file2);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
                int n3 = 0;
                byte[] byArray = new byte[1024];
                while ((n2 = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n2);
                    n3 += n2;
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                fileOutputStream.close();
                bufferedInputStream.close();
            }
        }
        catch (IOException | BundleException exception) {
            LOG.error("unzip file failed " + exception.getMessage());
        }
        finally {
            FileUtils.closeStream(bufferedOutputStream);
            FileUtils.closeStream(fileOutputStream);
            FileUtils.closeStream(bufferedInputStream);
            FileUtils.closeStream(zipFile);
        }
    }

    public static void deleteDirectory(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            try {
                if (file2.isFile()) {
                    file2.delete();
                    continue;
                }
                if (file2.isDirectory()) {
                    FileUtils.deleteDirectory(file2.getCanonicalPath());
                    continue;
                }
                LOG.error("It's not file or directory.");
            }
            catch (IOException iOException) {
                LOG.error("deleteDirectory IOException : " + iOException.getMessage());
            }
        }
        file.delete();
    }

    public static Optional<String> getFormatedPath(String string) {
        String string2;
        try {
            File file = new File(string);
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            LOG.error("format path IOException : " + iOException.getMessage());
            return Optional.empty();
        }
        return Optional.of(string2);
    }

    public static boolean checkFileIsExists(String string) {
        if (string.isEmpty()) {
            return false;
        }
        Optional<String> optional = FileUtils.getFormatedPath(string);
        if (!optional.isPresent()) {
            return false;
        }
        File file = new File(optional.get());
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException, BundleException {
        if (file == null || file2 == null) {
            String string = "CompressorFileUtil::copyFile input file is null.";
            LOG.error(string);
            throw new BundleException(string);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            Utility.closeStream(fileInputStream);
            Utility.closeStream(fileOutputStream);
            throw throwable;
        }
        Utility.closeStream(fileInputStream);
        Utility.closeStream(fileOutputStream);
    }

    public static void makeDir(File file) throws IOException, BundleException {
        if (file == null) {
            String string = "CompressorFileUtil::makeDir input file is null.";
            LOG.error(string);
            throw new BundleException(string);
        }
        file.mkdirs();
    }

    public static String getJsonInZips(File file, String string) throws BundleException {
        String string2 = file.getPath();
        ZipFile zipFile = null;
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        ZipEntry zipEntry = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            zipFile = new ZipFile(file);
            fileInputStream = new FileInputStream(string2);
            zipInputStream = new ZipInputStream(fileInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string3;
                if (!zipEntry.getName().toLowerCase().equals(string)) continue;
                inputStream = zipFile.getInputStream(zipEntry);
                inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string3);
                }
                inputStream.close();
            }
            stringBuilder = new StringBuilder(stringBuilder.toString().replaceAll("\r|\n|\t", ""));
        }
        catch (IOException iOException) {
            try {
                LOG.error("Compressor::checkModuleTypeInHaps io exception: " + iOException.getMessage());
                throw new BundleException("Compressor::checkModuleTypeInHaps failed.");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipFile);
                Utility.closeStream(fileInputStream);
                Utility.closeStream(zipInputStream);
                Utility.closeStream(inputStream);
                Utility.closeStream(inputStreamReader);
                Utility.closeStream(bufferedReader);
                throw throwable;
            }
        }
        Utility.closeStream(zipFile);
        Utility.closeStream(fileInputStream);
        Utility.closeStream(zipInputStream);
        Utility.closeStream(inputStream);
        Utility.closeStream(inputStreamReader);
        Utility.closeStream(bufferedReader);
        return stringBuilder.toString();
    }

    static HashMap<String, String> getProfileJson(ZipFile zipFile) throws BundleException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().contains(RESOURCE_PATH)) continue;
                String string = zipEntry.getName();
                String string2 = string.replaceAll(RESOURCE_PATH, "");
                String string3 = FileUtils.getFileStringFromZip(string, zipFile);
                hashMap.put(string2, string3);
            }
        }
        catch (IOException iOException) {
            LOG.error("FileUtil::getProfileJson IOException: " + iOException.getMessage());
            throw new BundleException("FileUtil::getProfileJson failed.");
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileStringFromZip(String string, ZipFile zipFile) throws IOException {
        String string2;
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry == null) {
            LOG.debug("Uncompress::readStringFromFile " + string + " not found exception.");
            return "";
        }
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string3;
            inputStream = zipFile.getInputStream(zipEntry);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3);
            }
            string2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utility.closeStream(bufferedReader);
            Utility.closeStream(inputStream);
            throw throwable;
        }
        Utility.closeStream(bufferedReader);
        Utility.closeStream(inputStream);
        return string2;
    }

    /*
     * Exception decompiling
     */
    public static String getSha256(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(Integer.toHexString(by & 0xFF));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unzipFile(String string, String string2) {
        boolean bl;
        ZipInputStream zipInputStream;
        block10: {
            boolean bl2 = false;
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(new FileInputStream(string));
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    String string3 = string2 + File.separator + zipEntry.getName();
                    if (!FileUtils.matchPattern(string3)) {
                        LOG.error("Input invalid file " + string3 + ".");
                        bl = false;
                        break block10;
                    }
                    if (!zipEntry.isDirectory()) {
                        FileUtils.extractFile(zipInputStream, string3);
                    } else {
                        File file2 = new File(string3);
                        file2.mkdirs();
                    }
                    zipInputStream.closeEntry();
                    zipEntry = zipInputStream.getNextEntry();
                }
                bl2 = true;
            }
            catch (IOException iOException) {
                try {
                    LOG.error("FileUtil::unzipFile failed, IOException is " + iOException.getMessage());
                }
                catch (Throwable throwable) {
                    Utility.closeStream(zipInputStream);
                    throw throwable;
                }
                Utility.closeStream(zipInputStream);
                return bl2;
            }
            Utility.closeStream(zipInputStream);
            return bl2;
        }
        Utility.closeStream(zipInputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFile(ZipInputStream zipInputStream, String string) {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            if (!FileUtils.matchPattern(string)) {
                LOG.error("input invalid file: " + string);
                throw new BundleException("input invalid file " + string + ".");
            }
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = zipInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException | BundleException exception) {
            try {
                LOG.error("FileUtil::extractFile failed, Exception is " + exception.getMessage());
            }
            catch (Throwable throwable) {
                Utility.closeStream(bufferedOutputStream);
                throw throwable;
            }
            Utility.closeStream(bufferedOutputStream);
        }
        Utility.closeStream(bufferedOutputStream);
    }

    static boolean matchPattern(String string) {
        if (!Pattern.matches(PATTERN, string)) {
            LOG.error("input invalid file of " + string + ".");
            return false;
        }
        return true;
    }

    public static long getFileSize(String string) {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            return file.length();
        }
        LOG.error("input " + string + " is not a valid file.");
        return 0L;
    }
}

