/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool;

import com.ohos.entity.RetMsg;
import com.ohos.entity.SignAppParameters;
import com.ohos.entity.SignProfileParameters;
import com.ohos.entity.VerifyAppParameters;
import com.ohos.entity.VerifyProfileParameters;
import com.ohos.hapsigntool.api.ServiceApi;
import com.ohos.hapsigntool.api.SignToolServiceImpl;
import com.ohos.hapsigntool.entity.Options;
import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.ParamException;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.StringUtils;
import com.ohos.hapsigntoolcmd.CmdUtil;
import com.ohos.hapsigntoolcmd.HelpDocument;
import com.ohos.hapsigntoolcmd.Params;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HapSignTool {
    private static final Logger LOGGER = LogManager.getLogger(HapSignTool.class);
    private static final String VERSION = "1.0.0";
    private static final String LOCAL_SIGN = "localSign";
    private static final String REMOTE_SIGN = "remoteSign";
    private static final String SIGNED = "1";
    private static final String NOT_SIGNED = "0";
    private static final List<String> informList = new ArrayList<String>();

    private HapSignTool() {
    }

    public static void main(String[] args) {
        try {
            boolean isSuccess = HapSignTool.processCmd(args);
            if (!isSuccess) {
                System.exit(1);
            }
        }
        catch (CustomException e) {
            LOGGER.error(String.format(Locale.ROOT, "%s, code: %d. Details: %s", new Object[]{e.getError(), e.getError().getErrorCode(), e.getMessage()}));
            System.exit(1);
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ROOT, "UNKNOWN_ERROR, code: %d. Details: %s", ERROR.UNKNOWN_ERROR.getErrorCode(), e.getMessage()));
            System.exit(1);
        }
    }

    public static boolean processCmd(String[] args) throws CustomException {
        if (args.length == 0 || StringUtils.isEmpty(args[0])) {
            HapSignTool.help();
        } else if ("-h".equals(args[0]) || "-help".equals(args[0])) {
            HapSignTool.help();
        } else if ("-v".equals(args[0]) || "-version".equals(args[0])) {
            HapSignTool.version();
        } else {
            SignToolServiceImpl api = new SignToolServiceImpl();
            Params params = CmdUtil.convert2Params(args);
            LOGGER.debug(params.toString());
            LOGGER.info("Start {}", (Object)params.getMethod());
            boolean isSuccess = HapSignTool.dispatchParams(params, api);
            if (isSuccess) {
                LOGGER.info(String.format("%s %s", params.getMethod(), "success"));
            } else {
                LOGGER.info(String.format("%s %s", params.getMethod(), "failed"));
            }
            return isSuccess;
        }
        return true;
    }

    private static boolean callGenerators(Params params, ServiceApi api) {
        boolean isSuccess = false;
        switch (params.getMethod()) {
            case "generate-app-cert": {
                isSuccess = HapSignTool.runAppCert(params.getOptions(), api);
                break;
            }
            case "generate-ca": {
                isSuccess = HapSignTool.runCa(params.getOptions(), api);
                break;
            }
            case "generate-cert": {
                isSuccess = HapSignTool.runCert(params.getOptions(), api);
                break;
            }
            case "generate-csr": {
                isSuccess = HapSignTool.runCsr(params.getOptions(), api);
                break;
            }
            case "generate-keypair": {
                isSuccess = HapSignTool.runKeypair(params.getOptions(), api);
                break;
            }
            case "generate-profile-cert": {
                isSuccess = HapSignTool.runProfileCert(params.getOptions(), api);
                break;
            }
            default: {
                CustomException.throwException(ERROR.COMMAND_ERROR, "Unsupported cmd");
            }
        }
        return isSuccess;
    }

    private static boolean dispatchParams(Params params, ServiceApi api) {
        boolean isSuccess;
        switch (params.getMethod()) {
            case "sign-app": {
                isSuccess = HapSignTool.runSignApp(params.getOptions(), api);
                break;
            }
            case "sign-profile": {
                isSuccess = HapSignTool.runSignProfile(params.getOptions(), api);
                break;
            }
            case "verify-app": {
                isSuccess = HapSignTool.runVerifyApp(params.getOptions(), api);
                break;
            }
            case "verify-profile": {
                isSuccess = HapSignTool.runVerifyProfile(params.getOptions(), api);
                break;
            }
            default: {
                isSuccess = HapSignTool.callGenerators(params, api);
            }
        }
        return isSuccess;
    }

    private static void checkEndCertArguments(Options params) {
        String outFile;
        params.required("keyAlias", "issuer", "issuerKeyAlias", "subject", "signAlg", "keystoreFile");
        String signAlg = params.getString("signAlg");
        CmdUtil.judgeEndSignAlgType(signAlg);
        String outForm = params.getString("outForm");
        if (!StringUtils.isEmpty(outForm)) {
            CmdUtil.verifyType(outForm, "cert,certChain");
        }
        if (StringUtils.isEmpty(outForm) || "certChain".equals(outForm)) {
            params.required("subCaCertFile", "rootCaCertFile");
            FileUtils.validFileType(params.getString("subCaCertFile"), "cer");
            FileUtils.validFileType(params.getString("rootCaCertFile"), "cer");
        }
        String keyStoreFile = params.getString("keystoreFile");
        FileUtils.validFileType(keyStoreFile, "p12", "jks");
        if (params.containsKey("issuerKeystoreFile")) {
            String issuerKeyStoreFile = params.getString("issuerKeystoreFile");
            FileUtils.validFileType(issuerKeyStoreFile, "p12", "jks");
        }
        if (!StringUtils.isEmpty(outFile = params.getString("outFile"))) {
            FileUtils.validFileType(outFile, "cer", "pem");
        }
    }

    private static boolean runAppCert(Options params, ServiceApi api) {
        HapSignTool.checkEndCertArguments(params);
        return api.generateAppCert(params);
    }

    private static boolean runCa(Options params, ServiceApi api) {
        params.required("keyAlias", "keyAlg", "keySize", "subject", "signAlg", "keystoreFile");
        String keyAlg = params.getString("keyAlg");
        CmdUtil.judgeAlgType(keyAlg);
        String size = params.getString("keySize");
        CmdUtil.judgeSize(size, keyAlg);
        String signAlg = params.getString("signAlg");
        CmdUtil.judgeSignAlgType(signAlg);
        FileUtils.validFileType(params.getString("keystoreFile"), "p12", "jks");
        params.put("keySize", CmdUtil.convertAlgSize(size));
        return api.generateCA(params);
    }

    private static boolean runCert(Options params, ServiceApi api) {
        params.required("keyAlias", "issuer", "issuerKeyAlias", "subject", "keyUsage", "signAlg", "keystoreFile");
        String keyUsage = params.getString("keyUsage");
        CmdUtil.verifyType(keyUsage, "digitalSignature,nonRepudiation,keyEncipherment,dataEncipherment,keyAgreement,certificateSignature,crlSignature,encipherOnly,decipherOnly");
        String extKeyUsage = params.getString("extKeyUsage");
        CmdUtil.verifyType(extKeyUsage, "clientAuthentication,serverAuthentication,codeSignature,emailProtection,smartCardLogin,timestamp,ocspSignature");
        String signAlg = params.getString("signAlg");
        CmdUtil.judgeSignAlgType(signAlg);
        FileUtils.validFileType(params.getString("keystoreFile"), "p12", "jks");
        if (params.containsKey("issuerKeystoreFile")) {
            String issuerKeyStoreFile = params.getString("issuerKeystoreFile");
            FileUtils.validFileType(issuerKeyStoreFile, "p12", "jks");
        }
        return api.generateCert(params);
    }

    private static boolean runCsr(Options params, ServiceApi api) {
        params.required("keyAlias", "subject", "signAlg", "keystoreFile");
        String signAlg = params.getString("signAlg");
        CmdUtil.judgeSignAlgType(signAlg);
        FileUtils.validFileType(params.getString("keystoreFile"), "p12", "jks");
        if (!StringUtils.isEmpty(params.getString("outFile"))) {
            FileUtils.validFileType(params.getString("outFile"), "csr");
        }
        return api.generateCsr(params);
    }

    private static boolean runKeypair(Options params, ServiceApi api) {
        params.required("keyAlias", "keyAlg", "keySize", "keystoreFile");
        String keyAlg = params.getString("keyAlg");
        CmdUtil.judgeAlgType(keyAlg);
        String size = params.getString("keySize");
        CmdUtil.judgeSize(size, keyAlg);
        params.put("keySize", CmdUtil.convertAlgSize(size));
        FileUtils.validFileType(params.getString("keystoreFile"), "p12", "jks");
        return api.generateKeyStore(params);
    }

    private static boolean runProfileCert(Options params, ServiceApi api) {
        HapSignTool.checkEndCertArguments(params);
        return api.generateProfileCert(params);
    }

    private static boolean runSignApp(Options params, ServiceApi api) {
        params.required("mode", "inFile", "outFile", "signAlg");
        String mode = params.getString("mode");
        if (!(LOCAL_SIGN.equalsIgnoreCase(mode) || REMOTE_SIGN.equalsIgnoreCase(mode) || "remoteResign".equalsIgnoreCase(mode))) {
            CustomException.throwException(ERROR.COMMAND_ERROR, "mode params is incorrect");
        }
        if (LOCAL_SIGN.equalsIgnoreCase(mode)) {
            params.required("keystoreFile", "keyAlias", "appCertFile");
            FileUtils.validFileType(params.getString("keystoreFile"), "p12", "jks");
        }
        HapSignTool.checkProfile(params);
        String inForm = params.getString("inForm", "zip");
        if (!StringUtils.isEmpty(inForm) && !HapSignTool.containsIgnoreCase(inForm)) {
            CustomException.throwException(ERROR.NOT_SUPPORT_ERROR, "inForm params is incorrect");
        }
        String signAlg = params.getString("signAlg");
        CmdUtil.judgeEndSignAlgType(signAlg);
        return api.signHap(params);
    }

    private static void checkProfile(Options params) {
        String inForm = params.getString("inForm");
        String profileFile = params.getString("profileFile");
        String profileSigned = params.getString("profileSigned", SIGNED);
        if ("elf".equalsIgnoreCase(inForm) && StringUtils.isEmpty(profileFile)) {
            return;
        }
        if (!SIGNED.equals(profileSigned) && !NOT_SIGNED.equals(profileSigned)) {
            CustomException.throwException(ERROR.NOT_SUPPORT_ERROR, "profileSigned params is incorrect");
        }
        if (SIGNED.equals(profileSigned)) {
            FileUtils.validFileType(profileFile, "p7b");
        } else {
            FileUtils.validFileType(profileFile, "json");
        }
    }

    private static boolean runSignProfile(Options params, ServiceApi api) {
        params.required("mode", "signAlg", "outFile", "inFile");
        String mode = params.getString("mode");
        if (!LOCAL_SIGN.equalsIgnoreCase(mode) && !REMOTE_SIGN.equalsIgnoreCase(mode)) {
            CustomException.throwException(ERROR.COMMAND_ERROR, "mode params is incorrect");
        }
        if (LOCAL_SIGN.equalsIgnoreCase(mode)) {
            params.required("keystoreFile", "keyAlias", "profileCertFile");
            FileUtils.validFileType(params.getString("keystoreFile"), "p12", "jks");
        }
        String signAlg = params.getString("signAlg");
        CmdUtil.judgeEndSignAlgType(signAlg);
        String outFile = params.getString("outFile");
        FileUtils.validFileType(outFile, "p7b");
        return api.signProfile(params);
    }

    private static boolean runVerifyApp(Options params, ServiceApi api) {
        params.required("inFile", "outCertChain", "outProfile");
        String inForm = params.getString("inForm", "zip");
        if (!HapSignTool.containsIgnoreCase(inForm)) {
            CustomException.throwException(ERROR.NOT_SUPPORT_ERROR, "inForm params must is " + informList);
        }
        FileUtils.validFileType(params.getString("outCertChain"), "cer");
        FileUtils.validFileType(params.getString("outProfile"), "p7b");
        return api.verifyHap(params);
    }

    private static boolean runVerifyProfile(Options params, ServiceApi api) {
        params.required("inFile");
        FileUtils.validFileType(params.getString("inFile"), "p7b");
        String outFile = params.getString("outFile");
        if (!StringUtils.isEmpty(outFile)) {
            FileUtils.validFileType(outFile, "json");
        }
        return api.verifyProfile(params);
    }

    public static void version() {
        LOGGER.info(VERSION);
    }

    public static void help() {
        HelpDocument.printHelp(LOGGER);
    }

    private static boolean containsIgnoreCase(String inForm) {
        for (String s : informList) {
            if (!s.equalsIgnoreCase(inForm)) continue;
            return true;
        }
        return false;
    }

    public static RetMsg signApp(SignAppParameters signAppParameters) {
        try {
            SignToolServiceImpl api;
            if (signAppParameters == null) {
                throw new ParamException("params is null");
            }
            Options options = signAppParameters.toOptions();
            if (HapSignTool.runSignApp(options, api = new SignToolServiceImpl())) {
                return new RetMsg(ERROR.SUCCESS_CODE, "sign app success");
            }
            return new RetMsg(ERROR.SIGN_ERROR, "sign app failed");
        }
        catch (CustomException e) {
            return new RetMsg(e.getError(), e.getMessage());
        }
        catch (ParamException e) {
            return new RetMsg(ERROR.COMMAND_PARAM_ERROR, "paramException : " + e.getMessage());
        }
        catch (Exception e) {
            return new RetMsg(ERROR.UNKNOWN_ERROR, "unknownException : " + e.getMessage());
        }
    }

    public static RetMsg verifyApp(VerifyAppParameters verifyAppParameters) {
        try {
            SignToolServiceImpl api;
            if (verifyAppParameters == null) {
                throw new ParamException("params is null");
            }
            Options options = verifyAppParameters.toOptions();
            if (HapSignTool.runVerifyApp(options, api = new SignToolServiceImpl())) {
                return new RetMsg(ERROR.SUCCESS_CODE, "verify app success");
            }
            return new RetMsg(ERROR.VERIFY_ERROR, "verify app failed");
        }
        catch (CustomException e) {
            return new RetMsg(e.getError(), e.getMessage());
        }
        catch (ParamException e) {
            return new RetMsg(ERROR.COMMAND_PARAM_ERROR, "paramException : " + e.getMessage());
        }
        catch (Exception e) {
            return new RetMsg(ERROR.UNKNOWN_ERROR, "unknownException : " + e.getMessage());
        }
    }

    public static RetMsg signProfile(SignProfileParameters signProfileParameters) {
        try {
            SignToolServiceImpl api;
            if (signProfileParameters == null) {
                throw new ParamException("params is null");
            }
            Options options = signProfileParameters.toOptions();
            if (HapSignTool.runSignProfile(options, api = new SignToolServiceImpl())) {
                return new RetMsg(ERROR.SUCCESS_CODE, "sign profile success");
            }
            return new RetMsg(ERROR.SIGN_ERROR, "sign profile failed");
        }
        catch (CustomException e) {
            return new RetMsg(e.getError(), e.getMessage());
        }
        catch (ParamException e) {
            return new RetMsg(ERROR.COMMAND_PARAM_ERROR, "paramException : " + e.getMessage());
        }
        catch (Exception e) {
            return new RetMsg(ERROR.UNKNOWN_ERROR, "unknownException : " + e.getMessage());
        }
    }

    public static RetMsg verifyProfile(VerifyProfileParameters verifyProfileParameters) {
        try {
            SignToolServiceImpl api;
            if (verifyProfileParameters == null) {
                throw new ParamException("params is null");
            }
            Options options = verifyProfileParameters.toOptions();
            if (HapSignTool.runVerifyProfile(options, api = new SignToolServiceImpl())) {
                return new RetMsg(ERROR.SUCCESS_CODE, "verify profile success");
            }
            return new RetMsg(ERROR.VERIFY_ERROR, "verify profile failed");
        }
        catch (CustomException e) {
            return new RetMsg(e.getError(), e.getMessage());
        }
        catch (ParamException e) {
            return new RetMsg(ERROR.COMMAND_PARAM_ERROR, "paramException : " + e.getMessage());
        }
        catch (Exception e) {
            return new RetMsg(ERROR.UNKNOWN_ERROR, "unknownException : " + e.getMessage());
        }
    }

    static {
        informList.add("bin");
        informList.add("elf");
        informList.add("zip");
    }
}

