/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.datastructure;

import com.ohos.hapsigntool.codesigning.datastructure.SignInfo;
import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;

public class HapInfoSegment {
    private static final int MAGIC_NUM_BYTES = 4;
    private static final int MAGIC_NUM = -1045050266;
    private int magic = -1045050266;
    private SignInfo hapSignInfo;

    public HapInfoSegment() {
        this(-1045050266, new SignInfo(0, 0, 0L, null, null));
    }

    public HapInfoSegment(int magic, SignInfo hapSignInfo) {
        this.magic = magic;
        this.hapSignInfo = hapSignInfo;
    }

    public void setSignInfo(SignInfo signInfo) {
        this.hapSignInfo = signInfo;
    }

    public SignInfo getSignInfo() {
        return this.hapSignInfo;
    }

    public int size() {
        return 4 + this.hapSignInfo.size();
    }

    public byte[] toByteArray() {
        byte[] hapSignInfoByteArray = this.hapSignInfo.toByteArray();
        ByteBuffer bf = ByteBuffer.allocate(4 + hapSignInfoByteArray.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.putInt(this.magic);
        bf.put(hapSignInfoByteArray);
        return bf.array();
    }

    public static HapInfoSegment fromByteArray(byte[] bytes) throws VerifyCodeSignException {
        ByteBuffer bf = ByteBuffer.allocate(bytes.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(bytes);
        bf.rewind();
        int inMagic = bf.getInt();
        if (inMagic != -1045050266) {
            throw new VerifyCodeSignException("Invalid magic number of HapInfoSegment");
        }
        if (bytes.length <= 4) {
            throw new VerifyCodeSignException("Invalid bytes size of HapInfoSegment");
        }
        byte[] hapSignInfoByteArray = new byte[bytes.length - 4];
        bf.get(hapSignInfoByteArray);
        SignInfo inHapSignInfo = SignInfo.fromByteArray(hapSignInfoByteArray);
        if (inHapSignInfo.getDataSize() % 4096L != 0L) {
            throw new VerifyCodeSignException(String.format(Locale.ROOT, "Invalid dataSize number of HapInfoSegment, not a multiple of 4096: %d", inHapSignInfo.getDataSize()));
        }
        if (inHapSignInfo.getExtensionNum() != 1) {
            throw new VerifyCodeSignException("Invalid extensionNum of HapInfoSegment");
        }
        if (inHapSignInfo.getExtensionByType(1) == null) {
            throw new VerifyCodeSignException("No merkle tree extension is found in HapInfoSegment");
        }
        return new HapInfoSegment(inMagic, inHapSignInfo);
    }

    public String toString() {
        return String.format(Locale.ROOT, "HapInfoSegment: magic[%d], signInfo[%s]", this.magic, this.hapSignInfo.toString());
    }
}

