/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.sign;

import com.ohos.hapsigntool.utils.FileUtils;
import java.util.Locale;
import org.bouncycastle.util.Strings;

public class CentralDirectory {
    public static final int BYTE_SIZE_BEFORE_COMPRESSION_METHOD = 10;
    public static final int BYTE_SIZE_BETWEEN_COMPRESSION_MODE_AND_FILE_SIZE = 16;
    public static final int BYTE_SIZE_BETWEEN_FILE_COMMENT_LENGTH_AND_LOCHDR_RELATIVE_OFFSET = 8;
    private final char compressionMethod;
    private final char fileNameLength;
    private final char extraFieldLength;
    private final char fileCommentLength;
    private final long relativeOffsetOfLocalHeader;
    private final byte[] fileName;

    public CentralDirectory(Builder builder) {
        this.compressionMethod = builder.compressionMethod;
        this.fileNameLength = builder.fileNameLength;
        this.extraFieldLength = builder.extraFieldLength;
        this.fileCommentLength = builder.fileCommentLength;
        this.relativeOffsetOfLocalHeader = builder.relativeOffsetOfLocalHeader;
        this.fileName = builder.fileName;
    }

    public boolean isCodeFile() {
        return FileUtils.isRunnableFile(this.getFileName());
    }

    public boolean isUncompressed() {
        return this.compressionMethod == '\u0000';
    }

    public String getFileName() {
        return Strings.fromByteArray(this.fileName);
    }

    public long getRelativeOffsetOfLocalHeader() {
        return this.relativeOffsetOfLocalHeader;
    }

    public char getFileNameLength() {
        return this.fileNameLength;
    }

    public char getExtraFieldLength() {
        return this.extraFieldLength;
    }

    public String toString() {
        return String.format(Locale.ROOT, "CentralDirectory:compressionMode(%d), fileName(%s), relativeOffsetOfLocalHeader(%d), fileNameLength(%d), extraFieldLength(%d), fileCommentLength(%d)", (int)this.compressionMethod, this.getFileName(), this.relativeOffsetOfLocalHeader, (int)this.fileNameLength, (int)this.extraFieldLength, (int)this.fileCommentLength);
    }

    public static class Builder {
        private char compressionMethod;
        private char fileNameLength;
        private char extraFieldLength;
        private char fileCommentLength;
        private long relativeOffsetOfLocalHeader;
        private byte[] fileName;

        public Builder setCompressionMethod(char compressionMethod) {
            this.compressionMethod = compressionMethod;
            return this;
        }

        public Builder setFileNameLength(char fileNameLength) {
            this.fileNameLength = fileNameLength;
            return this;
        }

        public Builder setExtraFieldLength(char extraFieldLength) {
            this.extraFieldLength = extraFieldLength;
            return this;
        }

        public Builder setFileCommentLength(char fileCommentLength) {
            this.fileCommentLength = fileCommentLength;
            return this;
        }

        public Builder setRelativeOffsetOfLocalHeader(long relativeOffsetOfLocalHeader) {
            this.relativeOffsetOfLocalHeader = relativeOffsetOfLocalHeader;
            return this;
        }

        public Builder setFileName(byte[] fileName) {
            this.fileName = fileName;
            return this;
        }

        public CentralDirectory build() {
            return new CentralDirectory(this);
        }
    }
}

