/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.utils;

import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.VerifyException;
import com.ohos.hapsigntool.utils.CertUtils;
import com.ohos.hapsigntool.utils.ValidateUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertChainUtils {
    private static final Logger LOGGER = LogManager.getLogger(CertUtils.class);

    private CertChainUtils() {
    }

    private static CertPath getCertPath(List<X509Certificate> certificates, KeyStore trustStore, X500Principal issuer, BigInteger serial, Date signTime) throws GeneralSecurityException, VerifyException {
        if (certificates.size() != 1 && (issuer != null || serial != null)) {
            X509CertSelector targetCertSelector = new X509CertSelector();
            targetCertSelector.setIssuer(issuer);
            targetCertSelector.setSerialNumber(serial);
            PKIXBuilderParameters params = new PKIXBuilderParameters(trustStore, (CertSelector)targetCertSelector);
            CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(certificates));
            params.addCertStore(certStore);
            params.setDate(signTime);
            params.setRevocationEnabled(false);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            CertPathBuilderResult certPathBuilderResult = certPathBuilder.build(params);
            if (certPathBuilderResult instanceof PKIXCertPathBuilderResult) {
                PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)certPathBuilderResult;
                return result.getCertPath();
            }
            throw new VerifyException("get profile cert path failed");
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCertPath(certificates);
    }

    public static void verifyCertChain(List<X509Certificate> certificates, X500Principal issuer, BigInteger serial, X509Certificate root, Date signTime) throws VerifyException {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            trustStore.setCertificateEntry("root", root);
            CertPath certPath = CertChainUtils.getCertPath(certificates, trustStore, issuer, serial, signTime);
            PKIXParameters params = new PKIXParameters(trustStore);
            params.setRevocationEnabled(false);
            params.setDate(signTime);
            CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters());
            params.addCertStore(certStore);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            CertPathValidatorResult validatorResult = validator.validate(certPath, params);
            ValidateUtils.throwIfNotMatches(validatorResult instanceof PKIXCertPathValidatorResult, ERROR.VERIFY_ERROR, "Validator result not target type");
            if (validatorResult instanceof PKIXCertPathValidatorResult) {
                PKIXCertPathValidatorResult pkixValidatorResult = (PKIXCertPathValidatorResult)validatorResult;
                ValidateUtils.throwIfNotMatches(params.getTrustAnchors().contains(pkixValidatorResult.getTrustAnchor()), ERROR.VERIFY_ERROR, "Anchor is not trusted: " + Base64.getEncoder().encodeToString(pkixValidatorResult.getTrustAnchor().getTrustedCert().getEncoded()));
            } else {
                CustomException.throwException(ERROR.VERIFY_ERROR, "Validator result not target type");
            }
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new VerifyException("Cert chain verify failed! " + exception.getMessage());
        }
    }
}

