/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.zip.UnsignedDecimalUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;

public class EndOfCentralDirectory {
    public static final int EOCD_LENGTH = 22;
    public static final int SIGNATURE = 101010256;
    private int diskNum;
    private int cDStartDiskNum;
    private int thisDiskCDNum;
    private int cDTotal;
    private long cDSize;
    private long offset;
    private int commentLength;
    private byte[] comment;
    private int length;

    public static Optional<EndOfCentralDirectory> getEOCDByBytes(byte[] bytes) {
        return EndOfCentralDirectory.getEOCDByBytes(bytes, 0);
    }

    public static Optional<EndOfCentralDirectory> getEOCDByBytes(byte[] bytes, int offset) {
        EndOfCentralDirectory eocd = new EndOfCentralDirectory();
        int remainingDataLen = bytes.length - offset;
        if (remainingDataLen < 22) {
            return Optional.empty();
        }
        ByteBuffer bf = ByteBuffer.wrap(bytes, offset, remainingDataLen);
        bf.order(ByteOrder.LITTLE_ENDIAN);
        if (bf.getInt() != 101010256) {
            return Optional.empty();
        }
        eocd.setDiskNum(UnsignedDecimalUtil.getUnsignedShort(bf));
        eocd.setcDStartDiskNum(UnsignedDecimalUtil.getUnsignedShort(bf));
        eocd.setThisDiskCDNum(UnsignedDecimalUtil.getUnsignedShort(bf));
        eocd.setcDTotal(UnsignedDecimalUtil.getUnsignedShort(bf));
        eocd.setcDSize(UnsignedDecimalUtil.getUnsignedInt(bf));
        eocd.setOffset(UnsignedDecimalUtil.getUnsignedInt(bf));
        eocd.setCommentLength(UnsignedDecimalUtil.getUnsignedShort(bf));
        if (bf.remaining() != eocd.getCommentLength()) {
            return Optional.empty();
        }
        if (eocd.getCommentLength() > 0) {
            byte[] readComment = new byte[eocd.getCommentLength()];
            bf.get(readComment);
            eocd.setComment(readComment);
        }
        eocd.setLength(22 + eocd.getCommentLength());
        if (bf.remaining() != 0) {
            return Optional.empty();
        }
        return Optional.of(eocd);
    }

    public byte[] toBytes() {
        ByteBuffer bf = ByteBuffer.allocate(this.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.putInt(101010256);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.diskNum);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.cDStartDiskNum);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.thisDiskCDNum);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.cDTotal);
        UnsignedDecimalUtil.setUnsignedInt(bf, this.cDSize);
        UnsignedDecimalUtil.setUnsignedInt(bf, this.offset);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.commentLength);
        if (this.commentLength > 0) {
            bf.put(this.comment);
        }
        return bf.array();
    }

    public static int getEocdLength() {
        return 22;
    }

    public static int getSIGNATURE() {
        return 101010256;
    }

    public int getDiskNum() {
        return this.diskNum;
    }

    public void setDiskNum(int diskNum) {
        this.diskNum = diskNum;
    }

    public int getcDStartDiskNum() {
        return this.cDStartDiskNum;
    }

    public void setcDStartDiskNum(int cDStartDiskNum) {
        this.cDStartDiskNum = cDStartDiskNum;
    }

    public int getThisDiskCDNum() {
        return this.thisDiskCDNum;
    }

    public void setThisDiskCDNum(int thisDiskCDNum) {
        this.thisDiskCDNum = thisDiskCDNum;
    }

    public int getcDTotal() {
        return this.cDTotal;
    }

    public void setcDTotal(int cDTotal) {
        this.cDTotal = cDTotal;
    }

    public long getcDSize() {
        return this.cDSize;
    }

    public void setcDSize(long cDSize) {
        this.cDSize = cDSize;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getCommentLength() {
        return this.commentLength;
    }

    public void setCommentLength(int commentLength) {
        this.commentLength = commentLength;
    }

    public byte[] getComment() {
        return this.comment;
    }

    public void setComment(byte[] comment) {
        this.comment = comment;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

