/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.error.ZipException;
import com.ohos.hapsigntool.zip.CentralDirectory;
import com.ohos.hapsigntool.zip.ZipEntryData;
import com.ohos.hapsigntool.zip.ZipEntryHeader;
import java.util.Arrays;

public class ZipEntry {
    private ZipEntryData zipEntryData;
    private CentralDirectory fileEntryIncentralDirectory;

    public int alignment(int alignNum) throws ZipException {
        int padding = this.calZeroPaddingLengthForEntryExtra();
        int remainder = (int)(((long)this.zipEntryData.getZipEntryHeader().getLength() + this.fileEntryIncentralDirectory.getOffset()) % (long)alignNum);
        if (remainder == 0) {
            return padding;
        }
        int add = alignNum - remainder;
        int newExtraLength = this.zipEntryData.getZipEntryHeader().getExtraLength() + add;
        if (newExtraLength > 65535) {
            throw new ZipException("can not align " + this.zipEntryData.getZipEntryHeader().getFileName());
        }
        this.setEntryHeaderNewExtraLength(newExtraLength);
        this.setCenterDirectoryNewExtraLength(newExtraLength);
        return add;
    }

    private int calZeroPaddingLengthForEntryExtra() throws ZipException {
        int entryExtraLen = this.zipEntryData.getZipEntryHeader().getExtraLength();
        int cdExtraLen = this.fileEntryIncentralDirectory.getExtraLength();
        if (cdExtraLen > entryExtraLen) {
            this.setEntryHeaderNewExtraLength(cdExtraLen);
            return cdExtraLen - entryExtraLen;
        }
        if (cdExtraLen < entryExtraLen) {
            this.setCenterDirectoryNewExtraLength(entryExtraLen);
            return entryExtraLen - cdExtraLen;
        }
        return 0;
    }

    private void setCenterDirectoryNewExtraLength(int newLength) throws ZipException {
        byte[] newCDExtra = this.getAlignmentNewExtra(newLength, this.fileEntryIncentralDirectory.getExtraData());
        this.fileEntryIncentralDirectory.setExtraData(newCDExtra);
        this.fileEntryIncentralDirectory.setExtraLength(newLength);
        this.fileEntryIncentralDirectory.setLength(46 + this.fileEntryIncentralDirectory.getFileNameLength() + this.fileEntryIncentralDirectory.getExtraLength() + this.fileEntryIncentralDirectory.getCommentLength());
    }

    private void setEntryHeaderNewExtraLength(int newLength) throws ZipException {
        ZipEntryHeader zipEntryHeader = this.zipEntryData.getZipEntryHeader();
        byte[] newExtra = this.getAlignmentNewExtra(newLength, zipEntryHeader.getExtraData());
        zipEntryHeader.setExtraData(newExtra);
        zipEntryHeader.setExtraLength(newLength);
        zipEntryHeader.setLength(30 + zipEntryHeader.getExtraLength() + zipEntryHeader.getFileNameLength());
        this.zipEntryData.setLength((long)zipEntryHeader.getLength() + this.zipEntryData.getFileSize() + (long)(this.zipEntryData.getDataDescriptor() == null ? 0 : 16));
    }

    private byte[] getAlignmentNewExtra(int newLength, byte[] old) throws ZipException {
        if (old == null) {
            return new byte[newLength];
        }
        if (newLength < old.length) {
            throw new ZipException("can not align " + this.zipEntryData.getZipEntryHeader().getFileName());
        }
        return Arrays.copyOf(old, newLength);
    }

    public ZipEntryData getZipEntryData() {
        return this.zipEntryData;
    }

    public void setZipEntryData(ZipEntryData zipEntryData) {
        this.zipEntryData = zipEntryData;
    }

    public CentralDirectory getCentralDirectory() {
        return this.fileEntryIncentralDirectory;
    }

    public void setCentralDirectory(CentralDirectory centralDirectory) {
        this.fileEntryIncentralDirectory = centralDirectory;
    }
}

