/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import ohos.Log;
import ohos.Utility;

public class CommandParser {
    public static final String PARSE_MODE_HAPLIST = "hap-list";
    public static final String PARSE_MODE_HAPINFO = "hap-info";
    private static final String CMD_MODE = "--mode";
    private static final String CMD_JSON_PATH = "--json-path";
    private static final String CMD_PROFILE_PATH = "--profile-path";
    private static final String CMD_INDEX_PATH = "--index-path";
    private static final String CMD_JS_PATH = "--js-path";
    private static final String CMD_ETS_PATH = "--ets-path";
    private static final String CMD_HNP_PATH = "--hnp-path";
    private static final String CMD_RPCID_PATH = "--rpcid-path";
    private static final String CMD_RPCID = "--rpcid";
    private static final String CMD_SO_PATH = "--maple-so-path";
    private static final String CMD_SO_DIR = "--maple-so-dir";
    private static final String CMD_ABILITY_SO_PATH = "--ability-so-path";
    private static final String CMD_DEX_PATH = "--dex-path";
    private static final String CMD_ABC_PATH = "--abc-path";
    private static final String CMD_FILE_PATH = "--file-path";
    private static final String CMD_LIB_PATH = "--lib-path";
    private static final String CMD_RES_PATH = "--res-path";
    private static final String CMD_RESOURCES_PATH = "--resources-path";
    private static final String CMD_ASSETS_PATH = "--assets-path";
    private static final String CMD_APK_PATH = "--shell-apk-path";
    private static final String CMD_HAP_PATH = "--hap-path";
    private static final String CMD_APP_PATH = "--app-path";
    private static final String CMD_SIGNATURE_PATH = "--signature-path";
    private static final String CMD_CERTIFICATE_PATH = "--certificate-path";
    private static final String CMD_FORCE = "--force";
    private static final String CMD_OUT_PATH = "--out-path";
    private static final String CMD_PACK_INFO_PATH = "--pack-info-path";
    private static final String CMD_ENCRYPT_PATH = "--encrypt-path";
    private static final String CMD_BIN_PATH = "--bin-path";
    private static final String CMD_JAR_PATH = "--jar-path";
    private static final String CMD_TXT_PATH = "--txt-path";
    private static final String CMD_HAR_PATH = "--har-path";
    private static final String CMD_HSP_PATH = "--hsp-path";
    private static final String CMD_PARSE_MODE = "--p";
    private static final String CMD_PACK_RES_PATH = "--pack-res-path";
    private static final String CMD_UNPACKAPK = "--unpackapk";
    private static final String CMD_UNPACK_CUT_ENTRY_APK = "--unpack-cut_entry";
    private static final String CMD_SHAREDLIBS_PATH = "--shared-libs-path";
    private static final String CMD_ENTRYCARD_PATH = "--entrycard-path";
    private static final String CMD_HAP_LIST = "--hap-list";
    private static final String CMD_HSP_LIST = "--hsp-list";
    private static final String CMD_APP_LIST = "--app-list";
    private static final String CMD_DIR_LIST = "--dir-list";
    private static final String CMD_HQF_LIST = "--hqf-list";
    private static final String CMD_APPQF_PATH = "--appqf-path";
    private static final String CMD_AN_PATH = "--an-path";
    private static final String CMD_AP_PATH = "--ap-path";
    private static final String MAIN_MODULE_LIMIT = "--main-module-limit";
    private static final String NORMAL_MODULE_LIMIT = "--normal-module-limit";
    private static final String TOTAL_LIMIT = "--total-limit";
    private static final String VERSION_CODE = "--version-code";
    private static final String VERSION_NAME = "--version-name";
    private static final String INPUT_LIST = "--input-list";
    private static final String INPUT = "--input";
    private static final String STAT_DUPLICATE = "--stat-duplicate";
    private static final String STAT_SUFFIX = "--stat-suffix";
    private static final String STAT_FILE_SIZE = "--stat-file-size";
    private static final String CMD_COMPRESS_LEVEL = "--compress-level";
    private static final String CMD_PKG_CONTEXT_PATH = "--pkg-context-path";
    private static final String CMD_BUNDLE_NAME = "--bundle-name";
    private static final String PARSER_STAT_DUPLICATE_ERROR = "code:9132600 error:statDuplicate is invalid! Must be true or false.";
    private static final String PARSER_STAT_SUFFIX_ERROR = "code:9132601 error:statSuffix is invalid! Must be true or false.";
    private static final int PARSE_MODE_VALUE_LENGTH = 2;
    private static final Log LOG = new Log(CommandParser.class.toString());
    private static final Map<String, Function<Map.Entry<Utility, String>, Boolean>> commandFuncs = new HashMap<String, Function<Map.Entry<Utility, String>, Boolean>>();

    private static void initCommandFuncs() {
        commandFuncs.put(CMD_MODE, entry -> {
            ((Utility)entry.getKey()).setMode((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_JSON_PATH, entry -> {
            ((Utility)entry.getKey()).setJsonPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_PROFILE_PATH, entry -> {
            ((Utility)entry.getKey()).setProfilePath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_INDEX_PATH, entry -> {
            ((Utility)entry.getKey()).setIndexPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_JS_PATH, entry -> {
            ((Utility)entry.getKey()).setJsPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_ETS_PATH, entry -> {
            ((Utility)entry.getKey()).setEtsPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_HNP_PATH, entry -> {
            ((Utility)entry.getKey()).setHnpPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_RPCID_PATH, entry -> {
            ((Utility)entry.getKey()).setRpcidPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_RPCID, entry -> {
            ((Utility)entry.getKey()).setRpcid((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_SO_PATH, entry -> {
            ((Utility)entry.getKey()).setSoPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_SO_DIR, entry -> {
            ((Utility)entry.getKey()).setSoDir((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_ABILITY_SO_PATH, entry -> {
            ((Utility)entry.getKey()).setAbilitySoPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_DEX_PATH, entry -> {
            ((Utility)entry.getKey()).setDexPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_ABC_PATH, entry -> {
            ((Utility)entry.getKey()).setAbcPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_FILE_PATH, entry -> {
            ((Utility)entry.getKey()).setFilePath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_LIB_PATH, entry -> {
            ((Utility)entry.getKey()).setLibPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_RES_PATH, entry -> {
            ((Utility)entry.getKey()).setResPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_RESOURCES_PATH, entry -> {
            ((Utility)entry.getKey()).setResourcesPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_ASSETS_PATH, entry -> {
            ((Utility)entry.getKey()).setAssetsPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_APK_PATH, entry -> {
            ((Utility)entry.getKey()).setApkPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_HAP_PATH, entry -> {
            ((Utility)entry.getKey()).setHapPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_APP_PATH, entry -> {
            ((Utility)entry.getKey()).setAppPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_SIGNATURE_PATH, entry -> {
            ((Utility)entry.getKey()).setSignaturePath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_CERTIFICATE_PATH, entry -> {
            ((Utility)entry.getKey()).setCertificatePath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_FORCE, entry -> {
            ((Utility)entry.getKey()).setForceRewrite((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_OUT_PATH, entry -> {
            ((Utility)entry.getKey()).setOutPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_PACK_INFO_PATH, entry -> {
            ((Utility)entry.getKey()).setPackInfoPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_ENCRYPT_PATH, entry -> {
            ((Utility)entry.getKey()).setEncryptPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_BIN_PATH, entry -> {
            ((Utility)entry.getKey()).setBinPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_JAR_PATH, entry -> {
            ((Utility)entry.getKey()).setJarPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_TXT_PATH, entry -> {
            ((Utility)entry.getKey()).setTxtPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_HAR_PATH, entry -> {
            ((Utility)entry.getKey()).setHarPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_HSP_PATH, entry -> {
            ((Utility)entry.getKey()).setHspPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_PACK_RES_PATH, entry -> {
            ((Utility)entry.getKey()).setPackResPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_UNPACKAPK, entry -> {
            ((Utility)entry.getKey()).setUnpackApk((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_UNPACK_CUT_ENTRY_APK, entry -> {
            ((Utility)entry.getKey()).setUnpackCutEntryApk((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_SHAREDLIBS_PATH, entry -> {
            ((Utility)entry.getKey()).setSharedLibsPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_ENTRYCARD_PATH, entry -> {
            ((Utility)entry.getKey()).setEntryCardPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_HAP_LIST, entry -> {
            ((Utility)entry.getKey()).setHapList((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_HSP_LIST, entry -> {
            ((Utility)entry.getKey()).setHspList((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_APP_LIST, entry -> {
            ((Utility)entry.getKey()).setAppList((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_DIR_LIST, entry -> {
            ((Utility)entry.getKey()).setDirList((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_HQF_LIST, entry -> {
            ((Utility)entry.getKey()).setHqfList((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_APPQF_PATH, entry -> {
            ((Utility)entry.getKey()).setAPPQFPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_AN_PATH, entry -> {
            ((Utility)entry.getKey()).setANPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_AP_PATH, entry -> {
            ((Utility)entry.getKey()).setAPPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(MAIN_MODULE_LIMIT, entry -> {
            ((Utility)entry.getKey()).setMainModuleLimit((String)entry.getValue());
            return true;
        });
        commandFuncs.put(NORMAL_MODULE_LIMIT, entry -> {
            ((Utility)entry.getKey()).setNormalModuleLimit((String)entry.getValue());
            return true;
        });
        commandFuncs.put(TOTAL_LIMIT, entry -> {
            ((Utility)entry.getKey()).setTotalLimit((String)entry.getValue());
            return true;
        });
        commandFuncs.put(VERSION_CODE, entry -> {
            try {
                ((Utility)entry.getKey()).setVersionCode(Integer.parseInt((String)entry.getValue()));
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("CommandParser::--version-code value must be number.");
                return false;
            }
            return true;
        });
        commandFuncs.put(VERSION_NAME, entry -> {
            ((Utility)entry.getKey()).setVersionName((String)entry.getValue());
            return true;
        });
        commandFuncs.put(INPUT_LIST, entry -> {
            ((Utility)entry.getKey()).setInputList((String)entry.getValue());
            return true;
        });
        commandFuncs.put(INPUT, entry -> {
            ((Utility)entry.getKey()).setInput((String)entry.getValue());
            return true;
        });
        commandFuncs.put(STAT_DUPLICATE, entry -> {
            if (Boolean.TRUE.toString().equals(entry.getValue()) || Boolean.FALSE.toString().equals(entry.getValue())) {
                ((Utility)entry.getKey()).setStatDuplicate(Boolean.parseBoolean((String)entry.getValue()));
                return true;
            }
            LOG.error(PARSER_STAT_DUPLICATE_ERROR);
            return false;
        });
        commandFuncs.put(STAT_SUFFIX, entry -> {
            if (Boolean.TRUE.toString().equals(entry.getValue()) || Boolean.FALSE.toString().equals(entry.getValue())) {
                ((Utility)entry.getKey()).setStatSuffix(Boolean.parseBoolean((String)entry.getValue()));
                return true;
            }
            LOG.error(PARSER_STAT_SUFFIX_ERROR);
            return false;
        });
        commandFuncs.put(STAT_FILE_SIZE, entry -> {
            ((Utility)entry.getKey()).setStatFileSize((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_COMPRESS_LEVEL, entry -> {
            String string = (String)entry.getValue();
            try {
                int n = Integer.parseInt(string);
                if (n < 1 || n > 9) {
                    LOG.error("CommandParser::--compress-level value must be number between 1-9");
                    return false;
                }
                ((Utility)entry.getKey()).setCompressLevel(n);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("CommandParser::--compress-level value must be number between 1-9");
                return false;
            }
        });
        commandFuncs.put(CMD_PKG_CONTEXT_PATH, entry -> {
            ((Utility)entry.getKey()).setPkgContextPath((String)entry.getValue());
            return true;
        });
        commandFuncs.put(CMD_BUNDLE_NAME, entry -> {
            ((Utility)entry.getKey()).setBundleName((String)entry.getValue());
            return true;
        });
    }

    public static boolean commandParser(Utility utility, String[] stringArray) {
        if (stringArray == null) {
            LOG.error("CommandParser::commandParser args is null!");
            return false;
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            AbstractMap.SimpleEntry<Utility, String> simpleEntry = new AbstractMap.SimpleEntry<Utility, String>(utility, string2);
            if (commandFuncs.get(string) != null) {
                commandFuncs.get(string).apply(simpleEntry);
                ++i;
                continue;
            }
            if (CMD_PARSE_MODE.equals(string)) {
                if (i + 2 >= stringArray.length) {
                    LOG.error("input wrong number value for --p command");
                    return false;
                }
                utility.setParseMode(stringArray[i + 1]);
                if (PARSE_MODE_HAPLIST.equals(utility.getParseMode())) {
                    utility.setDeviceType(stringArray[i + 2]);
                } else if (PARSE_MODE_HAPINFO.equals(utility.getParseMode())) {
                    utility.setHapName(stringArray[i + 2]);
                }
                i += 2;
                continue;
            }
            LOG.warning(string + " is invalid!");
        }
        return true;
    }

    static {
        CommandParser.initCommandFuncs();
    }
}

