/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import ohos.APPQFResult;
import ohos.BundleException;
import ohos.CommandParser;
import ohos.Log;
import ohos.ResourceIndexResult;
import ohos.ShowHelp;
import ohos.Uncompress;
import ohos.UncompressResult;
import ohos.UncompressVerify;
import ohos.Utility;

public class UncompressEntrance {
    public static final String PARSE_MODE_HAPLIST = "hap-list";
    public static final String PARSE_MODE_HAPINFO = "hap-info";
    public static final String PARSE_MODE_ALL = "all";
    public static final String DEVICE_TYPE_DEFAULT = "default";
    public static final String DEVICE_TYPE_PHONE = "phone";
    public static final String DEVICE_TYPE_TABLET = "tablet";
    public static final String DEVICE_TYPE_TV = "tv";
    public static final String DEVICE_TYPE_CAR = "car";
    public static final String DEVICE_TYPE_SMARTWATCH = "smartWatch";
    public static final String DEVICE_TYPE_FITNESSWATCH = "fitnessWatch";
    public static final String DEVICE_TYPE_FITNESSBAND = "fitnessBand";
    private static final String APPQF_SUFFIX = ".appqf";
    private static final String APP_SUFFIX = ".app";
    private static final String HAP_SUFFIX = ".hap";
    private static final String HSP_SUFFIX = ".hsp";
    private static final int EXIT_STATUS_NORMAL = 0;
    private static final int EXIT_STATUS_EXCEPTION = 1;
    private static final Log LOG = new Log(UncompressEntrance.class.toString());

    public static boolean unpack(String string, String string2, String string3, boolean bl) {
        if (string == null || string.isEmpty()) {
            LOG.error("UncompressEntrance::unpack appPath is invalid!");
            return false;
        }
        if (string2 == null || string2.isEmpty()) {
            LOG.error("UncompressEntrance::unpack outPath is invalid!");
            return false;
        }
        Utility utility = new Utility();
        utility.setMode("app");
        utility.setAppPath(string);
        utility.setDeviceType(string3 == null ? "" : string3);
        utility.setOutPath(string2);
        utility.setUnpackApk(String.valueOf(bl));
        utility.setForceRewrite("true");
        if (!UncompressVerify.commandVerify(utility)) {
            LOG.error("CompressEntrance::unpack verity failed");
            return false;
        }
        if (!Uncompress.unpackageProcess(utility)) {
            LOG.error("UncompressEntrance::unpackageProcess failed");
            return false;
        }
        return true;
    }

    public static boolean unpackHap(String string, String string2, boolean bl) {
        if (string == null || string.isEmpty()) {
            LOG.error("UncompressEntrance::unpackHap hapPath is invalid!");
            return false;
        }
        if (string2 == null || string2.isEmpty()) {
            LOG.error("UncompressEntrance::unpackHap outPath is invalid!");
            return false;
        }
        Utility utility = new Utility();
        utility.setMode("hap");
        utility.setHapPath(string);
        utility.setDeviceType("");
        utility.setOutPath(string2);
        utility.setUnpackApk(String.valueOf(bl));
        utility.setForceRewrite("true");
        if (!UncompressVerify.commandVerify(utility)) {
            LOG.error("CompressEntrance::unpackHap verity failed");
            return false;
        }
        if (!Uncompress.unpackageProcess(utility)) {
            LOG.error("UncompressEntrance::unpackageProcess failed");
            return false;
        }
        return true;
    }

    public static UncompressResult parseApp(String string, String string2, String string3, String string4, String string5) {
        UncompressResult uncompressResult = new UncompressResult();
        Utility utility = new Utility();
        utility.setAppPath(string);
        utility.setParseMode(string2);
        utility.setDeviceType(string3 == null ? "" : string3);
        utility.setHapName(string4 == null ? "" : string4);
        if (!UncompressVerify.isPathValid(utility.getAppPath(), true, APP_SUFFIX)) {
            LOG.error("UncompressEntrance::parseApp must input a app file!");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseApp verify failed");
            return uncompressResult;
        }
        if (!UncompressVerify.isParseAppModeValid(utility.getParseMode(), utility.getHapName())) {
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseApp verify failed");
            return uncompressResult;
        }
        uncompressResult = Uncompress.uncompressAppByPath(utility);
        return uncompressResult;
    }

    public static UncompressResult parseApp(InputStream inputStream, String string, String string2, String string3, String string4) {
        UncompressResult uncompressResult = new UncompressResult();
        if (inputStream == null) {
            LOG.error("UncompressEntrance::parseApp input is null!");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseApp input is null");
            return uncompressResult;
        }
        Utility utility = new Utility();
        utility.setMode("app");
        utility.setParseMode(string);
        utility.setDeviceType(string2 == null ? "" : string2);
        utility.setHapName(string3 == null ? "" : string3);
        if (!UncompressVerify.isParseAppModeValid(utility.getParseMode(), utility.getHapName())) {
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseApp verify failed");
            return uncompressResult;
        }
        uncompressResult = Uncompress.uncompressAppByInput(utility, inputStream);
        return uncompressResult;
    }

    public static UncompressResult parseApp(String string, ParseAppMode parseAppMode, String string2) {
        UncompressResult uncompressResult = new UncompressResult();
        Utility utility = new Utility();
        utility.setAppPath(string);
        utility.setParseMode(parseAppMode.getType());
        utility.setDeviceType("");
        utility.setHapName(string2);
        if (!UncompressVerify.isPathValid(utility.getAppPath(), true, APP_SUFFIX)) {
            LOG.error("UncompressEntrance::parseApp must input a app file!");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseApp verify failed");
            return uncompressResult;
        }
        if (!UncompressVerify.isParseAppModeValid(utility.getParseMode(), utility.getHapName())) {
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseApp verify failed");
            return uncompressResult;
        }
        uncompressResult = Uncompress.uncompressAppByPath(utility);
        return uncompressResult;
    }

    public static UncompressResult parseApp(InputStream inputStream, ParseAppMode parseAppMode, String string) {
        UncompressResult uncompressResult = new UncompressResult();
        if (inputStream == null) {
            LOG.error("UncompressEntrance::parseApp input is null!");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseApp input is null");
            return uncompressResult;
        }
        Utility utility = new Utility();
        utility.setParseMode(parseAppMode.getType());
        utility.setDeviceType("");
        utility.setHapName(string);
        if (!UncompressVerify.isParseAppModeValid(utility.getParseMode(), utility.getHapName())) {
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseApp verify failed");
            return uncompressResult;
        }
        uncompressResult = Uncompress.uncompressAppByInput(utility, inputStream);
        return uncompressResult;
    }

    public static UncompressResult parseHap(String string) {
        UncompressResult uncompressResult = new UncompressResult();
        Utility utility = new Utility();
        utility.setHapPath(string);
        if (!UncompressVerify.isPathValid(utility.getHapPath(), true, HAP_SUFFIX) && !UncompressVerify.isPathValid(utility.getHapPath(), true, HSP_SUFFIX)) {
            LOG.error("UncompressEntrance::parseHap must input a hap file!");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseHap hapPath is invalid");
        }
        uncompressResult = Uncompress.uncompressHap(utility);
        return uncompressResult;
    }

    public static UncompressResult parseHap(InputStream inputStream) {
        UncompressResult uncompressResult = new UncompressResult();
        if (inputStream == null) {
            LOG.error("UncompressEntrance::parseHap input is null!");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseHap input is null");
            return uncompressResult;
        }
        Utility utility = new Utility();
        uncompressResult = Uncompress.uncompressHapByInput(utility, inputStream);
        return uncompressResult;
    }

    public static List<ResourceIndexResult> parseResource(String string) throws BundleException, IOException {
        return Uncompress.getResourceFromHap(string);
    }

    public static APPQFResult parseAPPQF(String string) {
        APPQFResult aPPQFResult = new APPQFResult();
        if (!string.endsWith(APPQF_SUFFIX)) {
            LOG.error("UncompressEntrance::parseAPPQF Error, input wrong type APPQF file!");
            aPPQFResult.setSuccess(false);
        }
        try {
            aPPQFResult.setHqfInfoList(Uncompress.parseAPPQFFile(string));
            aPPQFResult.setSuccess(true);
        }
        catch (BundleException bundleException) {
            LOG.error("UncompressEntrance::parseAPPQF failed, read patch.json in APPQF file failed!");
            aPPQFResult.setSuccess(false);
        }
        return aPPQFResult;
    }

    public static void main(String[] stringArray) {
        Utility utility = new Utility();
        if (!CommandParser.commandParser(utility, stringArray)) {
            LOG.error("UncompressEntrance::main exit, parser failed");
            ShowHelp.uncompressHelp();
            System.exit(1);
        }
        if (!UncompressVerify.commandVerify(utility)) {
            LOG.error("UncompressEntrance::main exit, verify failed");
            ShowHelp.uncompressHelp();
            System.exit(1);
        }
        if (!Uncompress.unpackageProcess(utility)) {
            LOG.error("UncompressEntrance::main exit, uncompress failed");
            ShowHelp.uncompressHelp();
            System.exit(1);
        }
        System.exit(0);
    }

    public static enum ParseAppMode {
        ALL(0, "all"),
        HAP_LIST(1, "hap-list"),
        HAP_INFO(2, "hap-info");

        private final int index;
        private final String type;

        private ParseAppMode(int n2, String string2) {
            this.index = n2;
            this.type = string2;
        }

        public static String getType(int n) {
            for (ParseAppMode parseAppMode : ParseAppMode.values()) {
                if (parseAppMode.getIndex() != n) continue;
                return parseAppMode.type;
            }
            return "";
        }

        public int getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }
    }
}

