/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.datastructure;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;

public class SignedFilePos {
    private int fileNameOffset;
    private final int fileNameSize;
    private int signInfoOffset;
    private final int signInfoSize;

    public SignedFilePos(int fileNameOffset, int fileNameSize, int signInfoOffset, int signInfoSize) {
        this.fileNameOffset = fileNameOffset;
        this.fileNameSize = fileNameSize;
        this.signInfoOffset = signInfoOffset;
        this.signInfoSize = signInfoSize;
    }

    public int getFileNameOffset() {
        return this.fileNameOffset;
    }

    public int getFileNameSize() {
        return this.fileNameSize;
    }

    public int getSignInfoOffset() {
        return this.signInfoOffset;
    }

    public int getSignInfoSize() {
        return this.signInfoSize;
    }

    public void increaseFileNameOffset(int incOffset) {
        this.fileNameOffset += incOffset;
    }

    public void increaseSignInfoOffset(int incOffset) {
        this.signInfoOffset += incOffset;
    }

    public static SignedFilePos fromByteArray(byte[] bytes) {
        ByteBuffer bf = ByteBuffer.allocate(bytes.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(bytes);
        bf.rewind();
        int inFileNameOffset = bf.getInt();
        int inFileNameSize = bf.getInt();
        int inSignInfoOffset = bf.getInt();
        int inSignInfoSize = bf.getInt();
        return new SignedFilePos(inFileNameOffset, inFileNameSize, inSignInfoOffset, inSignInfoSize);
    }

    public String toString() {
        return String.format(Locale.ROOT, "SignedFilePos: fileNameOffset, Size[%d, %d], signInfoOffset, Size[%d, %d]", this.fileNameOffset, this.fileNameSize, this.signInfoOffset, this.signInfoSize);
    }
}

