/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.fsverity;

import com.ohos.hapsigntool.codesigning.exception.FsVerityDigestException;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityDescriptor;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityDigest;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityHashAlgorithm;
import com.ohos.hapsigntool.codesigning.fsverity.MerkleTree;
import com.ohos.hapsigntool.codesigning.fsverity.MerkleTreeBuilder;
import com.ohos.hapsigntool.codesigning.utils.DigestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;

public class FsVerityGenerator {
    private static final FsVerityHashAlgorithm FS_VERITY_HASH_ALGORITHM = FsVerityHashAlgorithm.SHA256;
    private static final byte LOG_2_OF_FSVERITY_HASH_PAGE_SIZE = 12;
    protected byte[] salt = null;
    private byte[] fsVerityDigest = null;
    private byte[] treeBytes = null;
    private byte[] rootHash = null;

    public MerkleTree generateMerkleTree(InputStream inputStream, long size, FsVerityHashAlgorithm fsVerityHashAlgorithm) throws FsVerityDigestException {
        MerkleTree merkleTree;
        try (MerkleTreeBuilder builder = new MerkleTreeBuilder();){
            merkleTree = builder.generateMerkleTree(inputStream, size, fsVerityHashAlgorithm);
        }
        catch (IOException e) {
            throw new FsVerityDigestException("IOException: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new FsVerityDigestException("Invalid algorithm:" + e.getMessage());
        }
        return merkleTree;
    }

    public void generateFsVerityDigest(InputStream inputStream, long size, long fsvTreeOffset) throws FsVerityDigestException {
        byte[] digest;
        MerkleTree merkleTree = size == 0L ? new MerkleTree(null, null, FS_VERITY_HASH_ALGORITHM) : this.generateMerkleTree(inputStream, size, FS_VERITY_HASH_ALGORITHM);
        int flags = fsvTreeOffset == 0L ? 0 : 1;
        FsVerityDescriptor.Builder builder = new FsVerityDescriptor.Builder().setFileSize(size).setHashAlgorithm(FS_VERITY_HASH_ALGORITHM.getId()).setLog2BlockSize((byte)12).setSaltSize((byte)this.getSaltSize()).setSalt(this.salt).setRawRootHash(merkleTree.rootHash).setFlags(flags).setMerkleTreeOffset(fsvTreeOffset);
        byte[] fsVerityDescriptor = builder.build().getByteForGenerateDigest();
        try {
            digest = DigestUtils.computeDigest(fsVerityDescriptor, FS_VERITY_HASH_ALGORITHM.getHashAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new FsVerityDigestException("Invalid algorithm" + e.getMessage(), e);
        }
        this.fsVerityDigest = FsVerityDigest.getFsVerityDigest(FS_VERITY_HASH_ALGORITHM.getId(), digest);
        this.treeBytes = merkleTree.tree;
        this.rootHash = merkleTree.rootHash;
    }

    public byte[] getFsVerityDigest() {
        return this.fsVerityDigest;
    }

    public byte[] getTreeBytes() {
        return this.treeBytes;
    }

    public byte[] getRootHash() {
        return this.rootHash;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getSaltSize() {
        return this.salt == null ? 0 : this.salt.length;
    }

    public static byte getFsVerityHashAlgorithm() {
        return FS_VERITY_HASH_ALGORITHM.getId();
    }

    public static byte getLog2BlockSize() {
        return 12;
    }
}

